/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ManagedTableListener;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.connectors.DynamicSinkUtils;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.ParserFactory;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.reuse.SubplanReuser$;
import org.apache.flink.table.planner.plan.utils.SameRelObjectShuttle;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.planner.sinks.TableSinkUtils$;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r%c!B\u0001\u0003\u0003\u0003y!a\u0003)mC:tWM\u001d\"bg\u0016T!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eYR\"\u0001\u000e\u000b\u0005\r1\u0011B\u0001\u000f\u001b\u0005\u001d\u0001F.\u00198oKJD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\tKb,7-\u001e;peB\u0011\u0011\u0004I\u0005\u0003Ci\u0011\u0001\"\u0012=fGV$xN\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005YA/\u00192mK\u000e{gNZ5h!\t)\u0003&D\u0001'\u0015\t9c!A\u0002ba&L!!\u000b\u0014\u0003\u0017Q\u000b'\r\\3D_:4\u0017n\u001a\u0005\tW\u0001\u0011)\u0019!C\u0001Y\u0005iQn\u001c3vY\u0016l\u0015M\\1hKJ,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\ta!\\8ek2,\u0017B\u0001\u001a0\u00055iu\u000eZ;mK6\u000bg.Y4fe\"AA\u0007\u0001B\u0001B\u0003%Q&\u0001\bn_\u0012,H.Z'b]\u0006<WM\u001d\u0011\t\u0011Y\u0002!Q1A\u0005\u0002]\nqBZ;oGRLwN\\\"bi\u0006dwnZ\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\u00111HB\u0001\bG\u0006$\u0018\r\\8h\u0013\ti$HA\bGk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h\u0011!y\u0004A!A!\u0002\u0013A\u0014\u0001\u00054v]\u000e$\u0018n\u001c8DCR\fGn\\4!\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015AD2bi\u0006dwnZ'b]\u0006<WM]\u000b\u0002\u0007B\u0011\u0011\bR\u0005\u0003\u000bj\u0012abQ1uC2|w-T1oC\u001e,'\u000f\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003D\u0003=\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\u0003\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002\u001f%\u001c8\u000b\u001e:fC6LgnZ'pI\u0016\u0004\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013qAQ8pY\u0016\fg\u000eC\u0003R\u0001\u0011\u0005!+\u0001\u0004=S:LGO\u0010\u000b\b'V3v\u000bW-[!\t!\u0006!D\u0001\u0003\u0011\u0015q\u0002\u000b1\u0001 \u0011\u0015\u0019\u0003\u000b1\u0001%\u0011\u0015Y\u0003\u000b1\u0001.\u0011\u00151\u0004\u000b1\u00019\u0011\u0015\t\u0005\u000b1\u0001D\u0011\u0015I\u0005\u000b1\u0001K\u0011%a\u0006\u00011AA\u0002\u0013%Q,\u0001\u0004qCJ\u001cXM]\u000b\u0002=B\u0011\u0011dX\u0005\u0003Aj\u0011a\u0001U1sg\u0016\u0014\b\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0003d\u0003)\u0001\u0018M]:fe~#S-\u001d\u000b\u0003I\u001e\u0004\"aS3\n\u0005\u0019d%\u0001B+oSRDq\u0001[1\u0002\u0002\u0003\u0007a,A\u0002yIEB\u0011B\u001b\u0001A\u0002\u0003\u0005\u000b\u0015\u00020\u0002\u000fA\f'o]3sA!9A\u000e\u0001a\u0001\n\u0013i\u0017AD2veJ,g\u000e\u001e#jC2,7\r^\u000b\u0002]B\u0011Qe\\\u0005\u0003a\u001a\u0012!bU9m\t&\fG.Z2u\u0011\u001d\u0011\b\u00011A\u0005\nM\f!cY;se\u0016tG\u000fR5bY\u0016\u001cGo\u0018\u0013fcR\u0011A\r\u001e\u0005\bQF\f\t\u00111\u0001o\u0011\u00191\b\u0001)Q\u0005]\u0006y1-\u001e:sK:$H)[1mK\u000e$\b\u0005\u0003\u0005y\u0001\t\u0007I\u0011\u0001\u0005z\u00039\u0001H.\u00198oKJ\u001cuN\u001c;fqR,\u0012A\u001f\t\u0003)nL!\u0001 \u0002\u0003\u001dAc\u0017M\u001c8fe\u000e{g\u000e^3yi\"1a\u0010\u0001Q\u0001\ni\fq\u0002\u001d7b]:,'oQ8oi\u0016DH\u000f\t\u0015\u0004{\u0006\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0001\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0003\u0002\u0006\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\t\u0011\u0005=\u0001\u0001\"\u0001\t\u0003#\tQbZ3u%\u0016d')^5mI\u0016\u0014XCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\t\u000591-\u00197dSR,\u0017\u0002BA\u000f\u0003/\u0011qB\u00127j].\u0014V\r\u001c\"vS2$WM\u001d\u0005\t\u0003C\u0001A\u0011\u0001\u0005\u0002$\u0005\u00112M]3bi\u00164E.\u001b8l!2\fgN\\3s+\t\t)\u0003\u0005\u0003\u0002\u0016\u0005\u001d\u0012\u0002BA\u0015\u0003/\u0011\u0001C\u00127j].\u0004F.\u00198oKJLU\u000e\u001d7)\t\u0005}\u0011\u0011\u0001\u0005\t\u0003_\u0001A\u0011\u0001\u0005\u00022\u0005qq-\u001a;UsB,g)Y2u_JLXCAA\u001a!\u0011\t)\"!\u000e\n\t\u0005]\u0012q\u0003\u0002\u0011\r2Lgn\u001b+za\u00164\u0015m\u0019;pefDq!a\u000f\u0001\r#\ti$\u0001\u0007hKR$&/Y5u\t\u001647/\u0006\u0002\u0002@A)1*!\u0011\u0002F%\u0019\u00111\t'\u0003\u000b\u0005\u0013(/Y=1\t\u0005\u001d\u0013\u0011\f\t\u0007\u0003\u0013\n\t&!\u0016\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA\u0001\u001d7b]*\u0019\u0011\u0011\u0004\u0006\n\t\u0005M\u00131\n\u0002\f%\u0016dGK]1ji\u0012+g\r\u0005\u0003\u0002X\u0005eC\u0002\u0001\u0003\r\u00037\nI$!A\u0001\u0002\u000b\u0005\u0011Q\f\u0002\u0004?\u0012\n\u0014\u0003BA0\u0003K\u00022aSA1\u0013\r\t\u0019\u0007\u0014\u0002\b\u001d>$\b.\u001b8h!\u0011\tI%a\u001a\n\t\u0005%\u00141\n\u0002\t%\u0016dGK]1ji\"9\u0011Q\u000e\u0001\u0007\u0012\u0005=\u0014\u0001D4fi>\u0003H/[7ju\u0016\u0014XCAA9!\u0011\t\u0019(a\u001f\u000e\u0005\u0005U$\u0002BA<\u0003s\n\u0001b\u001c9uS6L'0\u001a\u0006\u0004\u0003\u001b\"\u0011\u0002BA?\u0003k\u0012\u0011b\u00149uS6L'0\u001a:\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\u0006qq-\u001a;UC\ndWmQ8oM&<W#\u0001\u0013\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006yq-\u001a;GY&t7nQ8oi\u0016DH/\u0006\u0002\u0002\fB!\u0011QCAG\u0013\u0011\ty)a\u0006\u0003\u0019\u0019c\u0017N\\6D_:$X\r\u001f;\t\u0011\u0005M\u0005\u0001\"\u0001\t\u0003+\u000b!bZ3u\u000bb,7-\u00128w+\t\t9\n\u0005\u0003\u0002\u001a\u0006\u0015VBAAN\u0015\u0011\ti*a(\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0006\u0004O\u0005\u0005&bAAR\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003O\u000bYJ\u0001\u000eTiJ,\u0017-\\#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG\u000f\u000b\u0005\u0002\u0012\u0006-\u0016\u0011WAn!\rY\u0015QV\u0005\u0004\u0003_c%A\u00033faJ,7-\u0019;fIFJ1%a-\u0002J\u0006E\u00171\u001a\t\u0005\u0003k\u000b\u0019M\u0004\u0003\u00028\u0006}\u0006cAA]\u00196\u0011\u00111\u0018\u0006\u0004\u0003{s\u0011A\u0002\u001fs_>$h(C\u0002\u0002B2\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAc\u0003\u000f\u0014aa\u0015;sS:<'bAAa\u0019&!\u00111ZAg\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011q\u001a'\u0002\u0015\u0011,\u0007O]3dCR,G-M\u0005$\u0003'\f).a6\u0002P:\u00191*!6\n\u0007\u0005=G*M\u0003#\u00172\u000bINA\u0003tG\u0006d\u0017-M\u0005$\u0003g\u000bi.!9\u0002`&!\u0011q\\Ag\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eEJ1%a5\u0002V\u0006\r\u0018qZ\u0019\u0006E-c\u0015\u0011\u001c\u0005\u0007\u0003O\u0004A\u0011A/\u0002\u001f\r\u0014X-\u0019;f\u001d\u0016<\b+\u0019:tKJDq!a;\u0001\t\u0003\ni/A\u0005hKR\u0004\u0016M]:feR\ta\fC\u0004\u0002r\u0002!\t%a=\u0002\u0013Q\u0014\u0018M\\:mCR,G\u0003BA{\u0005?\u0001b!a>\u0002~\n\u0005QBAA}\u0015\r\tY\u0010F\u0001\u0005kRLG.\u0003\u0003\u0002\u0000\u0006e(\u0001\u0002'jgR\u0004DAa\u0001\u0003\u0014A1!Q\u0001B\u0007\u0005#i!Aa\u0002\u000b\t\t%!1B\u0001\u0004I\u0006<'BA\u0014\t\u0013\u0011\u0011yAa\u0002\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]B!\u0011q\u000bB\n\t1\u0011)\"a<\u0002\u0002\u0003\u0005)\u0011\u0001B\f\u0005\ryFEM\t\u0005\u0003?\u0012I\u0002E\u0002L\u00057I1A!\bM\u0005\r\te.\u001f\u0005\t\u0005C\ty\u000f1\u0001\u0003$\u0005\u0001Rn\u001c3jMf|\u0005/\u001a:bi&|gn\u001d\t\u0007\u0003o\fiP!\n\u0011\t\t\u001d\"QF\u0007\u0003\u0005SQ1Aa\u000b\u0007\u0003)y\u0007/\u001a:bi&|gn]\u0005\u0005\u0005_\u0011ICA\bN_\u0012Lg-_(qKJ\fG/[8o\u0011!\u0011\u0019\u0004\u0001C\u0001\u0011\tU\u0012A\u0004;sC:\u001cH.\u0019;f)>\u0014V\r\u001c\u000b\u0005\u0005o\u0011\u0019\u0005\u0005\u0003\u0003:\t}RB\u0001B\u001e\u0015\u0011\u0011i$a\u0014\u0002\u0007I,G.\u0003\u0003\u0003B\tm\"a\u0002*fY:{G-\u001a\u0005\t\u0005\u000b\u0012\t\u00041\u0001\u0003&\u0005yQn\u001c3jMf|\u0005/\u001a:bi&|g\u000e\u000b\u0003\u00032\u0005\u0005\u0001\u0002CA<\u0001\u0011\u0005\u0001Ba\u0013\u0015\t\t5#q\f\t\u0007\u0005\u001f\u0012IFa\u000e\u000f\t\tE#Q\u000b\b\u0005\u0003s\u0013\u0019&C\u0001N\u0013\r\u00119\u0006T\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YF!\u0018\u0003\u0007M+\u0017OC\u0002\u0003X1C\u0001B!\u0019\u0003J\u0001\u0007!QJ\u0001\te\u0016dgj\u001c3fg\"\"!\u0011JA\u0001\u0011!\t9\b\u0001C\u0001\u0011\t\u001dD\u0003\u0002B\u001c\u0005SB\u0001Ba\u001b\u0003f\u0001\u0007!qG\u0001\be\u0016dgj\u001c3fQ\u0011\u0011)'!\u0001\t\u0011\tE\u0004\u0001\"\u0001\t\u0005g\n\u0001\u0004\u001e:b]Nd\u0017\r^3U_\u0016CXm\u0019(pI\u0016<%/\u00199i)\u0011\u0011)H!\"\u0011\t\t]$\u0011Q\u0007\u0003\u0005sRAAa\u001f\u0003~\u0005!Q\r_3d\u0015\u0011\u0011y(!\u001f\u0002\u000b9|G-Z:\n\t\t\r%\u0011\u0010\u0002\u000e\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5\t\u0011\t\u001d%q\u000ea\u0001\u0005\u001b\n\u0011c\u001c9uS6L'0\u001a3SK2tu\u000eZ3tQ\u0011\u0011y'!\u0001\t\u000f\t5\u0005A\"\u0005\u0003\u0010\u0006Qr-\u001a;Fq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b)s_\u000e,7o]8sgV\u0011!\u0011\u0013\t\u0007\u0005\u001f\u0012IFa%\u0011\t\tU%1T\u0007\u0003\u0005/SAA!'\u0003z\u0005I\u0001O]8dKN\u001cxN]\u0005\u0005\u0005;\u00139J\u0001\fFq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b)s_\u000e,7o]8s\u0011\u001d\u0011\t\u000b\u0001D\t\u0005G\u000bq\u0002\u001e:b]Nd\u0017\r^3U_Bc\u0017M\u001c\u000b\u0005\u0005K\u0013\t\f\u0005\u0004\u0002x\u0006u(q\u0015\u0019\u0005\u0005S\u0013i\u000b\u0005\u0004\u0003\u0006\t5!1\u0016\t\u0005\u0003/\u0012i\u000b\u0002\u0007\u00030\n}\u0015\u0011!A\u0001\u0006\u0003\u00119BA\u0002`IQB\u0001Ba-\u0003 \u0002\u0007!QO\u0001\nKb,7m\u0012:ba\"DqAa.\u0001\t\u0013\u0011I,\u0001\u0007hKR$\u0016M\u00197f'&t7\u000e\u0006\u0004\u0003<\n5'q\u001b\t\u0006\u0017\nu&\u0011Y\u0005\u0004\u0005\u007fc%AB(qi&|g\u000eE\u0004L\u0005\u0007\u00149M!\u0007\n\u0007\t\u0015GJ\u0001\u0004UkBdWM\r\t\u0004s\t%\u0017b\u0001Bfu\t!\"+Z:pYZ,GmQ1uC2|w\rV1cY\u0016D\u0001Ba4\u00036\u0002\u0007!\u0011[\u0001\u0015G>tG/\u001a=u%\u0016\u001cx\u000e\u001c<fIR\u000b'\r\\3\u0011\u0007e\u0012\u0019.C\u0002\u0003Vj\u0012AcQ8oi\u0016DHOU3t_24X\r\u001a+bE2,\u0007\u0002\u0003Bm\u0005k\u0003\rAa7\u0002\u001d\u0011Lh.Y7jG>\u0003H/[8ogBA!Q\u001cB{\u0003g\u000b\u0019L\u0004\u0003\u0003`\nMh\u0002\u0002Bq\u0005ctAAa9\u0003p:!!Q\u001dBw\u001d\u0011\u00119Oa;\u000f\t\u0005e&\u0011^\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011b\u0001B,\t%!!q\u001fB}\u0005\u0011QU*\u00199\u000b\u0007\t]C\u0001C\u0004\u0003~\u0002!\tBa@\u0002%\r\u0014X-\u0019;f'\u0016\u0014H-Z\"p]R,\u0007\u0010^\u000b\u0003\u0007\u0003\u0001Baa\u0001\u0004\n5\u00111Q\u0001\u0006\u0005\u0007\u000f\u0011I(A\u0003tKJ$W-\u0003\u0003\u0004\f\r\u0015!\u0001D*fe\u0012,7i\u001c8uKb$\bbBB\b\u0001\u0011E1\u0011C\u0001\u0012E\u00164wN]3Ue\u0006t7\u000f\\1uS>tG#\u00013\t\u000f\rU\u0001\u0001\"\u0005\u0004\u0012\u0005\u0001\u0012M\u001a;feR\u0013\u0018M\\:mCRLwN\u001c\u0005\t\u00073\u0001A\u0011\u0001\u0005\u0004\u001c\u0005\u0001r-\u001a;FqBd\u0017-\u001b8He\u0006\u0004\bn\u001d\u000b\u0005\u0007;\u0019y\u0004E\u0006L\u0007?\u0019\u0019C!\u0014\u0003v\rM\u0012bAB\u0011\u0019\n1A+\u001e9mKR\u0002ba!\n\u00040\t]RBAB\u0014\u0015\u0011\u0019Ica\u000b\u0002\u000f5,H/\u00192mK*\u00191Q\u0006'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00042\r\u001d\"A\u0002\"vM\u001a,'\u000f\u0005\u0003\u00046\rmRBAB\u001c\u0015\u0011\u0019I$a(\u0002\u000b\u001d\u0014\u0018\r\u001d5\n\t\ru2q\u0007\u0002\f'R\u0014X-Y7He\u0006\u0004\b\u000e\u0003\u0005\u0003,\r]\u0001\u0019AB!!\u0019\t90!@\u0004DA!!qEB#\u0013\u0011\u00199E!\u000b\u0003\u0013=\u0003XM]1uS>t\u0007")
public abstract class PlannerBase
implements Planner {
    private final Executor executor;
    private final TableConfig tableConfig;
    private final ModuleManager moduleManager;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;
    private Parser parser;
    private SqlDialect currentDialect;
    @VisibleForTesting
    private final PlannerContext plannerContext;

    public ModuleManager moduleManager() {
        return this.moduleManager;
    }

    public FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    private Parser parser() {
        return this.parser;
    }

    private void parser_$eq(Parser x$1) {
        this.parser = x$1;
    }

    private SqlDialect currentDialect() {
        return this.currentDialect;
    }

    private void currentDialect_$eq(SqlDialect x$1) {
        this.currentDialect = x$1;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createRelBuilder(currentCatalogName, currentDatabase);
    }

    @VisibleForTesting
    public FlinkPlannerImpl createFlinkPlanner() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.plannerContext().getTypeFactory();
    }

    public abstract RelTraitDef<? extends RelTrait>[] getTraitDefs();

    public abstract Optimizer getOptimizer();

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public FlinkContext getFlinkContext() {
        return this.plannerContext().getFlinkContext();
    }

    public StreamExecutionEnvironment getExecEnv() {
        return ((DefaultExecutor)this.executor).getExecutionEnvironment();
    }

    public Parser createNewParser() {
        String factoryIdentifier = this.getTableConfig().getSqlDialect().name().toLowerCase();
        ParserFactory parserFactory = (ParserFactory)FactoryUtil.discoverFactory((ClassLoader)this.getClass().getClassLoader(), ParserFactory.class, (String)factoryIdentifier);
        ParserFactory.DefaultParserContext context = new ParserFactory.DefaultParserContext(this.catalogManager(), this.plannerContext());
        return parserFactory.create(context);
    }

    public Parser getParser() {
        block1: {
            block0: {
                if (this.parser() == null) break block0;
                SqlDialect sqlDialect = this.getTableConfig().getSqlDialect();
                SqlDialect sqlDialect2 = this.currentDialect();
                if (!(sqlDialect == null ? sqlDialect2 != null : !sqlDialect.equals(sqlDialect2))) break block1;
            }
            this.parser_$eq(this.createNewParser());
            this.currentDialect_$eq(this.getTableConfig().getSqlDialect());
        }
        return this.parser();
    }

    public List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        this.beforeTranslation();
        if (modifyOperations.isEmpty()) {
            return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.empty());
        }
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.afterTranslation();
        return transformations;
    }

    @VisibleForTesting
    public RelNode translateToRel(ModifyOperation modifyOperation) {
        RelNode relNode;
        DataTypeFactory dataTypeFactory = this.catalogManager().getDataTypeFactory();
        ModifyOperation modifyOperation2 = modifyOperation;
        if (modifyOperation2 instanceof UnregisteredSinkModifyOperation) {
            UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(unregisteredSinkModifyOperation.getChild()).build();
            TableSchema sinkSchema = unregisteredSinkModifyOperation.getSink().getTableSchema();
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, this.catalogManager().getSchemaResolver().resolve(sinkSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
            relNode = LogicalLegacySink$.MODULE$.create(query, unregisteredSinkModifyOperation.getSink(), "UnregisteredSink", (CatalogTable)ConnectorCatalogTable.sink((TableSink)unregisteredSinkModifyOperation.getSink(), (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
        } else if (modifyOperation2 instanceof CollectModifyOperation) {
            CollectModifyOperation collectModifyOperation = (CollectModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertCollectToRel(this.getRelBuilder(), input, collectModifyOperation, (ReadableConfig)this.getTableConfig(), this.getFlinkContext().getClassLoader());
        } else if (modifyOperation2 instanceof SinkModifyOperation) {
            RelNode sinkRel;
            SinkModifyOperation sinkModifyOperation = (SinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            Map dynamicOptions = sinkModifyOperation.getDynamicOptions();
            Option option = this.getTableSink(sinkModifyOperation.getContextResolvedTable(), dynamicOptions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                    Object sink = tuple2._2();
                    if (sink instanceof TableSink) {
                        TableSink tableSink = (TableSink)sink;
                        ObjectIdentifier identifier = sinkModifyOperation.getContextResolvedTable().getIdentifier();
                        RowType queryLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
                        TableSinkUtils$.MODULE$.validateLogicalPhysicalTypesCompatible((CatalogTable)table, tableSink, queryLogicalType);
                        TableSinkUtils$.MODULE$.validateTableSink(sinkModifyOperation, identifier, tableSink, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getPartitionKeys()));
                        RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, table.getResolvedSchema(), identifier.asSummaryString(), dataTypeFactory, this.getTypeFactory());
                        ArrayList<RelHint> hints = new ArrayList<RelHint>();
                        Object object = !dynamicOptions.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)hints.add(RelHint.builder("OPTIONS").hintOptions(dynamicOptions).build())) : BoxedUnit.UNIT;
                        return LogicalLegacySink$.MODULE$.create(query, hints, tableSink, identifier.toString(), (CatalogTable)table, (scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(sinkModifyOperation.getStaticPartitions()).toMap(Predef$.MODULE$.$conforms()));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Object sink = tuple2._2();
                if (!(sink instanceof DynamicTableSink)) throw new MatchError((Object)tuple2);
                DynamicTableSink dynamicTableSink = (DynamicTableSink)sink;
                return DynamicSinkUtils.convertSinkToRel(this.getRelBuilder(), input, sinkModifyOperation, dynamicTableSink);
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TableException(new StringBuilder(23).append("Sink '").append(sinkModifyOperation.getContextResolvedTable()).append("' does not exists").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            RelNode relNode2 = sinkRel = (RelNode)some.value();
            relNode = relNode2;
        } else if (modifyOperation2 instanceof ExternalModifyOperation) {
            ExternalModifyOperation externalModifyOperation = (ExternalModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertExternalToRel(this.getRelBuilder(), input, externalModifyOperation);
        } else if (modifyOperation2 instanceof OutputConversionModifyOperation) {
            Tuple2.mcZZ.sp sp2;
            OutputConversionModifyOperation outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(outputConversionModifyOperation.getChild()).build();
            OutputConversionModifyOperation.UpdateMode updateMode = outputConversionModifyOperation.getUpdateMode();
            if (OutputConversionModifyOperation.UpdateMode.RETRACT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (OutputConversionModifyOperation.UpdateMode.APPEND.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, false);
            } else if (OutputConversionModifyOperation.UpdateMode.UPSERT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, true);
            } else {
                throw new MatchError((Object)updateMode);
            }
            Tuple2.mcZZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            boolean needUpdateBefore = sp3._1$mcZ$sp();
            boolean withChangeFlag = sp3._2$mcZ$sp();
            Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(needUpdateBefore, withChangeFlag);
            Tuple2.mcZZ.sp sp5 = sp4;
            boolean needUpdateBefore2 = sp5._1$mcZ$sp();
            boolean withChangeFlag2 = sp5._2$mcZ$sp();
            TypeInformation typeInfo = LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo((DataType)outputConversionModifyOperation.getType());
            RowType inputLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
            TableSchema sinkPhysicalSchema = TableSinkUtils$.MODULE$.inferSinkPhysicalSchema(outputConversionModifyOperation.getType(), inputLogicalType, withChangeFlag2);
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, this.catalogManager().getSchemaResolver().resolve(sinkPhysicalSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
            DataStreamTableSink tableSink = new DataStreamTableSink(FlinkTypeFactory$.MODULE$.toTableSchema(query.getRowType()), typeInfo, needUpdateBefore2, withChangeFlag2);
            relNode = LogicalLegacySink$.MODULE$.create(query, tableSink, "DataStreamTableSink", (CatalogTable)ConnectorCatalogTable.sink(tableSink, (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
        } else {
            throw new TableException(new StringBuilder(29).append("Unsupported ModifyOperation: ").append(modifyOperation).toString());
        }
        return relNode;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public Seq<RelNode> optimize(Seq<RelNode> relNodes) {
        void var2_2;
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize(relNodes);
        Predef$.MODULE$.require(optimizedRelNodes.size() == relNodes.size());
        return var2_2;
    }

    @VisibleForTesting
    public RelNode optimize(RelNode relNode) {
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize((Seq<RelNode>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{relNode}))));
        Predef$.MODULE$.require(optimizedRelNodes.size() == 1);
        return (RelNode)optimizedRelNodes.head();
    }

    @VisibleForTesting
    public ExecNodeGraph translateToExecNodeGraph(Seq<RelNode> optimizedRelNodes) {
        Seq nonPhysicalRel = (Seq)optimizedRelNodes.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$1(x$2)));
        if (nonPhysicalRel.nonEmpty()) {
            throw new TableException(new StringBuilder(54).append("The expected optimized plan is FlinkPhysicalRel plan, ").append(new StringBuilder(21).append("actual plan is ").append(nonPhysicalRel.head().getClass().getSimpleName()).append(" plan.").toString()).toString());
        }
        Predef$.MODULE$.require(optimizedRelNodes.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$2(x$3))));
        SameRelObjectShuttle shuttle = new SameRelObjectShuttle();
        Seq relsWithoutSameObj = (Seq)optimizedRelNodes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.accept(shuttle), Seq$.MODULE$.canBuildFrom());
        Seq<RelNode> reusedPlan = SubplanReuser$.MODULE$.reuseDuplicatedSubplan((Seq<RelNode>)relsWithoutSameObj, this.tableConfig);
        ExecNodeGraphGenerator generator = new ExecNodeGraphGenerator();
        ExecNodeGraph execGraph = generator.generate(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)reusedPlan.map((Function1 & Serializable & scala.Serializable)x$5 -> (FlinkPhysicalRel)x$5, Seq$.MODULE$.canBuildFrom())));
        ProcessorContext context = new ProcessorContext(this);
        Seq<ExecNodeGraphProcessor> processors = this.getExecNodeGraphProcessors();
        return (ExecNodeGraph)processors.foldLeft((Object)execGraph, (Function2 & Serializable & scala.Serializable)(graph, processor) -> processor.process((ExecNodeGraph)graph, context));
    }

    public abstract Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors();

    public abstract List<Transformation<?>> translateToPlan(ExecNodeGraph var1);

    private Option<Tuple2<ResolvedCatalogTable, Object>> getTableSink(ContextResolvedTable contextResolvedTable, Map<String, String> dynamicOptions) {
        None$ none$;
        CatalogBaseTable catalogBaseTable = contextResolvedTable.getTable();
        if (catalogBaseTable instanceof ConnectorCatalogTable) {
            None$ none$2;
            ConnectorCatalogTable connectorCatalogTable = (ConnectorCatalogTable)catalogBaseTable;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)contextResolvedTable.getResolvedTable();
            Option option = JavaScalaConversionUtil$.MODULE$.toScala(connectorCatalogTable.getTableSink());
            if (option instanceof Some) {
                Some some = (Some)option;
                TableSink sink = (TableSink)some.value();
                none$2 = new Some((Object)new Tuple2((Object)resolvedTable, (Object)sink));
            } else if (None$.MODULE$.equals(option)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            none$ = none$2;
        } else if (catalogBaseTable instanceof CatalogTable) {
            Option option;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)contextResolvedTable.getResolvedTable();
            ResolvedCatalogTable tableToFind = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(dynamicOptions).nonEmpty() ? resolvedTable.copy(FlinkHints.mergeTableOptions(dynamicOptions, resolvedTable.getOptions())) : resolvedTable;
            Option catalog = JavaScalaConversionUtil$.MODULE$.toScala(contextResolvedTable.getCatalog());
            ObjectIdentifier objectIdentifier = contextResolvedTable.getIdentifier();
            boolean isTemporary = contextResolvedTable.isTemporary();
            if (this.isStreamingMode && ManagedTableListener.isManagedTable((Catalog)((Catalog)catalog.orNull(Predef$.MODULE$.$conforms())), (CatalogBaseTable)resolvedTable) && !this.executor.isCheckpointingEnabled()) {
                throw new TableException(new StringBuilder(103).append("You should enable the checkpointing for sinking to managed table ").append(new StringBuilder(53).append("'").append(contextResolvedTable).append("', managed table relies on checkpoint to commit and ").toString()).append("the data is visible only after commit.").toString());
            }
            if (!contextResolvedTable.isAnonymous() && TableFactoryUtil.isLegacyConnectorOptions((Catalog)this.catalogManager().getCatalog(objectIdentifier.getCatalogName()).orElse(null), (ReadableConfig)this.tableConfig, (boolean)this.isStreamingMode, (ObjectIdentifier)objectIdentifier, (CatalogTable)resolvedTable.getOrigin(), (boolean)isTemporary)) {
                TableSink tableSink = TableFactoryUtil.findAndCreateTableSink((Catalog)((Catalog)catalog.orNull(Predef$.MODULE$.$conforms())), (ObjectIdentifier)objectIdentifier, (CatalogTable)tableToFind.getOrigin(), (ReadableConfig)this.getTableConfig(), (boolean)this.isStreamingMode, (boolean)isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            } else {
                None$ none$3;
                Some some;
                Factory f2;
                Option option2 = catalog.flatMap((Function1 & Serializable & scala.Serializable)f -> JavaScalaConversionUtil$.MODULE$.toScala(f.getFactory()));
                if (option2 instanceof Some && (f2 = (Factory)(some = (Some)option2).value()) instanceof DynamicTableSinkFactory) {
                    DynamicTableSinkFactory dynamicTableSinkFactory = (DynamicTableSinkFactory)f2;
                    none$3 = new Some((Object)dynamicTableSinkFactory);
                } else {
                    none$3 = None$.MODULE$;
                }
                None$ factoryFromCatalog = none$3;
                Option factoryFromModule = JavaScalaConversionUtil$.MODULE$.toScala(this.plannerContext().getFlinkContext().getModuleManager().getFactory(JavaScalaConversionUtil$.MODULE$.toJava((Function1 & Serializable & scala.Serializable)m -> m.getTableSinkFactory())));
                DynamicTableSinkFactory factory = (DynamicTableSinkFactory)factoryFromCatalog.orElse((Function0 & Serializable & scala.Serializable)() -> factoryFromModule).orNull(Predef$.MODULE$.$conforms());
                DynamicTableSink tableSink = FactoryUtil.createDynamicTableSink((DynamicTableSinkFactory)factory, (ObjectIdentifier)objectIdentifier, (ResolvedCatalogTable)tableToFind, Collections.emptyMap(), (ReadableConfig)this.getTableConfig(), (ClassLoader)this.getFlinkContext().getClassLoader(), (boolean)isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            }
            none$ = option;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public SerdeContext createSerdeContext() {
        FlinkPlannerImpl planner = this.createFlinkPlanner();
        return new SerdeContext(this.getParser(), (FlinkContext)planner.config().getContext(), this.getFlinkContext().getClassLoader(), this.plannerContext().getTypeFactory(), planner.operatorTable());
    }

    public void beforeTranslation() {
        block0: {
            Long epochTime = Predef$.MODULE$.long2Long(System.currentTimeMillis());
            this.tableConfig.set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)epochTime);
            Long localTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(epochTime) + (long)TimeZone.getTimeZone(this.tableConfig.getLocalTimeZone()).getOffset(Predef$.MODULE$.Long2long(epochTime)));
            this.tableConfig.set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)localTime);
            this.getExecEnv().configure((ReadableConfig)this.tableConfig.getConfiguration(), Thread.currentThread().getContextClassLoader());
            Integer defaultParallelism = (Integer)this.getTableConfig().get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
            if (Predef$.MODULE$.Integer2int(defaultParallelism) <= 0) break block0;
            this.getExecEnv().getConfig().setParallelism(Predef$.MODULE$.Integer2int(defaultParallelism));
        }
    }

    public void afterTranslation() {
        Configuration configuration = this.tableConfig.getConfiguration();
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME);
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME);
        CompileUtils.cleanUp();
    }

    public Tuple4<Buffer<RelNode>, Seq<RelNode>, ExecNodeGraph, StreamGraph> getExplainGraphs(List<Operation> operations) {
        Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "operations should not be empty");
        this.beforeTranslation();
        Buffer sinkRelNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RelNode relNode;
            Operation operation = x0$2;
            if (operation instanceof QueryOperation) {
                RelNode relNode2;
                QueryOperation queryOperation = (QueryOperation)operation;
                RelNode relNode3 = this.getRelBuilder().queryOperation(queryOperation).build();
                RelNode relNode4 = relNode3;
                if (relNode4 instanceof LogicalTableModify) {
                    LogicalTableModify logicalTableModify = (LogicalTableModify)relNode4;
                    List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                    Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0 & Serializable & scala.Serializable)() -> "the length of qualified name should be 3.");
                    ObjectIdentifier objectIdentifier = ObjectIdentifier.of((String)qualifiedName.get(0), (String)qualifiedName.get(1), (String)qualifiedName.get(2));
                    ContextResolvedTable contextResolvedTable = this.catalogManager().getTableOrError(objectIdentifier);
                    SinkModifyOperation modifyOperation = new SinkModifyOperation(contextResolvedTable, (QueryOperation)new PlannerQueryOperation(logicalTableModify.getInput()));
                    relNode2 = this.translateToRel((ModifyOperation)modifyOperation);
                } else {
                    relNode2 = relNode3;
                }
                relNode = relNode2;
            } else if (operation instanceof ModifyOperation) {
                ModifyOperation modifyOperation = (ModifyOperation)operation;
                relNode = this.translateToRel(modifyOperation);
            } else {
                throw new TableException(new StringBuilder(23).append("Unsupported operation: ").append(operation.getClass().getCanonicalName()).toString());
            }
            return relNode;
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)sinkRelNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.afterTranslation();
        StreamGraph streamGraph = (StreamGraph)this.executor.createPipeline(transformations, (ReadableConfig)this.tableConfig.getConfiguration(), null);
        return new Tuple4((Object)sinkRelNodes, optimizedRelNodes, (Object)execGraph, (Object)streamGraph);
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$1(RelNode x$2) {
        return x$2 instanceof FlinkPhysicalRel;
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$2(RelNode x$3) {
        return x$3 instanceof FlinkPhysicalRel;
    }

    public PlannerBase(Executor executor, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager, boolean isStreamingMode) {
        this.executor = executor;
        this.tableConfig = tableConfig;
        this.moduleManager = moduleManager;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        this.isStreamingMode = isStreamingMode;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.currentDialect = this.getTableConfig().getSqlDialect();
        this.plannerContext = new PlannerContext(!isStreamingMode, tableConfig, moduleManager, functionCatalog, catalogManager, CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, isStreamingMode)), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTraitDefs())).toList()));
    }
}

