/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ValuesQueryOperation;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeGeneralization;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class ValuesOperationFactory {
    ValuesOperationFactory() {
    }

    QueryOperation create(@Nullable TableSchema expectedSchema, List<ResolvedExpression> resolvedExpressions, ExpressionResolver.PostResolverFactory postResolverFactory) {
        List<List<ResolvedExpression>> resolvedRows = this.unwrapFromRowConstructor(resolvedExpressions);
        if (expectedSchema != null) {
            this.verifyAllSameSize(resolvedRows, expectedSchema.getFieldCount());
        }
        TableSchema schema = Optional.ofNullable(expectedSchema).orElseGet(() -> this.extractSchema(resolvedRows));
        List<List<ResolvedExpression>> castedExpressions = resolvedRows.stream().map(row -> this.convertTopLevelExpressionToExpectedRowType(postResolverFactory, schema.getFieldDataTypes(), (List<ResolvedExpression>)row)).collect(Collectors.toList());
        return new ValuesQueryOperation(castedExpressions, schema);
    }

    private TableSchema extractSchema(List<List<ResolvedExpression>> resolvedRows) {
        DataType[] dataTypes = this.findRowType(resolvedRows);
        String[] fieldNames = (String[])IntStream.range(0, dataTypes.length).mapToObj(i -> "f" + i).toArray(String[]::new);
        return TableSchema.builder().fields(fieldNames, dataTypes).build();
    }

    private List<ResolvedExpression> convertTopLevelExpressionToExpectedRowType(ExpressionResolver.PostResolverFactory postResolverFactory, DataType[] dataTypes, List<ResolvedExpression> row) {
        return IntStream.range(0, row.size()).mapToObj(i -> {
            boolean typesMatch = ((ResolvedExpression)row.get(i)).getOutputDataType().getLogicalType().equals((Object)dataTypes[i].getLogicalType());
            if (typesMatch) {
                return (ResolvedExpression)row.get(i);
            }
            ResolvedExpression castedExpr = (ResolvedExpression)row.get(i);
            DataType targetDataType = dataTypes[i];
            return this.convertToExpectedType(castedExpr, targetDataType, postResolverFactory).orElseThrow(() -> new ValidationException(String.format("Could not cast the value of the %d column: [ %s ] of a row: %s to the requested type: %s", i, castedExpr.asSummaryString(), row.stream().map(Expression::asSummaryString).collect(Collectors.joining(", ", "[ ", " ]")), targetDataType.getLogicalType().asSummaryString())));
        }).collect(Collectors.toList());
    }

    private Optional<ResolvedExpression> convertToExpectedType(ResolvedExpression sourceExpression, DataType targetDataType, ExpressionResolver.PostResolverFactory postResolverFactory) {
        LogicalType sourceLogicalType = sourceExpression.getOutputDataType().getLogicalType();
        LogicalType targetLogicalType = targetDataType.getLogicalType();
        if (sourceExpression instanceof ValueLiteralExpression) {
            if (LogicalTypeChecks.hasRoot((LogicalType)sourceLogicalType, (LogicalTypeRoot)LogicalTypeRoot.NULL)) {
                return Optional.of(ApiExpressionUtils.valueLiteral(null, targetDataType));
            }
            Optional value = ((ValueLiteralExpression)sourceExpression).getValueAs(Object.class);
            if (value.isPresent() && targetLogicalType.supportsInputConversion(value.get().getClass())) {
                ValueLiteralExpression convertedLiteral = ApiExpressionUtils.valueLiteral(value.get(), (DataType)((DataType)targetDataType.notNull()).bridgedTo(value.get().getClass()));
                if (targetLogicalType.isNullable()) {
                    return Optional.of(postResolverFactory.cast((ResolvedExpression)convertedLiteral, targetDataType));
                }
                return Optional.of(convertedLiteral);
            }
        }
        if (sourceExpression instanceof CallExpression) {
            FunctionDefinition functionDefinition = ((CallExpression)sourceExpression).getFunctionDefinition();
            if (functionDefinition == BuiltInFunctionDefinitions.ROW && LogicalTypeChecks.hasRoot((LogicalType)targetLogicalType, (LogicalTypeRoot)LogicalTypeRoot.ROW)) {
                return this.convertRowToExpectedType(sourceExpression, (FieldsDataType)targetDataType, postResolverFactory);
            }
            if (functionDefinition == BuiltInFunctionDefinitions.ARRAY && LogicalTypeChecks.hasRoot((LogicalType)targetLogicalType, (LogicalTypeRoot)LogicalTypeRoot.ARRAY)) {
                return this.convertArrayToExpectedType(sourceExpression, (CollectionDataType)targetDataType, postResolverFactory);
            }
            if (functionDefinition == BuiltInFunctionDefinitions.MAP && LogicalTypeChecks.hasRoot((LogicalType)targetLogicalType, (LogicalTypeRoot)LogicalTypeRoot.MAP)) {
                return this.convertMapToExpectedType(sourceExpression, (KeyValueDataType)targetDataType, postResolverFactory);
            }
        }
        if (LogicalTypeCasts.supportsExplicitCast((LogicalType)sourceLogicalType.copy(true), (LogicalType)targetLogicalType.copy(true))) {
            return Optional.of(postResolverFactory.cast(sourceExpression, targetDataType));
        }
        return Optional.empty();
    }

    private Optional<ResolvedExpression> convertRowToExpectedType(ResolvedExpression sourceExpression, FieldsDataType targetDataType, ExpressionResolver.PostResolverFactory postResolverFactory) {
        List targetDataTypes = targetDataType.getChildren();
        List resolvedChildren = sourceExpression.getResolvedChildren();
        if (resolvedChildren.size() != targetDataTypes.size()) {
            return Optional.empty();
        }
        ResolvedExpression[] castedChildren = new ResolvedExpression[resolvedChildren.size()];
        for (int i = 0; i < resolvedChildren.size(); ++i) {
            DataType targetChildDataType;
            ResolvedExpression child;
            Optional<ResolvedExpression> castedChild;
            boolean typesMatch = ((ResolvedExpression)resolvedChildren.get(i)).getOutputDataType().getLogicalType().equals((Object)((DataType)targetDataTypes.get(i)).getLogicalType());
            if (typesMatch) {
                castedChildren[i] = (ResolvedExpression)resolvedChildren.get(i);
            }
            if (!(castedChild = this.convertToExpectedType(child = (ResolvedExpression)resolvedChildren.get(i), targetChildDataType = (DataType)targetDataTypes.get(i), postResolverFactory)).isPresent()) {
                return Optional.empty();
            }
            castedChildren[i] = castedChild.get();
        }
        return Optional.of(postResolverFactory.row((DataType)targetDataType, castedChildren));
    }

    private Optional<ResolvedExpression> convertArrayToExpectedType(ResolvedExpression sourceExpression, CollectionDataType targetDataType, ExpressionResolver.PostResolverFactory postResolverFactory) {
        DataType elementTargetDataType = targetDataType.getElementDataType();
        List resolvedChildren = sourceExpression.getResolvedChildren();
        ResolvedExpression[] castedChildren = new ResolvedExpression[resolvedChildren.size()];
        for (int i = 0; i < resolvedChildren.size(); ++i) {
            Optional<ResolvedExpression> castedChild = this.convertToExpectedType((ResolvedExpression)resolvedChildren.get(i), elementTargetDataType, postResolverFactory);
            if (!castedChild.isPresent()) {
                return Optional.empty();
            }
            castedChildren[i] = castedChild.get();
        }
        return Optional.of(postResolverFactory.array((DataType)targetDataType, castedChildren));
    }

    private Optional<ResolvedExpression> convertMapToExpectedType(ResolvedExpression sourceExpression, KeyValueDataType targetDataType, ExpressionResolver.PostResolverFactory postResolverFactory) {
        DataType keyTargetDataType = targetDataType.getKeyDataType();
        DataType valueTargetDataType = targetDataType.getValueDataType();
        List resolvedChildren = sourceExpression.getResolvedChildren();
        ResolvedExpression[] castedChildren = new ResolvedExpression[resolvedChildren.size()];
        for (int i = 0; i < resolvedChildren.size(); ++i) {
            Optional<ResolvedExpression> castedChild = this.convertToExpectedType((ResolvedExpression)resolvedChildren.get(i), i % 2 == 0 ? keyTargetDataType : valueTargetDataType, postResolverFactory);
            if (!castedChild.isPresent()) {
                return Optional.empty();
            }
            castedChildren[i] = castedChild.get();
        }
        return Optional.of(postResolverFactory.map((DataType)targetDataType, castedChildren));
    }

    private List<List<ResolvedExpression>> unwrapFromRowConstructor(List<ResolvedExpression> resolvedExpressions) {
        return resolvedExpressions.stream().map(expr -> (List)expr.accept((ExpressionVisitor)new ExpressionDefaultVisitor<List<ResolvedExpression>>(){

            public List<ResolvedExpression> visit(CallExpression call) {
                if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.ROW) {
                    return call.getResolvedChildren();
                }
                return this.defaultMethod((Expression)call);
            }

            protected List<ResolvedExpression> defaultMethod(Expression expression) {
                if (!(expression instanceof ResolvedExpression)) {
                    throw new TableException("This visitor is applied to ResolvedExpressions. We should never end up here.");
                }
                return Collections.singletonList((ResolvedExpression)expression);
            }
        })).collect(Collectors.toList());
    }

    private DataType[] findRowType(List<List<ResolvedExpression>> resolvedRows) {
        int rowSize = this.findRowSize(resolvedRows);
        DataType[] dataTypes = new DataType[rowSize];
        IntStream.range(0, rowSize).forEach(i -> {
            dataTypes[i] = this.findCommonTypeAtPosition(resolvedRows, i);
        });
        return dataTypes;
    }

    private DataType findCommonTypeAtPosition(List<List<ResolvedExpression>> resolvedRows, int i) {
        List<LogicalType> typesAtIPosition = this.extractLogicalTypesAtPosition(resolvedRows, i);
        LogicalType logicalType = (LogicalType)LogicalTypeGeneralization.findCommonType(typesAtIPosition).orElseThrow(() -> {
            Set columnTypes = resolvedRows.stream().map(row -> ((ResolvedExpression)row.get(i)).getOutputDataType()).collect(Collectors.toCollection(LinkedHashSet::new));
            return new ValidationException(String.format("Types in fromValues(...) must have a common super type. Could not find a common type for all rows at column %d.\nCould not find a common super type for types: %s", i, columnTypes));
        });
        return TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
    }

    private List<LogicalType> extractLogicalTypesAtPosition(List<List<ResolvedExpression>> resolvedRows, int rowPosition) {
        ArrayList<LogicalType> typesAtIPosition = new ArrayList<LogicalType>();
        for (List<ResolvedExpression> resolvedExpression : resolvedRows) {
            LogicalType outputLogicalType = resolvedExpression.get(rowPosition).getOutputDataType().getLogicalType();
            typesAtIPosition.add(outputLogicalType);
        }
        return typesAtIPosition;
    }

    private int findRowSize(List<List<ResolvedExpression>> resolvedRows) {
        List<ResolvedExpression> firstRow = resolvedRows.get(0);
        int potentialRowSize = firstRow.size();
        this.verifyAllSameSize(resolvedRows, potentialRowSize);
        return potentialRowSize;
    }

    private void verifyAllSameSize(List<List<ResolvedExpression>> resolvedRows, int potentialRowSize) {
        Optional<List> differentSizeRow = resolvedRows.stream().filter(row -> row.size() != potentialRowSize).findAny();
        if (differentSizeRow.isPresent()) {
            throw new ValidationException(String.format("All rows in a fromValues(...) clause must have the same fields number. Row %s has a different length than the expected size: %d.", differentSizeRow.get(), potentialRowSize));
        }
    }
}

