/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.graph.GlobalDataExchangeMode;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionInternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionStateBackend;
import org.apache.flink.streaming.api.transformations.BroadcastStateTransformation;
import org.apache.flink.streaming.api.transformations.CoFeedbackTransformation;
import org.apache.flink.streaming.api.transformations.FeedbackTransformation;
import org.apache.flink.streaming.api.transformations.KeyedBroadcastStateTransformation;
import org.apache.flink.streaming.api.transformations.KeyedMultipleInputTransformation;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.MultipleInputTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.streaming.api.transformations.ReduceTransformation;
import org.apache.flink.streaming.api.transformations.SideOutputTransformation;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformation;
import org.apache.flink.streaming.api.transformations.TimestampsAndWatermarksTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.streaming.api.transformations.WithBoundedness;
import org.apache.flink.streaming.runtime.translators.BroadcastStateTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.KeyedBroadcastStateTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.LegacySinkTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.LegacySourceTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.MultiInputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.OneInputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.PartitionTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.ReduceTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.SideOutputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.SinkTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.SourceTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.TimestampsAndWatermarksTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.TwoInputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.UnionTransformationTranslator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamGraphGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraphGenerator.class);
    public static final int DEFAULT_LOWER_BOUND_MAX_PARALLELISM = 128;
    public static final TimeCharacteristic DEFAULT_TIME_CHARACTERISTIC = TimeCharacteristic.ProcessingTime;
    public static final String DEFAULT_JOB_NAME = "Flink Streaming Job";
    public static final String DEFAULT_SLOT_SHARING_GROUP = "default";
    private final List<Transformation<?>> transformations;
    private final ExecutionConfig executionConfig;
    private final CheckpointConfig checkpointConfig;
    private final ReadableConfig configuration;
    private StateBackend stateBackend;
    private boolean chaining = true;
    private Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> userArtifacts;
    private TimeCharacteristic timeCharacteristic = DEFAULT_TIME_CHARACTERISTIC;
    private String jobName = "Flink Streaming Job";
    private SavepointRestoreSettings savepointRestoreSettings;
    private long defaultBufferTimeout = -1L;
    private RuntimeExecutionMode runtimeExecutionMode = RuntimeExecutionMode.STREAMING;
    private boolean shouldExecuteInBatchMode;
    private static final Map<Class<? extends Transformation>, TransformationTranslator<?, ? extends Transformation>> translatorMap;
    protected static Integer iterationIdCounter;
    private StreamGraph streamGraph;
    private Map<Transformation<?>, Collection<Integer>> alreadyTransformed;

    public static int getNewIterationNodeId() {
        Integer n = iterationIdCounter;
        Integer n2 = iterationIdCounter = Integer.valueOf(iterationIdCounter - 1);
        return iterationIdCounter;
    }

    public StreamGraphGenerator(List<Transformation<?>> transformations, ExecutionConfig executionConfig, CheckpointConfig checkpointConfig) {
        this(transformations, executionConfig, checkpointConfig, (ReadableConfig)new Configuration());
    }

    public StreamGraphGenerator(List<Transformation<?>> transformations, ExecutionConfig executionConfig, CheckpointConfig checkpointConfig, ReadableConfig configuration) {
        this.transformations = (List)Preconditions.checkNotNull(transformations);
        this.executionConfig = (ExecutionConfig)Preconditions.checkNotNull((Object)executionConfig);
        this.checkpointConfig = new CheckpointConfig(checkpointConfig);
        this.configuration = (ReadableConfig)Preconditions.checkNotNull((Object)configuration);
        this.savepointRestoreSettings = SavepointRestoreSettings.fromConfiguration((ReadableConfig)configuration);
    }

    public StreamGraphGenerator setRuntimeExecutionMode(RuntimeExecutionMode runtimeExecutionMode) {
        this.runtimeExecutionMode = (RuntimeExecutionMode)Preconditions.checkNotNull((Object)runtimeExecutionMode);
        return this;
    }

    public StreamGraphGenerator setStateBackend(StateBackend stateBackend) {
        this.stateBackend = stateBackend;
        return this;
    }

    public StreamGraphGenerator setChaining(boolean chaining) {
        this.chaining = chaining;
        return this;
    }

    public StreamGraphGenerator setUserArtifacts(Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> userArtifacts) {
        this.userArtifacts = userArtifacts;
        return this;
    }

    public StreamGraphGenerator setTimeCharacteristic(TimeCharacteristic timeCharacteristic) {
        this.timeCharacteristic = timeCharacteristic;
        return this;
    }

    public StreamGraphGenerator setDefaultBufferTimeout(long defaultBufferTimeout) {
        this.defaultBufferTimeout = defaultBufferTimeout;
        return this;
    }

    public StreamGraphGenerator setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public void setSavepointRestoreSettings(SavepointRestoreSettings savepointRestoreSettings) {
        this.savepointRestoreSettings = savepointRestoreSettings;
    }

    public StreamGraph generate() {
        this.streamGraph = new StreamGraph(this.executionConfig, this.checkpointConfig, this.savepointRestoreSettings);
        this.shouldExecuteInBatchMode = this.shouldExecuteInBatchMode(this.runtimeExecutionMode);
        this.configureStreamGraph(this.streamGraph);
        this.alreadyTransformed = new HashMap();
        for (Transformation<?> transformation : this.transformations) {
            this.transform(transformation);
        }
        for (StreamNode node : this.streamGraph.getStreamNodes()) {
            if (!node.getInEdges().stream().anyMatch(edge -> edge.getPartitioner().isBroadcast())) continue;
            for (StreamEdge edge2 : node.getInEdges()) {
                edge2.setSupportsUnalignedCheckpoints(false);
            }
        }
        StreamGraph builtStreamGraph = this.streamGraph;
        this.alreadyTransformed.clear();
        this.alreadyTransformed = null;
        this.streamGraph = null;
        return builtStreamGraph;
    }

    private void configureStreamGraph(StreamGraph graph) {
        Preconditions.checkNotNull((Object)graph);
        graph.setChaining(this.chaining);
        graph.setUserArtifacts(this.userArtifacts);
        graph.setTimeCharacteristic(this.timeCharacteristic);
        graph.setJobName(this.jobName);
        if (this.shouldExecuteInBatchMode) {
            if (this.checkpointConfig.isCheckpointingEnabled()) {
                LOG.info("Disabled Checkpointing. Checkpointing is not supported and not needed when executing jobs in BATCH mode.");
                this.checkpointConfig.disableCheckpointing();
            }
            graph.setGlobalDataExchangeMode(GlobalDataExchangeMode.FORWARD_EDGES_PIPELINED);
            graph.setScheduleMode(ScheduleMode.LAZY_FROM_SOURCES_WITH_BATCH_SLOT_REQUEST);
            this.setDefaultBufferTimeout(-1L);
            this.setBatchStateBackendAndTimerService(graph);
        } else {
            graph.setStateBackend(this.stateBackend);
            graph.setScheduleMode(ScheduleMode.EAGER);
            if (this.checkpointConfig.isApproximateLocalRecoveryEnabled()) {
                this.checkApproximateLocalRecoveryCompatibility();
                graph.setGlobalDataExchangeMode(GlobalDataExchangeMode.ALL_EDGES_PIPELINED_APPROXIMATE);
            } else {
                graph.setGlobalDataExchangeMode(GlobalDataExchangeMode.ALL_EDGES_PIPELINED);
            }
        }
    }

    private void checkApproximateLocalRecoveryCompatibility() {
        Preconditions.checkState((!this.checkpointConfig.isUnalignedCheckpointsEnabled() ? 1 : 0) != 0, (Object)"Approximate Local Recovery and Unaligned Checkpoint can not be used together yet");
    }

    private void setBatchStateBackendAndTimerService(StreamGraph graph) {
        boolean useStateBackend = (Boolean)this.configuration.get(ExecutionOptions.USE_BATCH_STATE_BACKEND);
        boolean sortInputs = (Boolean)this.configuration.get(ExecutionOptions.SORT_INPUTS);
        Preconditions.checkState((!useStateBackend || sortInputs ? 1 : 0) != 0, (Object)"Batch state backend requires the sorted inputs to be enabled!");
        if (useStateBackend) {
            LOG.debug("Using BATCH execution state backend and timer service.");
            graph.setStateBackend(new BatchExecutionStateBackend());
            graph.setTimerServiceProvider(BatchExecutionInternalTimeServiceManager::create);
        } else {
            graph.setStateBackend(this.stateBackend);
        }
    }

    private boolean shouldExecuteInBatchMode(RuntimeExecutionMode configuredMode) {
        boolean existsUnboundedSource = this.existsUnboundedSource();
        Preconditions.checkState((configuredMode != RuntimeExecutionMode.BATCH || !existsUnboundedSource ? 1 : 0) != 0, (Object)("Detected an UNBOUNDED source with the '" + ExecutionOptions.RUNTIME_MODE.key() + "' set to 'BATCH'. This combination is not allowed, please set the '" + ExecutionOptions.RUNTIME_MODE.key() + "' to STREAMING or AUTOMATIC"));
        if (Preconditions.checkNotNull((Object)configuredMode) != RuntimeExecutionMode.AUTOMATIC) {
            return configuredMode == RuntimeExecutionMode.BATCH;
        }
        return !existsUnboundedSource;
    }

    private boolean existsUnboundedSource() {
        return this.transformations.stream().anyMatch(transformation -> this.isUnboundedSource((Transformation<?>)transformation) || transformation.getTransitivePredecessors().stream().anyMatch(this::isUnboundedSource));
    }

    private boolean isUnboundedSource(Transformation<?> transformation) {
        Preconditions.checkNotNull(transformation);
        return transformation instanceof WithBoundedness && ((WithBoundedness)transformation).getBoundedness() != Boundedness.BOUNDED;
    }

    private Collection<Integer> transform(Transformation<?> transform) {
        int globalMaxParallelismFromConfig;
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        LOG.debug("Transforming " + transform);
        if (transform.getMaxParallelism() <= 0 && (globalMaxParallelismFromConfig = this.executionConfig.getMaxParallelism()) > 0) {
            transform.setMaxParallelism(globalMaxParallelismFromConfig);
        }
        transform.getOutputType();
        TransformationTranslator<?, ? extends Transformation> translator = translatorMap.get(transform.getClass());
        Collection<Integer> transformedIds = translator != null ? this.translate(translator, transform) : this.legacyTransform(transform);
        if (!this.alreadyTransformed.containsKey(transform)) {
            this.alreadyTransformed.put(transform, transformedIds);
        }
        return transformedIds;
    }

    private Collection<Integer> legacyTransform(Transformation<?> transform) {
        Collection<Integer> transformedIds;
        if (transform instanceof FeedbackTransformation) {
            transformedIds = this.transformFeedback((FeedbackTransformation)transform);
        } else if (transform instanceof CoFeedbackTransformation) {
            transformedIds = this.transformCoFeedback((CoFeedbackTransformation)transform);
        } else {
            throw new IllegalStateException("Unknown transformation: " + transform);
        }
        if (transform.getBufferTimeout() >= 0L) {
            this.streamGraph.setBufferTimeout(transform.getId(), transform.getBufferTimeout());
        } else {
            this.streamGraph.setBufferTimeout(transform.getId(), this.defaultBufferTimeout);
        }
        if (transform.getUid() != null) {
            this.streamGraph.setTransformationUID(transform.getId(), transform.getUid());
        }
        if (transform.getUserProvidedNodeHash() != null) {
            this.streamGraph.setTransformationUserHash(transform.getId(), transform.getUserProvidedNodeHash());
        }
        if (!this.streamGraph.getExecutionConfig().hasAutoGeneratedUIDsEnabled() && transform instanceof PhysicalTransformation && transform.getUserProvidedNodeHash() == null && transform.getUid() == null) {
            throw new IllegalStateException("Auto generated UIDs have been disabled but no UID or hash has been assigned to operator " + transform.getName());
        }
        if (transform.getMinResources() != null && transform.getPreferredResources() != null) {
            this.streamGraph.setResources(transform.getId(), transform.getMinResources(), transform.getPreferredResources());
        }
        this.streamGraph.setManagedMemoryUseCaseWeights(transform.getId(), transform.getManagedMemoryOperatorScopeUseCaseWeights(), transform.getManagedMemorySlotScopeUseCases());
        return transformedIds;
    }

    private <T> Collection<Integer> transformFeedback(FeedbackTransformation<T> iterate) {
        if (this.shouldExecuteInBatchMode) {
            throw new UnsupportedOperationException("Iterations are not supported in BATCH execution mode. If you want to execute such a pipeline, please set the '" + ExecutionOptions.RUNTIME_MODE.key() + "'=" + RuntimeExecutionMode.STREAMING.name());
        }
        if (iterate.getFeedbackEdges().size() <= 0) {
            throw new IllegalStateException("Iteration " + iterate + " does not have any feedback edges.");
        }
        List<Transformation<?>> inputs = iterate.getInputs();
        Preconditions.checkState((inputs.size() == 1 ? 1 : 0) != 0);
        Transformation<?> input = inputs.get(0);
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        Collection<Integer> inputIds = this.transform(input);
        resultIds.addAll(inputIds);
        if (this.alreadyTransformed.containsKey(iterate)) {
            return this.alreadyTransformed.get(iterate);
        }
        Tuple2<StreamNode, StreamNode> itSourceAndSink = this.streamGraph.createIterationSourceAndSink(iterate.getId(), StreamGraphGenerator.getNewIterationNodeId(), StreamGraphGenerator.getNewIterationNodeId(), iterate.getWaitTime(), iterate.getParallelism(), iterate.getMaxParallelism(), iterate.getMinResources(), iterate.getPreferredResources());
        StreamNode itSource = (StreamNode)itSourceAndSink.f0;
        StreamNode itSink = (StreamNode)itSourceAndSink.f1;
        this.streamGraph.setSerializers(itSource.getId(), null, null, iterate.getOutputType().createSerializer(this.executionConfig));
        this.streamGraph.setSerializers(itSink.getId(), iterate.getOutputType().createSerializer(this.executionConfig), null, null);
        resultIds.add(itSource.getId());
        this.alreadyTransformed.put(iterate, resultIds);
        ArrayList<Integer> allFeedbackIds = new ArrayList<Integer>();
        for (Transformation<T> feedbackEdge : iterate.getFeedbackEdges()) {
            Collection<Integer> feedbackIds = this.transform(feedbackEdge);
            allFeedbackIds.addAll(feedbackIds);
            for (Integer feedbackId : feedbackIds) {
                this.streamGraph.addEdge(feedbackId, itSink.getId(), 0);
            }
        }
        String slotSharingGroup = this.determineSlotSharingGroup(null, allFeedbackIds);
        if (slotSharingGroup == null) {
            slotSharingGroup = "SlotSharingGroup-" + iterate.getId();
        }
        itSink.setSlotSharingGroup(slotSharingGroup);
        itSource.setSlotSharingGroup(slotSharingGroup);
        return resultIds;
    }

    private <F> Collection<Integer> transformCoFeedback(CoFeedbackTransformation<F> coIterate) {
        if (this.shouldExecuteInBatchMode) {
            throw new UnsupportedOperationException("Iterations are not supported in BATCH execution mode. If you want to execute such a pipeline, please set the '" + ExecutionOptions.RUNTIME_MODE.key() + "'=" + RuntimeExecutionMode.STREAMING.name());
        }
        Tuple2<StreamNode, StreamNode> itSourceAndSink = this.streamGraph.createIterationSourceAndSink(coIterate.getId(), StreamGraphGenerator.getNewIterationNodeId(), StreamGraphGenerator.getNewIterationNodeId(), coIterate.getWaitTime(), coIterate.getParallelism(), coIterate.getMaxParallelism(), coIterate.getMinResources(), coIterate.getPreferredResources());
        StreamNode itSource = (StreamNode)itSourceAndSink.f0;
        StreamNode itSink = (StreamNode)itSourceAndSink.f1;
        this.streamGraph.setSerializers(itSource.getId(), null, null, coIterate.getOutputType().createSerializer(this.executionConfig));
        this.streamGraph.setSerializers(itSink.getId(), coIterate.getOutputType().createSerializer(this.executionConfig), null, null);
        Set<Integer> resultIds = Collections.singleton(itSource.getId());
        this.alreadyTransformed.put(coIterate, resultIds);
        ArrayList<Integer> allFeedbackIds = new ArrayList<Integer>();
        for (Transformation<F> feedbackEdge : coIterate.getFeedbackEdges()) {
            Collection<Integer> feedbackIds = this.transform(feedbackEdge);
            allFeedbackIds.addAll(feedbackIds);
            for (Integer feedbackId : feedbackIds) {
                this.streamGraph.addEdge(feedbackId, itSink.getId(), 0);
            }
        }
        String slotSharingGroup = this.determineSlotSharingGroup(null, allFeedbackIds);
        itSink.setSlotSharingGroup(slotSharingGroup);
        itSource.setSlotSharingGroup(slotSharingGroup);
        return Collections.singleton(itSource.getId());
    }

    private Collection<Integer> translate(TransformationTranslator<?, Transformation<?>> translator, Transformation<?> transform) {
        Preconditions.checkNotNull(translator);
        Preconditions.checkNotNull(transform);
        List<Collection<Integer>> allInputIds = this.getParentInputIds(transform.getInputs());
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        String slotSharingGroup = this.determineSlotSharingGroup(transform.getSlotSharingGroup(), allInputIds.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        ContextImpl context = new ContextImpl(this, this.streamGraph, slotSharingGroup, this.configuration);
        return this.shouldExecuteInBatchMode ? translator.translateForBatch(transform, context) : translator.translateForStreaming(transform, context);
    }

    private List<Collection<Integer>> getParentInputIds(@Nullable Collection<Transformation<?>> parentTransformations) {
        ArrayList<Collection<Integer>> allInputIds = new ArrayList<Collection<Integer>>();
        if (parentTransformations == null) {
            return allInputIds;
        }
        for (Transformation<?> transformation : parentTransformations) {
            allInputIds.add(this.transform(transformation));
        }
        return allInputIds;
    }

    private String determineSlotSharingGroup(String specifiedGroup, Collection<Integer> inputIds) {
        if (specifiedGroup != null) {
            return specifiedGroup;
        }
        String inputGroup = null;
        for (int id : inputIds) {
            String inputGroupCandidate = this.streamGraph.getSlotSharingGroup(id);
            if (inputGroup == null) {
                inputGroup = inputGroupCandidate;
                continue;
            }
            if (inputGroup.equals(inputGroupCandidate)) continue;
            return DEFAULT_SLOT_SHARING_GROUP;
        }
        return inputGroup == null ? DEFAULT_SLOT_SHARING_GROUP : inputGroup;
    }

    static {
        HashMap<Class<KeyedBroadcastStateTransformation>, TransformationTranslator<Object, Object>> tmp = new HashMap<Class<KeyedBroadcastStateTransformation>, TransformationTranslator<Object, Object>>();
        tmp.put(OneInputTransformation.class, new OneInputTransformationTranslator());
        tmp.put(TwoInputTransformation.class, new TwoInputTransformationTranslator());
        tmp.put(MultipleInputTransformation.class, new MultiInputTransformationTranslator());
        tmp.put(KeyedMultipleInputTransformation.class, new MultiInputTransformationTranslator());
        tmp.put(SourceTransformation.class, new SourceTransformationTranslator());
        tmp.put(SinkTransformation.class, new SinkTransformationTranslator());
        tmp.put(LegacySinkTransformation.class, new LegacySinkTransformationTranslator());
        tmp.put(LegacySourceTransformation.class, new LegacySourceTransformationTranslator());
        tmp.put(UnionTransformation.class, new UnionTransformationTranslator());
        tmp.put(PartitionTransformation.class, new PartitionTransformationTranslator());
        tmp.put(SideOutputTransformation.class, new SideOutputTransformationTranslator());
        tmp.put(ReduceTransformation.class, new ReduceTransformationTranslator());
        tmp.put(TimestampsAndWatermarksTransformation.class, new TimestampsAndWatermarksTransformationTranslator());
        tmp.put(BroadcastStateTransformation.class, new BroadcastStateTransformationTranslator());
        tmp.put(KeyedBroadcastStateTransformation.class, new KeyedBroadcastStateTransformationTranslator());
        translatorMap = Collections.unmodifiableMap(tmp);
        iterationIdCounter = 0;
    }

    private static class ContextImpl
    implements TransformationTranslator.Context {
        private final StreamGraphGenerator streamGraphGenerator;
        private final StreamGraph streamGraph;
        private final String slotSharingGroup;
        private final ReadableConfig config;

        public ContextImpl(StreamGraphGenerator streamGraphGenerator, StreamGraph streamGraph, String slotSharingGroup, ReadableConfig config) {
            this.streamGraphGenerator = (StreamGraphGenerator)Preconditions.checkNotNull((Object)streamGraphGenerator);
            this.streamGraph = (StreamGraph)Preconditions.checkNotNull((Object)streamGraph);
            this.slotSharingGroup = (String)Preconditions.checkNotNull((Object)slotSharingGroup);
            this.config = (ReadableConfig)Preconditions.checkNotNull((Object)config);
        }

        @Override
        public StreamGraph getStreamGraph() {
            return this.streamGraph;
        }

        @Override
        public Collection<Integer> getStreamNodeIds(Transformation<?> transformation) {
            Preconditions.checkNotNull(transformation);
            Collection ids = (Collection)this.streamGraphGenerator.alreadyTransformed.get(transformation);
            Preconditions.checkState((ids != null ? 1 : 0) != 0, (Object)("Parent transformation \"" + transformation + "\" has not been transformed."));
            return ids;
        }

        @Override
        public String getSlotSharingGroup() {
            return this.slotSharingGroup;
        }

        @Override
        public long getDefaultBufferTimeout() {
            return this.streamGraphGenerator.defaultBufferTimeout;
        }

        @Override
        public ReadableConfig getGraphGeneratorConfig() {
            return this.config;
        }
    }
}

