/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.Command;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.Method;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.ShutdownSignalException;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.AMQChannel;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.AMQCommand;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.RpcWrapper;

public class CompletableFutureRpcWrapper
implements RpcWrapper {
    private final Method request;
    private final CompletableFuture<Command> completableFuture;

    public CompletableFutureRpcWrapper(Method method, CompletableFuture<Command> completableFuture) {
        this.request = method;
        this.completableFuture = completableFuture;
    }

    @Override
    public boolean canHandleReply(AMQCommand command) {
        return AMQChannel.SimpleBlockingRpcContinuation.isResponseCompatibleWithRequest(this.request, command.getMethod());
    }

    @Override
    public void complete(AMQCommand command) {
        this.completableFuture.complete(command);
    }

    @Override
    public void shutdown(ShutdownSignalException signal) {
        this.completableFuture.completeExceptionally(signal);
    }
}

