/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.reader.deserializer;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.kafka.source.reader.deserializer.ValueDeserializerWrapper;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Configurable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;
import org.apache.flink.util.Collector;

public interface KafkaRecordDeserializer<T>
extends Serializable,
ResultTypeQueryable<T> {
    public void deserialize(ConsumerRecord<byte[], byte[]> var1, Collector<T> var2) throws Exception;

    public static <V> KafkaRecordDeserializer<V> valueOnly(Class<? extends Deserializer<V>> valueDeserializerClass) {
        return new ValueDeserializerWrapper(valueDeserializerClass, Collections.emptyMap());
    }

    public static <V, D extends Configurable & Deserializer<V>> KafkaRecordDeserializer<V> valueOnly(Class<D> valueDeserializerClass, Map<String, String> config) {
        return new ValueDeserializerWrapper(valueDeserializerClass, config);
    }
}

