/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.PartitionSetSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.TopicListSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.TopicPatternSubscriber;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;

public interface KafkaSubscriber
extends Serializable {
    public PartitionChange getPartitionChanges(AdminClient var1, Set<TopicPartition> var2);

    public static KafkaSubscriber getTopicListSubscriber(List<String> topics) {
        return new TopicListSubscriber(topics);
    }

    public static KafkaSubscriber getTopicPatternSubscriber(Pattern topicPattern) {
        return new TopicPatternSubscriber(topicPattern);
    }

    public static KafkaSubscriber getPartitionSetSubscriber(Set<TopicPartition> partitions) {
        return new PartitionSetSubscriber(partitions);
    }

    public static class PartitionChange {
        private final Set<TopicPartition> newPartitions;
        private final Set<TopicPartition> removedPartitions;

        PartitionChange(Set<TopicPartition> newPartitions, Set<TopicPartition> removedPartitions) {
            this.newPartitions = newPartitions;
            this.removedPartitions = removedPartitions;
        }

        public Set<TopicPartition> getNewPartitions() {
            return this.newPartitions;
        }

        public Set<TopicPartition> getRemovedPartitions() {
            return this.removedPartitions;
        }
    }
}

