/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SslPrincipalMapper {
    private static final String RULE_PATTERN = "(DEFAULT)|RULE:((\\\\.|[^\\\\/])*)/((\\\\.|[^\\\\/])*)/([LU]?).*?|(.*?)";
    private static final Pattern RULE_SPLITTER = Pattern.compile("\\s*((DEFAULT)|RULE:((\\\\.|[^\\\\/])*)/((\\\\.|[^\\\\/])*)/([LU]?).*?|(.*?))\\s*(,\\s*|$)");
    private static final Pattern RULE_PARSER = Pattern.compile("(DEFAULT)|RULE:((\\\\.|[^\\\\/])*)/((\\\\.|[^\\\\/])*)/([LU]?).*?|(.*?)");
    private final List<Rule> rules;

    public SslPrincipalMapper(String sslPrincipalMappingRules) {
        this.rules = SslPrincipalMapper.parseRules(SslPrincipalMapper.splitRules(sslPrincipalMappingRules));
    }

    public static SslPrincipalMapper fromRules(String sslPrincipalMappingRules) {
        return new SslPrincipalMapper(sslPrincipalMappingRules);
    }

    private static List<String> splitRules(String sslPrincipalMappingRules) {
        if (sslPrincipalMappingRules == null) {
            sslPrincipalMappingRules = "DEFAULT";
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = RULE_SPLITTER.matcher(sslPrincipalMappingRules.trim());
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    private static List<Rule> parseRules(List<String> rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (String rule : rules) {
            Matcher matcher = RULE_PARSER.matcher(rule);
            if (!matcher.lookingAt()) {
                throw new IllegalArgumentException("Invalid rule: " + rule);
            }
            if (rule.length() != matcher.end()) {
                throw new IllegalArgumentException("Invalid rule: `" + rule + "`, unmatched substring: `" + rule.substring(matcher.end()) + "`");
            }
            if (matcher.group(1) != null) {
                result.add(new Rule());
                continue;
            }
            if (matcher.group(2) == null) continue;
            result.add(new Rule(matcher.group(2), matcher.group(4), "L".equals(matcher.group(6)), "U".equals(matcher.group(6))));
        }
        return result;
    }

    public String getName(String distinguishedName) throws IOException {
        for (Rule r : this.rules) {
            String principalName = r.apply(distinguishedName);
            if (principalName == null) continue;
            return principalName;
        }
        throw new NoMatchingRule("No rules apply to " + distinguishedName + ", rules " + this.rules);
    }

    public String toString() {
        return "SslPrincipalMapper(rules = " + this.rules + ")";
    }

    private static class Rule {
        private static final Pattern BACK_REFERENCE_PATTERN = Pattern.compile("\\$(\\d+)");
        private final boolean isDefault;
        private final Pattern pattern;
        private final String replacement;
        private final boolean toLowerCase;
        private final boolean toUpperCase;

        Rule() {
            this.isDefault = true;
            this.pattern = null;
            this.replacement = null;
            this.toLowerCase = false;
            this.toUpperCase = false;
        }

        Rule(String pattern, String replacement, boolean toLowerCase, boolean toUpperCase) {
            this.isDefault = false;
            this.pattern = pattern == null ? null : Pattern.compile(pattern);
            this.replacement = replacement;
            this.toLowerCase = toLowerCase;
            this.toUpperCase = toUpperCase;
        }

        String apply(String distinguishedName) {
            if (this.isDefault) {
                return distinguishedName;
            }
            String result = null;
            Matcher m = this.pattern.matcher(distinguishedName);
            if (m.matches()) {
                result = distinguishedName.replaceAll(this.pattern.pattern(), this.escapeLiteralBackReferences(this.replacement, m.groupCount()));
            }
            if (this.toLowerCase && result != null) {
                result = result.toLowerCase(Locale.ENGLISH);
            } else if (this.toUpperCase & result != null) {
                result = result.toUpperCase(Locale.ENGLISH);
            }
            return result;
        }

        private String escapeLiteralBackReferences(String unescaped, int numCapturingGroups) {
            if (numCapturingGroups == 0) {
                return unescaped;
            }
            String value = unescaped;
            Matcher backRefMatcher = BACK_REFERENCE_PATTERN.matcher(value);
            while (backRefMatcher.find()) {
                int originalBackRefIndex;
                int backRefIndex;
                String backRefNum = backRefMatcher.group(1);
                if (backRefNum.startsWith("0")) continue;
                for (backRefIndex = originalBackRefIndex = Integer.parseInt(backRefNum); backRefIndex > numCapturingGroups && backRefIndex >= 10; backRefIndex /= 10) {
                }
                if (backRefIndex <= numCapturingGroups) continue;
                StringBuilder sb = new StringBuilder(value.length() + 1);
                int groupStart = backRefMatcher.start(1);
                sb.append(value.substring(0, groupStart - 1));
                sb.append("\\");
                sb.append(value.substring(groupStart - 1));
                value = sb.toString();
            }
            return value;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.isDefault) {
                buf.append("DEFAULT");
            } else {
                buf.append("RULE:");
                if (this.pattern != null) {
                    buf.append(this.pattern);
                }
                if (this.replacement != null) {
                    buf.append("/");
                    buf.append(this.replacement);
                }
                if (this.toLowerCase) {
                    buf.append("/L");
                } else if (this.toUpperCase) {
                    buf.append("/U");
                }
            }
            return buf.toString();
        }
    }

    public static class NoMatchingRule
    extends IOException {
        NoMatchingRule(String msg) {
            super(msg);
        }
    }
}

