/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.acl;

import java.util.HashMap;
import java.util.Locale;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum AclPermissionType {
    UNKNOWN(0),
    ANY(1),
    DENY(2),
    ALLOW(3);

    private static final HashMap<Byte, AclPermissionType> CODE_TO_VALUE;
    private final byte code;

    public static AclPermissionType fromString(String str) {
        try {
            return AclPermissionType.valueOf(str.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static AclPermissionType fromCode(byte code) {
        AclPermissionType permissionType = CODE_TO_VALUE.get(code);
        if (permissionType == null) {
            return UNKNOWN;
        }
        return permissionType;
    }

    private AclPermissionType(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    static {
        CODE_TO_VALUE = new HashMap();
        for (AclPermissionType permissionType : AclPermissionType.values()) {
            CODE_TO_VALUE.put(permissionType.code, permissionType);
        }
    }
}

