/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index.compact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.HiveIndexQueryContext;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.index.TableBasedIndexHandler;
import org.apache.hadoop.hive.ql.index.compact.HiveCompactIndexInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.IndexUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;

public class CompactIndexHandler
extends TableBasedIndexHandler {
    private Configuration configuration;
    private Set<String> partitionCols;
    private boolean useSorted;
    private static final Log LOG = LogFactory.getLog((String)CompactIndexHandler.class.getName());

    @Override
    public void analyzeIndexDefinition(Table baseTable, Index index, Table indexTable) throws HiveException {
        StorageDescriptor storageDesc = index.getSd();
        if (this.usesIndexTable() && indexTable != null) {
            StorageDescriptor indexTableSd = storageDesc.deepCopy();
            List<FieldSchema> indexTblCols = indexTableSd.getCols();
            FieldSchema bucketFileName = new FieldSchema("_bucketname", "string", "");
            indexTblCols.add(bucketFileName);
            FieldSchema offSets = new FieldSchema("_offsets", "array<bigint>", "");
            indexTblCols.add(offSets);
            indexTable.setSd(indexTableSd);
        }
    }

    @Override
    protected Task<?> getIndexBuilderMapRedTask(Set<ReadEntity> inputs, Set<WriteEntity> outputs, List<FieldSchema> indexField, boolean partitioned, PartitionDesc indexTblPartDesc, String indexTableName, PartitionDesc baseTablePartDesc, String baseTableName, String dbName) throws HiveException {
        String indexCols = HiveUtils.getUnparsedColumnNamesFromFieldSchema(indexField);
        StringBuilder command = new StringBuilder();
        LinkedHashMap<String, String> partSpec = indexTblPartDesc.getPartSpec();
        command.append("INSERT OVERWRITE TABLE " + HiveUtils.unparseIdentifier(dbName) + "." + HiveUtils.unparseIdentifier(indexTableName));
        if (partitioned && indexTblPartDesc != null) {
            command.append(" PARTITION ( ");
            List<String> ret = this.getPartKVPairStringArray(partSpec);
            for (int i = 0; i < ret.size(); ++i) {
                String partKV = ret.get(i);
                command.append(partKV);
                if (i >= ret.size() - 1) continue;
                command.append(",");
            }
            command.append(" ) ");
        }
        command.append(" SELECT ");
        command.append(indexCols);
        command.append(",");
        command.append(VirtualColumn.FILENAME.getName());
        command.append(",");
        command.append(" collect_set (");
        command.append(VirtualColumn.BLOCKOFFSET.getName());
        command.append(") ");
        command.append(" FROM " + HiveUtils.unparseIdentifier(dbName) + "." + HiveUtils.unparseIdentifier(baseTableName));
        LinkedHashMap<String, String> basePartSpec = baseTablePartDesc.getPartSpec();
        if (basePartSpec != null) {
            command.append(" WHERE ");
            List<String> pkv = this.getPartKVPairStringArray(basePartSpec);
            for (int i = 0; i < pkv.size(); ++i) {
                String partKV = pkv.get(i);
                command.append(partKV);
                if (i >= pkv.size() - 1) continue;
                command.append(" AND ");
            }
        }
        command.append(" GROUP BY ");
        command.append(indexCols + ", " + VirtualColumn.FILENAME.getName());
        HiveConf builderConf = new HiveConf(this.getConf(), CompactIndexHandler.class);
        builderConf.setBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES, false);
        builderConf.setBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES, false);
        builderConf.setBoolVar(HiveConf.ConfVars.HIVEMERGETEZFILES, false);
        Task<?> rootTask = IndexUtils.createRootTask(builderConf, inputs, outputs, command, partSpec, indexTableName, dbName);
        super.setStatsDir(builderConf);
        return rootTask;
    }

    @Override
    public void generateIndexQuery(List<Index> indexes, ExprNodeDesc predicate, ParseContext pctx, HiveIndexQueryContext queryContext) {
        Index index = indexes.get(0);
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = this.decomposePredicate(predicate, index, queryContext.getQueryPartitions());
        if (decomposedPredicate == null) {
            queryContext.setQueryTasks(null);
            return;
        }
        queryContext.setResidualPredicate(decomposedPredicate.residualPredicate);
        queryContext.setIndexInputFormat(HiveCompactIndexInputFormat.class.getName());
        StringBuilder qlCommand = new StringBuilder("INSERT OVERWRITE DIRECTORY ");
        String tmpFile = pctx.getContext().getMRTmpPath().toUri().toString();
        queryContext.setIndexIntermediateFile(tmpFile);
        qlCommand.append("\"" + tmpFile + "\" ");
        qlCommand.append("SELECT `_bucketname` ,  `_offsets` FROM ");
        qlCommand.append(HiveUtils.unparseIdentifier(index.getIndexTableName()));
        qlCommand.append(" WHERE ");
        String predicateString = decomposedPredicate.pushedPredicate.getExprString();
        qlCommand.append(predicateString);
        LOG.info((Object)("Generating tasks for re-entrant QL query: " + qlCommand.toString()));
        HiveConf queryConf = new HiveConf(pctx.getConf(), CompactIndexHandler.class);
        HiveConf.setBoolVar(queryConf, HiveConf.ConfVars.COMPRESSRESULT, false);
        Driver driver = new Driver(queryConf);
        driver.compile(qlCommand.toString(), false);
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_INDEX_COMPACT_BINARY_SEARCH) && this.useSorted) {
            MapWork work = null;
            String originalInputFormat = null;
            for (Task<? extends Serializable> task : driver.getPlan().getRootTasks()) {
                block10: {
                    String inputFormat;
                    if (!(task.getWork() instanceof MapredWork)) continue;
                    if (work != null) {
                        LOG.error((Object)"Tried to use a binary search on a compact index but there were an unexpected number (>1) of root level map reduce tasks in the reentrant query plan.");
                        work.setInputformat(null);
                        work.setInputFormatSorted(false);
                        break;
                    }
                    if (task.getWork() != null) {
                        work = ((MapredWork)task.getWork()).getMapWork();
                    }
                    originalInputFormat = inputFormat = work.getInputformat();
                    if (inputFormat == null) {
                        inputFormat = HiveConf.getVar(pctx.getConf(), HiveConf.ConfVars.HIVEINPUTFORMAT);
                    }
                    try {
                        if (!HiveInputFormat.class.isAssignableFrom(JavaUtils.loadClass(inputFormat))) {
                            work = null;
                        }
                        break block10;
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error((Object)("Map reduce work's input format class: " + inputFormat + " was not found. " + "Cannot use the fact the compact index is sorted."));
                        work = null;
                    }
                    break;
                }
                work.setInputFormatSorted(true);
            }
            if (work != null && !this.findIndexColumnFilter(work.getAliasToWork().values())) {
                LOG.error((Object)"Could not locate the index column's filter operator and expr node. Cannot use the fact the compact index is sorted.");
                work.setInputformat(originalInputFormat);
                work.setInputFormatSorted(false);
            }
        }
        queryContext.addAdditionalSemanticInputs(driver.getPlan().getInputs());
        queryContext.setQueryTasks(driver.getPlan().getRootTasks());
    }

    private boolean findIndexColumnFilter(Collection<Operator<? extends OperatorDesc>> operators) {
        for (Operator<? extends OperatorDesc> op : operators) {
            if (op instanceof FilterOperator && ((FilterDesc)((FilterOperator)op).getConf()).getPredicate().getChildren() != null && this.findIndexColumnExprNodeDesc(((FilterDesc)((FilterOperator)op).getConf()).getPredicate())) {
                ((FilterDesc)((FilterOperator)op).getConf()).setSortedFilter(true);
                return true;
            }
            if (!this.findIndexColumnFilter(op.getChildOperators())) continue;
            return true;
        }
        return false;
    }

    private boolean findIndexColumnExprNodeDesc(ExprNodeDesc expression) {
        if (expression.getChildren() == null) {
            return false;
        }
        if (expression.getChildren().size() == 2) {
            ExprNodeColumnDesc columnDesc = null;
            if (expression.getChildren().get(0) instanceof ExprNodeColumnDesc) {
                columnDesc = (ExprNodeColumnDesc)expression.getChildren().get(0);
            } else if (expression.getChildren().get(1) instanceof ExprNodeColumnDesc) {
                columnDesc = (ExprNodeColumnDesc)expression.getChildren().get(1);
            }
            if (columnDesc != null && !this.partitionCols.contains(columnDesc.getColumn())) {
                assert (expression instanceof ExprNodeGenericFuncDesc) : "Expression containing index column is does not support sorting, should not tryand sort";
                ((ExprNodeGenericFuncDesc)expression).setSortedExpr(true);
                return true;
            }
        }
        for (ExprNodeDesc child : expression.getChildren()) {
            if (!this.findIndexColumnExprNodeDesc(child)) continue;
            return true;
        }
        return false;
    }

    private HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(ExprNodeDesc predicate, Index index, Set<Partition> queryPartitions) {
        IndexPredicateAnalyzer analyzer = this.getIndexPredicateAnalyzer(index, queryPartitions);
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>();
        ExprNodeGenericFuncDesc residualPredicate = (ExprNodeGenericFuncDesc)analyzer.analyzePredicate(predicate, searchConditions);
        if (searchConditions.size() == 0) {
            return null;
        }
        int numIndexCols = 0;
        for (IndexSearchCondition searchCondition : searchConditions) {
            if (this.partitionCols.contains(searchCondition.getColumnDesc().getColumn())) continue;
            ++numIndexCols;
        }
        this.useSorted = numIndexCols == 1;
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposedPredicate.pushedPredicate = analyzer.translateSearchConditions(searchConditions);
        decomposedPredicate.residualPredicate = residualPredicate;
        return decomposedPredicate;
    }

    private IndexPredicateAnalyzer getIndexPredicateAnalyzer(Index index, Set<Partition> queryPartitions) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp(GenericUDFOPEqual.class.getName());
        analyzer.addComparisonOp(GenericUDFOPLessThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPEqualOrLessThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPGreaterThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPEqualOrGreaterThan.class.getName());
        List<FieldSchema> columnSchemas = index.getSd().getCols();
        for (FieldSchema column : columnSchemas) {
            analyzer.allowColumnName(column.getName());
        }
        this.partitionCols = new HashSet<String>();
        for (Partition part : queryPartitions) {
            if (part.getSpec().isEmpty()) continue;
            for (String column : part.getSpec().keySet()) {
                analyzer.allowColumnName(column);
                this.partitionCols.add(column);
            }
        }
        return analyzer;
    }

    @Override
    public boolean checkQuerySize(long querySize, HiveConf hiveConf) {
        long minSize = hiveConf.getLongVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER_COMPACT_MINSIZE);
        long maxSize = hiveConf.getLongVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER_COMPACT_MAXSIZE);
        if (maxSize < 0L) {
            maxSize = Long.MAX_VALUE;
        }
        return querySize > minSize & querySize < maxSize;
    }

    @Override
    public boolean usesIndexTable() {
        return true;
    }
}

