/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBSubQuery;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;

public class HiveParserSubQueryUtils {
    public static final CommonTreeAdaptor ADAPTOR = new CommonTreeAdaptor();

    static void extractConjuncts(HiveParserASTNode node, List<HiveParserASTNode> conjuncts) {
        if (node.getType() != 33) {
            conjuncts.add(node);
            return;
        }
        HiveParserSubQueryUtils.extractConjuncts((HiveParserASTNode)node.getChild(0), conjuncts);
        HiveParserSubQueryUtils.extractConjuncts((HiveParserASTNode)node.getChild(1), conjuncts);
    }

    public static List<HiveParserASTNode> findSubQueries(HiveParserASTNode node) {
        ArrayList<HiveParserASTNode> subQueries = new ArrayList<HiveParserASTNode>();
        HiveParserSubQueryUtils.findSubQueries(node, subQueries);
        return subQueries;
    }

    private static void findSubQueries(HiveParserASTNode node, List<HiveParserASTNode> subQueries) {
        ArrayDeque<HiveParserASTNode> stack = new ArrayDeque<HiveParserASTNode>();
        stack.push(node);
        block3: while (!stack.isEmpty()) {
            HiveParserASTNode next = (HiveParserASTNode)stack.pop();
            switch (next.getType()) {
                case 946: {
                    subQueries.add(next);
                    continue block3;
                }
            }
            int childCount = next.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                stack.push((HiveParserASTNode)next.getChild(i));
            }
        }
    }

    public static HiveParserQBSubQuery buildSubQuery(int sqIdx, HiveParserASTNode sqAST, HiveParserASTNode originalSQAST, HiveParserContext ctx, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
        HiveParserASTNode sqOp = (HiveParserASTNode)sqAST.getChild(0);
        HiveParserASTNode sq = (HiveParserASTNode)sqAST.getChild(1);
        HiveParserASTNode outerQueryExpr = (HiveParserASTNode)sqAST.getChild(2);
        if (outerQueryExpr != null && outerQueryExpr.getType() == 946) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION, originalSQAST.getChild(1), "Only 1 SubQuery expression is supported."));
        }
        return new HiveParserQBSubQuery(sqIdx, sq, HiveParserSubQueryUtils.buildSQOperator(sqOp), originalSQAST, ctx, frameworkConfig, cluster);
    }

    static HiveParserQBSubQuery.SubQueryTypeDef buildSQOperator(HiveParserASTNode astSQOp) throws SemanticException {
        HiveParserASTNode opAST = (HiveParserASTNode)astSQOp.getChild(0);
        HiveParserQBSubQuery.SubQueryType type = HiveParserQBSubQuery.SubQueryType.get(opAST);
        return new HiveParserQBSubQuery.SubQueryTypeDef(opAST, type);
    }

    static int checkAggOrWindowing(HiveParserASTNode expressionTree) throws SemanticException {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 766 || exprTokenType == 767 || exprTokenType == 768) {
            String functionName;
            GenericUDAFResolver udafResolver;
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(expressionTree.getChildCount() - 1).getType() == 1021) {
                return 3;
            }
            if (expressionTree.getChild(0).getType() == 24 && (udafResolver = FunctionRegistry.getGenericUDAFResolver(functionName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText()))) != null) {
                if (udafResolver instanceof GenericUDAFCount) {
                    return 2;
                }
                return 1;
            }
        }
        int r = 0;
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            int c = HiveParserSubQueryUtils.checkAggOrWindowing((HiveParserASTNode)expressionTree.getChild(i));
            r = Math.max(r, c);
        }
        return r;
    }

    static HiveParserASTNode subQueryWhere(HiveParserASTNode insertClause) {
        if (insertClause.getChildCount() > 2 && insertClause.getChild(2).getType() == 1018) {
            return (HiveParserASTNode)insertClause.getChild(2);
        }
        return null;
    }

    private static void checkForSubqueries(HiveParserASTNode node) throws SemanticException {
        if (node.getType() == 946 && node.getParent().getType() != 192) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Invalid subquery. Subquery in SELECT could only be top-level expression"));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            HiveParserSubQueryUtils.checkForSubqueries((HiveParserASTNode)node.getChild(i));
        }
    }

    public static void checkForTopLevelSubqueries(HiveParserASTNode selExprList) throws SemanticException {
        assert (selExprList.getType() == 903 || selExprList.getType() == 904);
        for (int i = 0; i < selExprList.getChildCount(); ++i) {
            HiveParserASTNode selExpr = (HiveParserASTNode)selExprList.getChild(i);
            assert (selExpr.getType() == 905 || selExpr.getType() == 344);
            if (selExpr.getType() == 344) continue;
            if (selExpr.getChildCount() == 1 && selExpr.getChild(0).getType() == 946) {
                if (selExprList.getType() != 904) continue;
                throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Invalid subquery. Subquery with DISTINCT clause is not supported!"));
            }
            for (int j = 0; j < selExpr.getChildCount(); ++j) {
                HiveParserSubQueryUtils.checkForSubqueries((HiveParserASTNode)selExpr.getChild(j));
            }
        }
    }

    public static interface ISubQueryJoinInfo {
        public String getAlias();

        public HiveParserQBSubQuery getSubQuery();
    }
}

