/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.flink.table.planner.delegation.hive.HiveParserTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNodeOrigin;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSubQueryDiagnostic;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSubQueryUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveParserQBSubQuery {
    private final String alias;
    private final HiveParserASTNode subQueryAST;
    private final SubQueryTypeDef operator;
    private final transient HiveParserASTNodeOrigin originalSQASTOrigin;
    private NotInCheck notInCheck;
    private final HiveParserSubQueryDiagnostic.QBSubQueryRewrite subQueryDiagnostic;
    private final FrameworkConfig frameworkConfig;
    private final RelOptCluster cluster;

    public HiveParserQBSubQuery(int sqIdx, HiveParserASTNode subQueryAST, SubQueryTypeDef operator, HiveParserASTNode originalSQAST, HiveParserContext ctx, FrameworkConfig frameworkConfig, RelOptCluster cluster) {
        this.subQueryAST = subQueryAST;
        this.operator = operator;
        this.alias = "sq_" + sqIdx;
        String s = ctx.getTokenRewriteStream().toString(originalSQAST.getTokenStartIndex(), originalSQAST.getTokenStopIndex());
        this.originalSQASTOrigin = new HiveParserASTNodeOrigin("SubQuery", this.alias, s, this.alias, originalSQAST);
        if (operator.getType() == SubQueryType.NOT_IN) {
            this.notInCheck = new NotInCheck();
        }
        this.subQueryDiagnostic = HiveParserSubQueryDiagnostic.getRewrite(this, ctx.getTokenRewriteStream(), ctx);
        this.frameworkConfig = frameworkConfig;
        this.cluster = cluster;
    }

    public boolean subqueryRestrictionsCheck(HiveParserRowResolver parentQueryRR, boolean forHavingClause, String outerQueryAlias) throws SemanticException {
        HiveParserASTNode insertClause = this.getChildFromSubqueryAST("Insert", 785);
        HiveParserASTNode selectClause = (HiveParserASTNode)insertClause.getChild(1);
        int selectExprStart = 0;
        if (selectClause.getChild(0).getType() == 344) {
            selectExprStart = 1;
        }
        if (this.operator.getType() != SubQueryType.EXISTS && this.operator.getType() != SubQueryType.NOT_EXISTS && selectClause.getChildCount() - selectExprStart > 1) {
            this.subQueryAST.setOrigin(this.originalSQASTOrigin);
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_SUBQUERY_EXPRESSION, this.subQueryAST, "SubQuery can contain only 1 item in Select List."));
        }
        boolean hasAggreateExprs = false;
        boolean hasWindowing = false;
        boolean hasCount = false;
        for (int i = selectExprStart; i < selectClause.getChildCount(); ++i) {
            HiveParserASTNode selectItem = (HiveParserASTNode)selectClause.getChild(i);
            int r = HiveParserSubQueryUtils.checkAggOrWindowing(selectItem);
            hasWindowing |= r == 3;
            hasAggreateExprs |= r == 1 | r == 2;
            hasCount |= r == 2;
        }
        HiveParserASTNode whereClause = HiveParserSubQueryUtils.subQueryWhere(insertClause);
        if (whereClause == null) {
            return false;
        }
        HiveParserASTNode searchCond = (HiveParserASTNode)whereClause.getChild(0);
        ArrayList<HiveParserASTNode> conjuncts = new ArrayList<HiveParserASTNode>();
        HiveParserSubQueryUtils.extractConjuncts(searchCond, conjuncts);
        ConjunctAnalyzer conjunctAnalyzer = new ConjunctAnalyzer(parentQueryRR, forHavingClause, outerQueryAlias, this.frameworkConfig, this.cluster);
        boolean hasCorrelation = false;
        boolean hasNonEquiJoinPred = false;
        for (HiveParserASTNode conjunctAST : conjuncts) {
            Conjunct conjunct = conjunctAnalyzer.analyzeConjunct(conjunctAST);
            if (conjunct.isCorrelated()) {
                hasCorrelation = true;
            }
            if (!conjunct.eitherSideRefersBoth() || conjunctAST.getType() == 18) continue;
            hasNonEquiJoinPred = true;
        }
        boolean noImplicityGby = true;
        if (insertClause.getChild(1).getChildCount() > 3 && insertClause.getChild(1).getChild(3).getType() == 775 && insertClause.getChild(1).getChild(3) != null) {
            noImplicityGby = false;
        }
        if (hasWindowing && hasCorrelation) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION, this.subQueryAST, "Correlated Sub Queries cannot contain Windowing clauses."));
        }
        if (hasAggreateExprs && noImplicityGby) {
            if (this.operator.getType() == SubQueryType.EXISTS || this.operator.getType() == SubQueryType.NOT_EXISTS) {
                if (hasCorrelation) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_SUBQUERY_EXPRESSION, this.subQueryAST, "A predicate on EXISTS/NOT EXISTS SubQuery with implicit Aggregation(no Group By clause) cannot be rewritten."));
                }
            } else {
                if (this.operator.getType() == SubQueryType.SCALAR) {
                    if (hasNonEquiJoinPred) {
                        throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_SUBQUERY_EXPRESSION, this.subQueryAST, "Scalar subqueries with aggregate cannot have non-equi join predicate"));
                    }
                    return hasCorrelation;
                }
                if (this.operator.getType() == SubQueryType.IN) {
                    return hasCount && hasCorrelation;
                }
                if (this.operator.getType() == SubQueryType.NOT_IN) {
                    return hasCorrelation;
                }
            }
        }
        return false;
    }

    private HiveParserASTNode getChildFromSubqueryAST(String errorMsg, int type) throws SemanticException {
        HiveParserASTNode childAST = (HiveParserASTNode)this.subQueryAST.getFirstChildWithType(type);
        if (childAST == null && errorMsg != null) {
            this.subQueryAST.setOrigin(this.originalSQASTOrigin);
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_SUBQUERY_EXPRESSION, this.subQueryAST, errorMsg + " clause is missing in SubQuery."));
        }
        return childAST;
    }

    public String getAlias() {
        return this.alias;
    }

    class NotInCheck
    implements HiveParserSubQueryUtils.ISubQueryJoinInfo {
        List<HiveParserASTNode> subQryCorrExprs = new ArrayList<HiveParserASTNode>();

        NotInCheck() {
        }

        @Override
        public String getAlias() {
            return HiveParserQBSubQuery.this.getAlias() + "_notin_nullcheck";
        }

        @Override
        public HiveParserQBSubQuery getSubQuery() {
            return HiveParserQBSubQuery.this;
        }
    }

    static class ConjunctAnalyzer {
        private final HiveParserRowResolver parentQueryRR;
        boolean forHavingClause;
        String parentQueryNewAlias;
        NodeProcessor defaultExprProcessor;
        Stack<Node> stack;
        private final FrameworkConfig frameworkConfig;
        private final RelOptCluster cluster;

        ConjunctAnalyzer(HiveParserRowResolver parentQueryRR, boolean forHavingClause, String parentQueryNewAlias, FrameworkConfig frameworkConfig, RelOptCluster cluster) {
            this.parentQueryRR = parentQueryRR;
            this.defaultExprProcessor = new HiveParserTypeCheckProcFactory.DefaultExprProcessor();
            this.forHavingClause = forHavingClause;
            this.parentQueryNewAlias = parentQueryNewAlias;
            this.stack = new Stack();
            this.frameworkConfig = frameworkConfig;
            this.cluster = cluster;
        }

        private ObjectPair<ExprType, ColumnInfo> analyzeExpr(HiveParserASTNode expr) {
            ColumnInfo cInfo = null;
            if (this.forHavingClause) {
                try {
                    cInfo = this.parentQueryRR.getExpression(expr);
                    if (cInfo != null) {
                        return ObjectPair.create(ExprType.REFERS_PARENT, cInfo);
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
            if (expr.getType() == 16) {
                HiveParserASTNode dot = this.firstDot(expr);
                cInfo = this.resolveDot(dot);
                if (cInfo != null) {
                    return ObjectPair.create(ExprType.REFERS_PARENT, cInfo);
                }
                return ObjectPair.create(ExprType.REFERS_SUBQUERY, null);
            }
            if (expr.getType() == 977) {
                return ObjectPair.create(ExprType.REFERS_SUBQUERY, null);
            }
            ExprType exprType = ExprType.REFERS_NONE;
            int cnt = expr.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                HiveParserASTNode child = (HiveParserASTNode)expr.getChild(i);
                exprType = exprType.combine(this.analyzeExpr(child).getFirst());
            }
            return ObjectPair.create(exprType, null);
        }

        Conjunct analyzeConjunct(HiveParserASTNode conjunct) throws SemanticException {
            int type = conjunct.getType();
            if (type == 18) {
                HiveParserASTNode left = (HiveParserASTNode)conjunct.getChild(0);
                HiveParserASTNode right = (HiveParserASTNode)conjunct.getChild(1);
                ObjectPair<ExprType, ColumnInfo> leftInfo = this.analyzeExpr(left);
                ObjectPair<ExprType, ColumnInfo> rightInfo = this.analyzeExpr(right);
                return new Conjunct(left, right, leftInfo.getFirst(), rightInfo.getFirst(), leftInfo.getSecond(), rightInfo.getSecond());
            }
            ObjectPair<ExprType, ColumnInfo> sqExprInfo = this.analyzeExpr(conjunct);
            return new Conjunct(conjunct, null, sqExprInfo.getFirst(), null, sqExprInfo.getSecond(), sqExprInfo.getSecond());
        }

        protected ColumnInfo resolveDot(HiveParserASTNode node) {
            try {
                HiveParserTypeCheckCtx tcCtx = new HiveParserTypeCheckCtx(this.parentQueryRR, this.frameworkConfig, this.cluster);
                String str = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(node.getChild(1).getText());
                ExprNodeConstantDesc idDesc = new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, str.toLowerCase());
                Object desc = this.defaultExprProcessor.process(node, this.stack, tcCtx, null, idDesc);
                if (desc instanceof ExprNodeColumnDesc) {
                    ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)desc;
                    String[] qualName = this.parentQueryRR.reverseLookup(colDesc.getColumn());
                    return this.parentQueryRR.get(qualName[0], qualName[1]);
                }
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            return null;
        }

        protected HiveParserASTNode firstDot(HiveParserASTNode dot) {
            HiveParserASTNode firstChild = (HiveParserASTNode)dot.getChild(0);
            if (firstChild != null && firstChild.getType() == 16) {
                return this.firstDot(firstChild);
            }
            return dot;
        }
    }

    static class Conjunct {
        private final HiveParserASTNode leftExpr;
        private final HiveParserASTNode rightExpr;
        private final ExprType leftExprType;
        private final ExprType rightExprType;
        private final ColumnInfo leftOuterColInfo;
        private final ColumnInfo rightOuterColInfo;

        Conjunct(HiveParserASTNode leftExpr, HiveParserASTNode rightExpr, ExprType leftExprType, ExprType rightExprType, ColumnInfo leftOuterColInfo, ColumnInfo rightOuterColInfo) {
            this.leftExpr = leftExpr;
            this.rightExpr = rightExpr;
            this.leftExprType = leftExprType;
            this.rightExprType = rightExprType;
            this.leftOuterColInfo = leftOuterColInfo;
            this.rightOuterColInfo = rightOuterColInfo;
        }

        boolean eitherSideRefersBoth() {
            if (this.leftExprType == ExprType.REFERS_BOTH) {
                return true;
            }
            if (this.rightExpr != null) {
                return this.rightExprType == ExprType.REFERS_BOTH;
            }
            return false;
        }

        boolean isCorrelated() {
            if (this.rightExpr != null) {
                return this.leftExprType.combine(this.rightExprType) == ExprType.REFERS_BOTH;
            }
            return false;
        }
    }

    static enum ExprType {
        REFERS_NONE(false, false){

            @Override
            public ExprType combine(ExprType other) {
                return other;
            }
        }
        ,
        REFERS_PARENT(true, false){

            @Override
            public ExprType combine(ExprType other) {
                switch (other) {
                    case REFERS_SUBQUERY: 
                    case REFERS_BOTH: {
                        return REFERS_BOTH;
                    }
                }
                return this;
            }
        }
        ,
        REFERS_SUBQUERY(false, true){

            @Override
            public ExprType combine(ExprType other) {
                switch (other) {
                    case REFERS_BOTH: 
                    case REFERS_PARENT: {
                        return REFERS_BOTH;
                    }
                }
                return this;
            }
        }
        ,
        REFERS_BOTH(true, true){

            @Override
            public ExprType combine(ExprType other) {
                return this;
            }
        };

        final boolean refersParent;
        final boolean refersSubQuery;

        private ExprType(boolean refersParent, boolean refersSubQuery) {
            this.refersParent = refersParent;
            this.refersSubQuery = refersSubQuery;
        }

        public boolean refersParent() {
            return this.refersParent;
        }

        public abstract ExprType combine(ExprType var1);
    }

    public static class SubQueryTypeDef {
        private final HiveParserASTNode ast;
        private final SubQueryType type;

        public SubQueryTypeDef(HiveParserASTNode ast, SubQueryType type) {
            this.ast = ast;
            this.type = type;
        }

        public HiveParserASTNode getAst() {
            return this.ast;
        }

        public SubQueryType getType() {
            return this.type;
        }
    }

    public static enum SubQueryType {
        EXISTS,
        NOT_EXISTS,
        IN,
        NOT_IN,
        SCALAR;


        public static SubQueryType get(HiveParserASTNode opNode) throws SemanticException {
            if (opNode == null) {
                return SCALAR;
            }
            switch (opNode.getType()) {
                case 110: {
                    if (opNode.getParent().getParent().getParent() != null && opNode.getParent().getParent().getParent().getType() == 192) {
                        return NOT_EXISTS;
                    }
                    return EXISTS;
                }
                case 948: {
                    return NOT_EXISTS;
                }
                case 142: {
                    if (opNode.getParent().getParent().getParent() != null && opNode.getParent().getParent().getParent().getType() == 192) {
                        return NOT_IN;
                    }
                    return IN;
                }
                case 949: {
                    return NOT_IN;
                }
            }
            throw new SemanticException(HiveParserUtils.generateErrorMessage(opNode, "Operator not supported in SubQuery use."));
        }
    }
}

