/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import com.google.common.math.IntMath;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.runtime.tree.BaseTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.planner.delegation.hive.HiveParserRexNodeConverter;
import org.apache.flink.table.planner.delegation.hive.HiveParserTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseDriver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeDescUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserPTFInvocationSpec;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQB;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBExpr;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBParseInfo;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserWindowingSpec;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserDDLSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserBaseSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserBaseSemanticAnalyzer.class);

    private HiveParserBaseSemanticAnalyzer() {
    }

    public static List<FieldSchema> getColumns(HiveParserASTNode ast) throws SemanticException {
        return HiveParserBaseSemanticAnalyzer.getColumns(ast, true);
    }

    public static List<FieldSchema> getColumns(HiveParserASTNode ast, boolean lowerCase) throws SemanticException {
        return HiveParserBaseSemanticAnalyzer.getColumns(ast, lowerCase, new ArrayList<PrimaryKey>(), new ArrayList<NotNullConstraint>());
    }

    public static String getTypeStringFromAST(HiveParserASTNode typeNode) throws SemanticException {
        switch (typeNode.getType()) {
            case 813: {
                return "array<" + HiveParserBaseSemanticAnalyzer.getTypeStringFromAST((HiveParserASTNode)typeNode.getChild(0)) + ">";
            }
            case 817: {
                return "map<" + HiveParserBaseSemanticAnalyzer.getTypeStringFromAST((HiveParserASTNode)typeNode.getChild(0)) + "," + HiveParserBaseSemanticAnalyzer.getTypeStringFromAST((HiveParserASTNode)typeNode.getChild(1)) + ">";
            }
            case 944: {
                return HiveParserBaseSemanticAnalyzer.getStructTypeStringFromAST(typeNode);
            }
            case 1000: {
                return HiveParserBaseSemanticAnalyzer.getUnionTypeStringFromAST(typeNode);
            }
        }
        return HiveParserDDLSemanticAnalyzer.getTypeName(typeNode);
    }

    private static String getStructTypeStringFromAST(HiveParserASTNode typeNode) throws SemanticException {
        String typeStr = "struct<";
        int children = (typeNode = (HiveParserASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty struct not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            HiveParserASTNode child = (HiveParserASTNode)typeNode.getChild(i);
            buffer.append(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText())).append(":");
            buffer.append(HiveParserBaseSemanticAnalyzer.getTypeStringFromAST((HiveParserASTNode)child.getChild(1)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private static String getUnionTypeStringFromAST(HiveParserASTNode typeNode) throws SemanticException {
        String typeStr = "uniontype<";
        int children = (typeNode = (HiveParserASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty union not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            buffer.append(HiveParserBaseSemanticAnalyzer.getTypeStringFromAST((HiveParserASTNode)typeNode.getChild(i)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        typeStr = buffer.toString();
        return typeStr;
    }

    public static List<FieldSchema> getColumns(HiveParserASTNode ast, boolean lowerCase, List<PrimaryKey> primaryKeys, List<NotNullConstraint> notNulls) throws SemanticException {
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        int numCh = ast.getChildCount();
        ArrayList<PKInfo> pkInfos = new ArrayList<PKInfo>();
        HashMap<String, FieldSchema> nametoFS = new HashMap<String, FieldSchema>();
        Tree parent = ast.getParent();
        for (int i = 0; i < numCh; ++i) {
            FieldSchema col = new FieldSchema();
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(i);
            if (child.getToken().getType() == 862) {
                HiveParserBaseSemanticAnalyzer.processPrimaryKeyInfos(child, pkInfos);
                continue;
            }
            if (child.getToken().getType() == 763) {
                throw new SemanticException("FOREIGN KEY is not supported.");
            }
            Tree grandChild = child.getChild(0);
            if (grandChild != null) {
                String name = grandChild.getText();
                if (lowerCase) {
                    name = name.toLowerCase();
                }
                HiveParserBaseSemanticAnalyzer.checkColumnName(name);
                col.setName(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(name));
                HiveParserASTNode typeChild = (HiveParserASTNode)child.getChild(1);
                col.setType(HiveParserBaseSemanticAnalyzer.getTypeStringFromAST(typeChild));
                HiveParserASTNode constraintChild = null;
                if (child.getChildCount() == 4) {
                    col.setComment(HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
                    constraintChild = (HiveParserASTNode)child.getChild(3);
                } else if (child.getChildCount() == 3 && ((HiveParserASTNode)child.getChild(2)).getToken().getType() == 353) {
                    col.setComment(HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
                } else if (child.getChildCount() == 3) {
                    constraintChild = (HiveParserASTNode)child.getChild(2);
                }
                if (constraintChild != null) {
                    String[] qualifiedTabName = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)parent.getChild(0));
                    switch (constraintChild.getToken().getType()) {
                        case 825: {
                            notNulls.add(HiveParserBaseSemanticAnalyzer.processNotNull(constraintChild, qualifiedTabName[0], qualifiedTabName[1], col.getName()));
                            break;
                        }
                        default: {
                            throw new SemanticException("Unsupported constraint node: " + constraintChild);
                        }
                    }
                }
            }
            nametoFS.put(col.getName(), col);
            colList.add(col);
        }
        if (!pkInfos.isEmpty()) {
            HiveParserBaseSemanticAnalyzer.processPrimaryKeys((HiveParserASTNode)parent, pkInfos, primaryKeys, nametoFS);
        }
        return colList;
    }

    private static NotNullConstraint processNotNull(HiveParserASTNode nnNode, String dbName, String tblName, String colName) throws SemanticException {
        boolean enable = true;
        boolean validate = false;
        boolean rely = false;
        block6: for (int i = 0; i < nnNode.getChildCount(); ++i) {
            HiveParserASTNode child = (HiveParserASTNode)nnNode.getChild(i);
            switch (child.getToken().getType()) {
                case 751: 
                case 822: 
                case 827: {
                    continue block6;
                }
                case 740: {
                    enable = false;
                    continue block6;
                }
                case 1011: {
                    validate = true;
                    continue block6;
                }
                case 885: {
                    rely = true;
                    continue block6;
                }
                default: {
                    throw new SemanticException("Unexpected node for NOT NULL constraint: " + child);
                }
            }
        }
        return new NotNullConstraint(dbName, tblName, colName, null, enable, validate, rely);
    }

    private static void processPrimaryKeys(HiveParserASTNode parent, List<PKInfo> pkInfos, List<PrimaryKey> primaryKeys, Map<String, FieldSchema> nametoFS) throws SemanticException {
        boolean cnt = true;
        String[] qualifiedTabName = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)parent.getChild(0));
        for (PKInfo pkInfo : pkInfos) {
            String pk = pkInfo.colName;
            if (nametoFS.containsKey(pk)) {
                PrimaryKey currPrimaryKey = new PrimaryKey(qualifiedTabName[0], qualifiedTabName[1], pk, pkInfo.constraintName, false, false, pkInfo.rely);
                primaryKeys.add(currPrimaryKey);
                continue;
            }
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(pk));
        }
    }

    private static void processPrimaryKeyInfos(HiveParserASTNode pkNode, List<PKInfo> pkInfos) throws SemanticException {
        String userSpecifiedName = null;
        boolean enable = true;
        boolean validate = false;
        boolean rely = false;
        block8: for (int i = 0; i < pkNode.getChildCount(); ++i) {
            HiveParserASTNode child = (HiveParserASTNode)pkNode.getChild(i);
            switch (child.getType()) {
                case 751: 
                case 822: 
                case 827: {
                    continue block8;
                }
                case 740: {
                    enable = false;
                    continue block8;
                }
                case 1011: {
                    validate = true;
                    continue block8;
                }
                case 885: {
                    rely = true;
                    continue block8;
                }
                case 709: {
                    userSpecifiedName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText().toLowerCase());
                    continue block8;
                }
                case 956: {
                    for (int j = 0; j < child.getChildCount(); ++j) {
                        String colName = child.getChild(j).getText();
                        HiveParserBaseSemanticAnalyzer.checkColumnName(colName);
                        pkInfos.add(new PKInfo(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(colName.toLowerCase())));
                    }
                    continue block8;
                }
                default: {
                    throw new SemanticException("Unexpected node for PRIMARY KEY constraint: " + child);
                }
            }
        }
        if (enable) {
            throw new SemanticException("Invalid Primary Key syntax ENABLE feature not supported yet");
        }
        if (validate) {
            throw new SemanticException("Invalid Primary Key syntax VALIDATE feature not supported yet");
        }
        if (pkInfos.isEmpty()) {
            throw new SemanticException("No column specified as the primary key");
        }
        for (PKInfo pkInfo : pkInfos) {
            pkInfo.constraintName = userSpecifiedName;
            pkInfo.rely = rely;
        }
    }

    private static void checkColumnName(String columnName) throws SemanticException {
        if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(columnName.toUpperCase())) {
            throw new SemanticException("Invalid column name " + columnName);
        }
    }

    public static String getDotName(String[] qname) throws SemanticException {
        String genericName = StringUtils.join((Object[])qname, ".");
        if (qname.length != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, genericName);
        }
        return genericName;
    }

    public static void readProps(HiveParserASTNode prop, Map<String, String> mapProp) {
        for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
            String key = HiveParserBaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
            String value = null;
            if (prop.getChild(propChild).getChild(1) != null) {
                value = HiveParserBaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
            }
            mapProp.put(key, value);
        }
    }

    public static String[] getQualifiedTableName(HiveParserASTNode tabNameNode) throws SemanticException {
        if (tabNameNode.getType() != 980 || tabNameNode.getChildCount() != 1 && tabNameNode.getChildCount() != 2) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_TABLE_NAME, tabNameNode));
        }
        if (tabNameNode.getChildCount() == 2) {
            String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(0).getText());
            String tableName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(1).getText());
            return new String[]{dbName, tableName};
        }
        String tableName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(0).getText());
        return Utilities.getDbTableName(tableName);
    }

    public static Tuple2<String, String> charSetString(String charSetName, String charSetString) throws SemanticException {
        try {
            charSetName = charSetName.substring(1);
            if (charSetString.charAt(0) == '\'') {
                return Tuple2.of((Object)charSetName, (Object)new String(HiveParserBaseSemanticAnalyzer.unescapeSQLString(charSetString).getBytes(), charSetName));
            }
            assert (charSetString.charAt(0) == '0');
            assert (charSetString.charAt(1) == 'x');
            charSetString = charSetString.substring(2);
            byte[] bArray = new byte[charSetString.length() / 2];
            int j = 0;
            for (int i = 0; i < charSetString.length(); i += 2) {
                int val = Character.digit(charSetString.charAt(i), 16) * 16 + Character.digit(charSetString.charAt(i + 1), 16);
                if (val > 127) {
                    val -= 256;
                }
                bArray[j++] = (byte)val;
            }
            return Tuple2.of((Object)charSetName, (Object)new String(bArray, charSetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new SemanticException(e);
        }
    }

    public static String stripQuotes(String val) {
        return PlanUtils.stripQuotes(val);
    }

    public static String unescapeIdentifier(String val) {
        if (val == null) {
            return null;
        }
        if (val.charAt(0) == '`' && val.charAt(val.length() - 1) == '`') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static String getUnescapedUnqualifiedTableName(HiveParserASTNode node) {
        assert (node.getChildCount() <= 2);
        if (node.getChildCount() == 2) {
            node = (HiveParserASTNode)node.getChild(1);
        }
        return HiveParserBaseSemanticAnalyzer.getUnescapedName(node);
    }

    public static String getUnescapedName(HiveParserASTNode tableOrColumnNode) {
        return HiveParserBaseSemanticAnalyzer.getUnescapedName(tableOrColumnNode, null);
    }

    public static String getUnescapedName(HiveParserASTNode tableOrColumnNode, String currentDatabase) {
        int tokenType = tableOrColumnNode.getToken().getType();
        if (tokenType == 980) {
            Map.Entry<String, String> dbTablePair = HiveParserBaseSemanticAnalyzer.getDbTableNamePair(tableOrColumnNode);
            String dbName = dbTablePair.getKey();
            String tableName = dbTablePair.getValue();
            if (dbName != null) {
                return dbName + "." + tableName;
            }
            if (currentDatabase != null) {
                return currentDatabase + "." + tableName;
            }
            return tableName;
        }
        if (tokenType == 353) {
            return HiveParserBaseSemanticAnalyzer.unescapeSQLString(tableOrColumnNode.getText());
        }
        return HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tableOrColumnNode.getText());
    }

    public static Map.Entry<String, String> getDbTableNamePair(HiveParserASTNode tableNameNode) {
        assert (tableNameNode.getToken().getType() == 980);
        if (tableNameNode.getChildCount() == 2) {
            String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
            String tableName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(1).getText());
            return Pair.of(dbName, tableName);
        }
        String tableName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
        return Pair.of(null, tableName);
    }

    public static String unescapeSQLString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        for (int i = 0; i < b.length(); ++i) {
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && b.charAt(i) != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.equals(Character.valueOf(currentChar))) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\' && i + 6 < b.length() && b.charAt(i + 1) == 'u') {
                int code = 0;
                int base = i + 2;
                for (int j = 0; j < 4; ++j) {
                    int digit = Character.digit(b.charAt(j + base), 16);
                    code = (code << 4) + digit;
                }
                sb.append((char)code);
                i += 5;
                continue;
            }
            if (currentChar == '\\' && i + 4 < b.length()) {
                char i1 = b.charAt(i + 1);
                char i2 = b.charAt(i + 2);
                char i3 = b.charAt(i + 3);
                if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    byte bVal = (byte)(i3 - 48 + (i2 - 48) * 8 + (i1 - 48) * 8 * 8);
                    byte[] bValArr = new byte[]{bVal};
                    String tmp = new String(bValArr);
                    sb.append(tmp);
                    i += 3;
                    continue;
                }
            }
            if (currentChar == '\\' && i + 2 < b.length()) {
                char n = b.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static void validatePartSpec(Table tbl, Map<String, String> partSpec, HiveParserASTNode astNode, HiveConf conf, boolean shouldBeFull, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
        tbl.validatePartColumnNames(partSpec, shouldBeFull);
        HiveParserBaseSemanticAnalyzer.validatePartColumnType(tbl, partSpec, astNode, conf, frameworkConfig, cluster);
    }

    private static boolean getPartExprNodeDesc(HiveParserASTNode astNode, HiveConf conf, Map<HiveParserASTNode, ExprNodeDesc> astExprNodeMap, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
        if (astNode == null) {
            return true;
        }
        if (astNode.getChildren() == null || ((ArrayList)astNode.getChildren()).size() == 0) {
            return astNode.getType() != 860;
        }
        HiveParserTypeCheckCtx typeCheckCtx = new HiveParserTypeCheckCtx(null, frameworkConfig, cluster);
        String defaultPartitionName = HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        boolean result = true;
        for (Node childNode : astNode.getChildren()) {
            HiveParserASTNode partVal;
            HiveParserASTNode childASTNode = (HiveParserASTNode)childNode;
            if (childASTNode.getType() != 860) {
                result = HiveParserBaseSemanticAnalyzer.getPartExprNodeDesc(childASTNode, conf, astExprNodeMap, frameworkConfig, cluster) && result;
                continue;
            }
            boolean isDynamicPart = ((ArrayList)childASTNode.getChildren()).size() <= 1;
            boolean bl = result = !isDynamicPart && result;
            if (isDynamicPart || defaultPartitionName.equalsIgnoreCase(HiveParserBaseSemanticAnalyzer.unescapeSQLString((partVal = (HiveParserASTNode)((ArrayList)childASTNode.getChildren()).get(1)).getText()))) continue;
            astExprNodeMap.put((HiveParserASTNode)((ArrayList)childASTNode.getChildren()).get(0), HiveParserTypeCheckProcFactory.genExprNode(partVal, typeCheckCtx).get(partVal));
        }
        return result;
    }

    private static String stripIdentifierQuotes(String val) {
        if (val.charAt(0) == '`' && val.charAt(val.length() - 1) == '`') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    static List<HiveParserASTNode> doPhase1GetDistinctFuncExprs(HashMap<String, HiveParserASTNode> aggregationTrees) {
        ArrayList<HiveParserASTNode> exprs = new ArrayList<HiveParserASTNode>();
        for (Map.Entry<String, HiveParserASTNode> entry : aggregationTrees.entrySet()) {
            HiveParserASTNode value = entry.getValue();
            if (value.getToken().getType() != 767) continue;
            exprs.add(value);
        }
        return exprs;
    }

    static String findSimpleTableName(HiveParserASTNode tabref, int aliasIndex) {
        assert (tabref.getType() == 981);
        HiveParserASTNode tableTree = (HiveParserASTNode)tabref.getChild(0);
        String alias = aliasIndex != 0 ? HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tabref.getChild(aliasIndex).getText()) : HiveParserBaseSemanticAnalyzer.getUnescapedUnqualifiedTableName(tableTree);
        return alias;
    }

    static int[] findTabRefIdxs(HiveParserASTNode tabref) {
        assert (tabref.getType() == 981);
        int aliasIndex = 0;
        int propsIndex = -1;
        int tsampleIndex = -1;
        int ssampleIndex = -1;
        for (int index = 1; index < tabref.getChildCount(); ++index) {
            HiveParserASTNode ct = (HiveParserASTNode)tabref.getChild(index);
            if (ct.getToken().getType() == 960) {
                tsampleIndex = index;
                continue;
            }
            if (ct.getToken().getType() == 976) {
                ssampleIndex = index;
                continue;
            }
            if (ct.getToken().getType() == 965) {
                propsIndex = index;
                continue;
            }
            aliasIndex = index;
        }
        return new int[]{aliasIndex, propsIndex, tsampleIndex, ssampleIndex};
    }

    static String unparseExprForValuesClause(HiveParserASTNode expr) throws SemanticException {
        switch (expr.getToken().getType()) {
            case 341: {
                return expr.getText();
            }
            case 353: {
                return HiveParserBaseSemanticAnalyzer.unescapeSQLString(expr.getText());
            }
            case 117: {
                return "";
            }
            case 295: {
                return "TRUE";
            }
            case 338: {
                return "-" + HiveParserBaseSemanticAnalyzer.unparseExprForValuesClause((HiveParserASTNode)((ArrayList)expr.getChildren()).get(0));
            }
            case 829: {
                return null;
            }
        }
        throw new SemanticException("Expression of type " + expr.getText() + " not supported in insert/values");
    }

    public static String getColumnInternalName(int pos) {
        return HiveConf.getColumnInternalName(pos);
    }

    public static List<Integer> getGroupingSetsForRollup(int size) {
        ArrayList<Integer> groupingSetKeys = new ArrayList<Integer>();
        for (int i = 0; i <= size; ++i) {
            groupingSetKeys.add((1 << i) - 1);
        }
        return groupingSetKeys;
    }

    public static List<Integer> getGroupingSetsForCube(int size) {
        int count = 1 << size;
        ArrayList<Integer> results = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            results.add(i);
        }
        return results;
    }

    public static List<Integer> getGroupingSets(List<HiveParserASTNode> groupByExpr, HiveParserQBParseInfo parseInfo, String dest) throws SemanticException {
        HashMap<String, Integer> exprPos = new HashMap<String, Integer>();
        for (int i = 0; i < groupByExpr.size(); ++i) {
            HiveParserASTNode node = groupByExpr.get(i);
            exprPos.put(node.toStringTree(), i);
        }
        HiveParserASTNode root = parseInfo.getGroupByForClause(dest);
        ArrayList<Integer> result = new ArrayList<Integer>(root == null ? 0 : root.getChildCount());
        if (root != null) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                HiveParserASTNode child = (HiveParserASTNode)root.getChild(i);
                if (child.getType() != 777) continue;
                int bitmap = IntMath.pow(2, groupByExpr.size()) - 1;
                for (int j = 0; j < child.getChildCount(); ++j) {
                    String treeAsString = child.getChild(j).toStringTree();
                    Integer pos = (Integer)exprPos.get(treeAsString);
                    if (pos == null) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage((HiveParserASTNode)child.getChild(j), ErrorMsg.HIVE_GROUPING_SETS_EXPR_NOT_IN_GROUPBY.getErrorCodedMsg()));
                    }
                    bitmap = HiveParserUtils.unsetBit(bitmap, groupByExpr.size() - pos - 1);
                }
                result.add(bitmap);
            }
        }
        if (HiveParserBaseSemanticAnalyzer.checkForEmptyGroupingSets(result, IntMath.pow(2, groupByExpr.size()) - 1)) {
            throw new SemanticException("Empty grouping sets not allowed");
        }
        return result;
    }

    private static boolean checkForEmptyGroupingSets(List<Integer> bitmaps, int groupingIdAllSet) {
        boolean ret = true;
        for (int mask : bitmaps) {
            ret &= mask == groupingIdAllSet;
        }
        return ret;
    }

    public static List<HiveParserASTNode> getGroupByForClause(HiveParserQBParseInfo parseInfo, String dest) {
        if (parseInfo.getSelForClause(dest).getToken().getType() == 904) {
            HiveParserASTNode selectExprs = parseInfo.getSelForClause(dest);
            ArrayList<HiveParserASTNode> result = new ArrayList<HiveParserASTNode>(selectExprs == null ? 0 : selectExprs.getChildCount());
            if (selectExprs != null) {
                for (int i = 0; i < selectExprs.getChildCount(); ++i) {
                    if (((HiveParserASTNode)selectExprs.getChild(i)).getToken().getType() == 344) continue;
                    HiveParserASTNode grpbyExpr = (HiveParserASTNode)selectExprs.getChild(i).getChild(0);
                    result.add(grpbyExpr);
                }
            }
            return result;
        }
        HiveParserASTNode grpByExprs = parseInfo.getGroupByForClause(dest);
        ArrayList<HiveParserASTNode> result = new ArrayList<HiveParserASTNode>(grpByExprs == null ? 0 : grpByExprs.getChildCount());
        if (grpByExprs != null) {
            for (int i = 0; i < grpByExprs.getChildCount(); ++i) {
                HiveParserASTNode grpbyExpr = (HiveParserASTNode)grpByExprs.getChild(i);
                if (grpbyExpr.getType() == 777) continue;
                result.add(grpbyExpr);
            }
        }
        return result;
    }

    static String getAliasId(String alias, HiveParserQB qb) {
        return (qb.getId() == null ? alias : qb.getId() + ":" + alias).toLowerCase();
    }

    public static RexWindowBound getBound(HiveParserWindowingSpec.BoundarySpec spec, RelOptCluster cluster) {
        RexWindowBound res = null;
        if (spec != null) {
            SqlParserPos dummyPos = new SqlParserPos(1, 1);
            SqlNumericLiteral amt = spec.getAmt() == 0 || spec.getAmt() == Integer.MAX_VALUE ? null : SqlLiteral.createExactNumeric((String)String.valueOf(spec.getAmt()), (SqlParserPos)new SqlParserPos(2, 2));
            RexNode amtLiteral = amt == null ? null : cluster.getRexBuilder().makeLiteral((Object)spec.getAmt(), cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER), true);
            switch (spec.getDirection()) {
                case PRECEDING: {
                    if (amt == null) {
                        res = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)dummyPos), null);
                        break;
                    }
                    SqlCall call = (SqlCall)SqlWindow.createPreceding((SqlNode)amt, (SqlParserPos)dummyPos);
                    res = RexWindowBound.create((SqlNode)call, (RexNode)cluster.getRexBuilder().makeCall(call.getOperator(), new RexNode[]{amtLiteral}));
                    break;
                }
                case CURRENT: {
                    res = RexWindowBound.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)dummyPos), null);
                    break;
                }
                case FOLLOWING: {
                    if (amt == null) {
                        res = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedFollowing((SqlParserPos)dummyPos), null);
                        break;
                    }
                    SqlCall call = (SqlCall)SqlWindow.createFollowing((SqlNode)amt, (SqlParserPos)dummyPos);
                    res = RexWindowBound.create((SqlNode)call, (RexNode)cluster.getRexBuilder().makeCall(call.getOperator(), new RexNode[]{amtLiteral}));
                }
            }
        }
        return res;
    }

    public static Phase1Ctx initPhase1Ctx() {
        Phase1Ctx ctx1 = new Phase1Ctx();
        ctx1.nextNum = 0;
        ctx1.dest = "reduce";
        return ctx1;
    }

    static void warn(String msg) {
        SessionState.getConsole().printInfo(String.format("Warning: %s", msg));
    }

    static void handleQueryWindowClauses(HiveParserQB qb, Phase1Ctx ctx1, HiveParserASTNode node) throws SemanticException {
        HiveParserWindowingSpec spec = qb.getWindowingSpec(ctx1.dest);
        for (int i = 0; i < node.getChildCount(); ++i) {
            HiveParserBaseSemanticAnalyzer.processQueryWindowClause(spec, (HiveParserASTNode)node.getChild(i));
        }
    }

    public static void processPositionAlias(HiveParserASTNode ast, HiveConf conf) throws SemanticException {
        boolean isBothByPos = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_GROUPBY_ORDERBY_POSITION_ALIAS);
        boolean isGbyByPos = isBothByPos || Boolean.parseBoolean(conf.get("hive.groupby.position.alias", "false"));
        boolean isObyByPos = isBothByPos || Boolean.parseBoolean(conf.get("hive.orderby.position.alias", "true"));
        ArrayDeque<HiveParserASTNode> stack = new ArrayDeque<HiveParserASTNode>();
        stack.push(ast);
        while (!stack.isEmpty()) {
            HiveParserASTNode next = (HiveParserASTNode)stack.pop();
            if (next.getChildCount() == 0) continue;
            BaseTree selectNode = null;
            BaseTree groupbyNode = null;
            HiveParserASTNode orderbyNode = null;
            int childCount = next.getChildCount();
            for (int childPos = 0; childPos < childCount; ++childPos) {
                HiveParserASTNode node = (HiveParserASTNode)next.getChild(childPos);
                int type = node.getToken().getType();
                if (type == 903) {
                    selectNode = node;
                    continue;
                }
                if (type == 775) {
                    groupbyNode = node;
                    continue;
                }
                if (type != 855) continue;
                orderbyNode = node;
            }
            if (selectNode != null) {
                int selectExpCnt = selectNode.getChildCount();
                if (groupbyNode != null) {
                    for (int childPos = 0; childPos < groupbyNode.getChildCount(); ++childPos) {
                        HiveParserASTNode node = (HiveParserASTNode)groupbyNode.getChild(childPos);
                        if (node.getToken().getType() != 341) continue;
                        if (isGbyByPos) {
                            int pos = Integer.parseInt(node.getText());
                            if (pos > 0 && pos <= selectExpCnt) {
                                ((HiveParserASTNode)groupbyNode).setChild(childPos, selectNode.getChild(pos - 1).getChild(0));
                                continue;
                            }
                            throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_GROUPBY.getMsg("Position alias: " + pos + " does not exist\nThe Select List is indexed from 1 to " + selectExpCnt));
                        }
                        HiveParserBaseSemanticAnalyzer.warn("Using constant number  " + node.getText() + " in group by. If you try to use position alias when hive.groupby.position.alias is false, the position alias will be ignored.");
                    }
                }
                if (orderbyNode != null) {
                    int childPos;
                    boolean isAllCol = false;
                    for (childPos = 0; childPos < selectNode.getChildCount(); ++childPos) {
                        HiveParserASTNode node = (HiveParserASTNode)selectNode.getChild(childPos).getChild(0);
                        if (node == null || node.getToken().getType() != 652) continue;
                        isAllCol = true;
                    }
                    for (childPos = 0; childPos < orderbyNode.getChildCount(); ++childPos) {
                        HiveParserASTNode colNode = (HiveParserASTNode)orderbyNode.getChild(childPos).getChild(0);
                        HiveParserASTNode node = (HiveParserASTNode)colNode.getChild(0);
                        if (node == null || node.getToken().getType() != 341) continue;
                        if (isObyByPos) {
                            if (!isAllCol) {
                                int pos = Integer.parseInt(node.getText());
                                if (pos > 0 && pos <= selectExpCnt) {
                                    colNode.setChild(0, selectNode.getChild(pos - 1).getChild(0));
                                    continue;
                                }
                                throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_ORDERBY.getMsg("Position alias: " + pos + " does not exist\nThe Select List is indexed from 1 to " + selectExpCnt));
                            }
                            throw new SemanticException(ErrorMsg.NO_SUPPORTED_ORDERBY_ALLCOLREF_POS.getMsg());
                        }
                        HiveParserBaseSemanticAnalyzer.warn("Using constant number " + node.getText() + " in order by. If you try to use position alias when hive.orderby.position.alias is false, the position alias will be ignored.");
                    }
                }
            }
            for (int i = ((ArrayList)next.getChildren()).size() - 1; i >= 0; --i) {
                stack.push((HiveParserASTNode)((ArrayList)next.getChildren()).get(i));
            }
        }
    }

    static HiveParserPTFInvocationSpec.PartitionSpec processPartitionSpec(HiveParserASTNode node) {
        HiveParserPTFInvocationSpec.PartitionSpec pSpec = new HiveParserPTFInvocationSpec.PartitionSpec();
        int exprCnt = node.getChildCount();
        for (int i = 0; i < exprCnt; ++i) {
            HiveParserPTFInvocationSpec.PartitionExpression exprSpec = new HiveParserPTFInvocationSpec.PartitionExpression();
            exprSpec.setExpression((HiveParserASTNode)node.getChild(i));
            pSpec.addExpression(exprSpec);
        }
        return pSpec;
    }

    static HiveParserPTFInvocationSpec.OrderSpec processOrderSpec(HiveParserASTNode sortNode) {
        HiveParserPTFInvocationSpec.OrderSpec oSpec = new HiveParserPTFInvocationSpec.OrderSpec();
        int exprCnt = sortNode.getChildCount();
        for (int i = 0; i < exprCnt; ++i) {
            HiveParserPTFInvocationSpec.OrderExpression exprSpec = new HiveParserPTFInvocationSpec.OrderExpression();
            HiveParserASTNode orderSpec = (HiveParserASTNode)sortNode.getChild(i);
            HiveParserASTNode nullOrderSpec = (HiveParserASTNode)orderSpec.getChild(0);
            exprSpec.setExpression((HiveParserASTNode)nullOrderSpec.getChild(0));
            if (orderSpec.getType() == 982) {
                exprSpec.setOrder(PTFInvocationSpec.Order.ASC);
            } else {
                exprSpec.setOrder(PTFInvocationSpec.Order.DESC);
            }
            if (nullOrderSpec.getType() == 830) {
                exprSpec.setNullOrder(HiveParserPTFInvocationSpec.NullOrder.NULLS_FIRST);
            } else {
                exprSpec.setNullOrder(HiveParserPTFInvocationSpec.NullOrder.NULLS_LAST);
            }
            oSpec.addExpression(exprSpec);
        }
        return oSpec;
    }

    static HiveParserPTFInvocationSpec.PartitioningSpec processPTFPartitionSpec(HiveParserASTNode pSpecNode) {
        HiveParserPTFInvocationSpec.PartitioningSpec partitioning = new HiveParserPTFInvocationSpec.PartitioningSpec();
        HiveParserASTNode firstChild = (HiveParserASTNode)pSpecNode.getChild(0);
        int type = firstChild.getType();
        if (type == 741 || type == 705) {
            HiveParserASTNode sortNode;
            HiveParserPTFInvocationSpec.PartitionSpec pSpec = HiveParserBaseSemanticAnalyzer.processPartitionSpec(firstChild);
            partitioning.setPartSpec(pSpec);
            HiveParserASTNode hiveParserASTNode = sortNode = pSpecNode.getChildCount() > 1 ? (HiveParserASTNode)pSpecNode.getChild(1) : null;
            if (sortNode != null) {
                HiveParserPTFInvocationSpec.OrderSpec oSpec = HiveParserBaseSemanticAnalyzer.processOrderSpec(sortNode);
                partitioning.setOrderSpec(oSpec);
            }
        } else if (type == 938 || type == 855) {
            HiveParserPTFInvocationSpec.OrderSpec oSpec = HiveParserBaseSemanticAnalyzer.processOrderSpec(firstChild);
            partitioning.setOrderSpec(oSpec);
        }
        return partitioning;
    }

    static HiveParserWindowingSpec.WindowFunctionSpec processWindowFunction(HiveParserASTNode node, HiveParserASTNode wsNode) throws SemanticException {
        HiveParserWindowingSpec.WindowFunctionSpec wfSpec = new HiveParserWindowingSpec.WindowFunctionSpec();
        switch (node.getType()) {
            case 768: {
                wfSpec.setStar(true);
                break;
            }
            case 767: {
                wfSpec.setDistinct(true);
            }
        }
        wfSpec.setExpression(node);
        HiveParserASTNode nameNode = (HiveParserASTNode)node.getChild(0);
        wfSpec.setName(nameNode.getText());
        for (int i = 1; i < node.getChildCount() - 1; ++i) {
            HiveParserASTNode child = (HiveParserASTNode)node.getChild(i);
            wfSpec.addArg(child);
        }
        if (wsNode != null) {
            HiveParserWindowingSpec.WindowSpec ws = HiveParserBaseSemanticAnalyzer.processWindowSpec(wsNode);
            wfSpec.setWindowSpec(ws);
        }
        return wfSpec;
    }

    static boolean containsLeadLagUDF(HiveParserASTNode expressionTree) {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 766) {
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(0).getType() == 24) {
                String functionName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                if ("lag".equals(functionName = functionName.toLowerCase()) || "lead".equals(functionName)) {
                    return true;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            if (!HiveParserBaseSemanticAnalyzer.containsLeadLagUDF((HiveParserASTNode)expressionTree.getChild(i))) continue;
            return true;
        }
        return false;
    }

    static void processQueryWindowClause(HiveParserWindowingSpec spec, HiveParserASTNode node) throws SemanticException {
        HiveParserASTNode nameNode = (HiveParserASTNode)node.getChild(0);
        HiveParserASTNode wsNode = (HiveParserASTNode)node.getChild(1);
        if (spec.getWindowSpecs() != null && spec.getWindowSpecs().containsKey(nameNode.getText())) {
            throw new SemanticException(HiveParserUtils.generateErrorMessage(nameNode, "Duplicate definition of window " + nameNode.getText() + " is not allowed"));
        }
        HiveParserWindowingSpec.WindowSpec ws = HiveParserBaseSemanticAnalyzer.processWindowSpec(wsNode);
        spec.addWindowSpec(nameNode.getText(), ws);
    }

    static HiveParserWindowingSpec.WindowSpec processWindowSpec(HiveParserASTNode node) throws SemanticException {
        boolean hasSrcId = false;
        boolean hasPartSpec = false;
        boolean hasWF = false;
        int srcIdIdx = -1;
        int partIdx = -1;
        int wfIdx = -1;
        block5: for (int i = 0; i < node.getChildCount(); ++i) {
            int type = node.getChild(i).getType();
            switch (type) {
                case 24: {
                    hasSrcId = true;
                    srcIdIdx = i;
                    continue block5;
                }
                case 857: {
                    hasPartSpec = true;
                    partIdx = i;
                    continue block5;
                }
                case 1020: 
                case 1022: {
                    hasWF = true;
                    wfIdx = i;
                }
            }
        }
        HiveParserWindowingSpec.WindowSpec ws = new HiveParserWindowingSpec.WindowSpec();
        if (hasSrcId) {
            HiveParserASTNode nameNode = (HiveParserASTNode)node.getChild(srcIdIdx);
            ws.setSourceId(nameNode.getText());
        }
        if (hasPartSpec) {
            HiveParserASTNode partNode = (HiveParserASTNode)node.getChild(partIdx);
            HiveParserPTFInvocationSpec.PartitioningSpec partitioning = HiveParserBaseSemanticAnalyzer.processPTFPartitionSpec(partNode);
            ws.setPartitioning(partitioning);
        }
        if (hasWF) {
            HiveParserASTNode wfNode = (HiveParserASTNode)node.getChild(wfIdx);
            HiveParserWindowingSpec.WindowFrameSpec wfSpec = HiveParserBaseSemanticAnalyzer.processWindowFrame(wfNode);
            ws.setWindowFrame(wfSpec);
        }
        return ws;
    }

    static HiveParserWindowingSpec.WindowFrameSpec processWindowFrame(HiveParserASTNode node) throws SemanticException {
        int type = node.getType();
        HiveParserWindowingSpec.BoundarySpec start = null;
        HiveParserWindowingSpec.BoundarySpec end = null;
        start = HiveParserBaseSemanticAnalyzer.processBoundary((HiveParserASTNode)node.getChild(0));
        if (node.getChildCount() > 1) {
            end = HiveParserBaseSemanticAnalyzer.processBoundary((HiveParserASTNode)node.getChild(1));
        }
        return new HiveParserWindowingSpec.WindowFrameSpec(type == 1022 ? HiveParserWindowingSpec.WindowType.RANGE : HiveParserWindowingSpec.WindowType.ROWS, start, end);
    }

    static HiveParserWindowingSpec.BoundarySpec processBoundary(HiveParserASTNode node) throws SemanticException {
        HiveParserWindowingSpec.BoundarySpec bs = new HiveParserWindowingSpec.BoundarySpec();
        int type = node.getType();
        boolean hasAmt = true;
        switch (type) {
            case 217: {
                bs.setDirection(WindowingSpec.Direction.PRECEDING);
                break;
            }
            case 125: {
                bs.setDirection(WindowingSpec.Direction.FOLLOWING);
                break;
            }
            case 73: {
                bs.setDirection(WindowingSpec.Direction.CURRENT);
                hasAmt = false;
            }
        }
        if (hasAmt) {
            HiveParserASTNode amtNode = (HiveParserASTNode)node.getChild(0);
            if (amtNode.getType() == 298) {
                bs.setAmt(Integer.MAX_VALUE);
            } else {
                int amt = Integer.parseInt(amtNode.getText());
                if (amt <= 0) {
                    throw new SemanticException("Window Frame Boundary Amount must be a positive integer, provided amount is: " + amt);
                }
                bs.setAmt(amt);
            }
        }
        return bs;
    }

    public static void removeOBInSubQuery(HiveParserQBExpr qbExpr) {
        if (qbExpr == null) {
            return;
        }
        if (qbExpr.getOpcode() == HiveParserQBExpr.Opcode.NULLOP) {
            HiveParserQB subQB = qbExpr.getQB();
            HiveParserQBParseInfo parseInfo = subQB.getParseInfo();
            String alias = qbExpr.getAlias();
            HashMap<String, HiveParserASTNode> destToOrderBy = parseInfo.getDestToOrderBy();
            HashMap<String, HiveParserASTNode> destToSortBy = parseInfo.getDestToSortBy();
            String warning = "WARNING: Order/Sort by without limit in sub query or view [" + alias + "] is removed, as it's pointless and bad for performance.";
            if (destToOrderBy != null) {
                for (String dest : destToOrderBy.keySet()) {
                    if (parseInfo.getDestLimit(dest) != null) continue;
                    HiveParserUtils.removeASTChild((HiveParserASTNode)destToOrderBy.get(dest));
                    destToOrderBy.remove(dest);
                    LOG.warn(warning);
                }
            }
            if (destToSortBy != null) {
                for (String dest : destToSortBy.keySet()) {
                    if (parseInfo.getDestLimit(dest) != null) continue;
                    HiveParserUtils.removeASTChild((HiveParserASTNode)destToSortBy.get(dest));
                    destToSortBy.remove(dest);
                    LOG.warn(warning);
                }
            }
            for (String subAlias : subQB.getSubqAliases()) {
                HiveParserBaseSemanticAnalyzer.removeOBInSubQuery(subQB.getSubqForAlias(subAlias));
            }
        } else {
            HiveParserBaseSemanticAnalyzer.removeOBInSubQuery(qbExpr.getQBExpr1());
            HiveParserBaseSemanticAnalyzer.removeOBInSubQuery(qbExpr.getQBExpr2());
        }
    }

    public static TableType obtainTableType(Table tabMetaData) {
        if (tabMetaData.getStorageHandler() != null && tabMetaData.getStorageHandler().toString().equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
            return TableType.DRUID;
        }
        return TableType.NATIVE;
    }

    public static ImmutableBitSet convert(int value, int length) {
        BitSet bits = new BitSet();
        for (int index = length - 1; index >= 0; --index) {
            if (value % 2 != 0) {
                bits.set(index);
            }
            value >>>= 1;
        }
        bits.flip(0, length);
        return ImmutableBitSet.fromBitSet((BitSet)bits);
    }

    public static Map<String, Integer> buildHiveColNameToInputPosMap(List<ExprNodeDesc> colList, HiveParserRowResolver inputRR) {
        HashMap<Integer, ExprNodeDesc> hashCodeToColumnDesc = new HashMap<Integer, ExprNodeDesc>();
        HiveParserExprNodeDescUtils.getExprNodeColumnDesc(colList, hashCodeToColumnDesc);
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        for (ExprNodeDesc exprDesc : hashCodeToColumnDesc.values()) {
            String exprNodecolName = ((ExprNodeColumnDesc)exprDesc).getColumn();
            res.put(exprNodecolName, inputRR.getPosition(exprNodecolName));
        }
        return res;
    }

    public static Map<String, Integer> buildHiveToCalciteColumnMap(HiveParserRowResolver rr) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (ColumnInfo ci : rr.getRowSchema().getSignature()) {
            map.put(ci.getInternalName(), rr.getPosition(ci.getInternalName()));
        }
        return Collections.unmodifiableMap(map);
    }

    public static org.apache.calcite.util.Pair<List<CorrelationId>, ImmutableBitSet> getCorrelationUse(RexCall call) {
        ArrayList<CorrelationId> correlIDs = new ArrayList<CorrelationId>();
        ImmutableBitSet.Builder requiredColumns = ImmutableBitSet.builder();
        call.accept((RexVisitor)new HiveParserUtils.CorrelationCollector(correlIDs, requiredColumns));
        if (correlIDs.isEmpty()) {
            return null;
        }
        return org.apache.calcite.util.Pair.of(correlIDs, (Object)requiredColumns.build());
    }

    public static boolean topLevelConjunctCheck(HiveParserASTNode searchCond, ObjectPair<Boolean, Integer> subqInfo) {
        if (searchCond.getType() == 202) {
            subqInfo.setFirst(Boolean.TRUE);
            if (subqInfo.getSecond() > 1) {
                return false;
            }
        }
        if (searchCond.getType() == 946) {
            subqInfo.setSecond(subqInfo.getSecond() + 1);
            return subqInfo.getSecond() <= 1 || subqInfo.getFirst() == false;
        }
        for (int i = 0; i < searchCond.getChildCount(); ++i) {
            boolean validSubQuery = HiveParserBaseSemanticAnalyzer.topLevelConjunctCheck((HiveParserASTNode)searchCond.getChild(i), subqInfo);
            if (validSubQuery) continue;
            return false;
        }
        return true;
    }

    public static void addToGBExpr(HiveParserRowResolver groupByOutputRowResolver, HiveParserRowResolver groupByInputRowResolver, HiveParserASTNode grpbyExpr, ExprNodeDesc grpbyExprNDesc, List<ExprNodeDesc> gbExprNDescLst, List<String> outputColumnNames) {
        int i = gbExprNDescLst.size();
        String field = HiveParserBaseSemanticAnalyzer.getColumnInternalName(i);
        outputColumnNames.add(field);
        gbExprNDescLst.add(grpbyExprNDesc);
        ColumnInfo outColInfo = new ColumnInfo(field, grpbyExprNDesc.getTypeInfo(), null, false);
        groupByOutputRowResolver.putExpression(grpbyExpr, outColInfo);
        HiveParserBaseSemanticAnalyzer.addAlternateGByKeyMappings(grpbyExpr, outColInfo, groupByInputRowResolver, groupByOutputRowResolver);
    }

    public static int getWindowSpecIndx(HiveParserASTNode wndAST) {
        int wi = wndAST.getChildCount() - 1;
        if (wi <= 0 || wndAST.getChild(wi).getType() != 1021) {
            wi = -1;
        }
        return wi;
    }

    private static void addAlternateGByKeyMappings(HiveParserASTNode gByExpr, ColumnInfo colInfo, HiveParserRowResolver inputRR, HiveParserRowResolver outputRR) {
        if (gByExpr.getType() == 16 && gByExpr.getChild(0).getType() == 977) {
            String tabAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getChild(0).getText().toLowerCase());
            String colAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(1).getText().toLowerCase());
            outputRR.put(tabAlias, colAlias, colInfo);
        } else if (gByExpr.getType() == 977) {
            String colAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getText().toLowerCase());
            String tabAlias = null;
            try {
                ColumnInfo pColInfo = inputRR.get(tabAlias, colAlias);
                tabAlias = pColInfo == null ? null : pColInfo.getTabAlias();
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            outputRR.put(tabAlias, colAlias, colInfo);
        }
    }

    public static void validateNoHavingReferenceToAlias(HiveParserQB qb, HiveParserASTNode havingExpr, HiveParserRowResolver inputRR, HiveParserSemanticAnalyzer semanticAnalyzer) throws SemanticException {
        HiveParserQBParseInfo qbPI = qb.getParseInfo();
        Map<HiveParserASTNode, String> exprToAlias = qbPI.getAllExprToColumnAlias();
        for (Map.Entry<HiveParserASTNode, String> exprAndAlias : exprToAlias.entrySet()) {
            HiveParserASTNode expr = exprAndAlias.getKey();
            final String alias = exprAndAlias.getValue();
            if (inputRR.getExpression(expr) != null) {
                inputRR.put("", alias, inputRR.getExpression(expr));
            }
            final HashSet aliasReferences = new HashSet();
            TreeVisitorAction action = new TreeVisitorAction(){

                @Override
                public Object pre(Object t) {
                    Object c;
                    if (HiveASTParseDriver.ADAPTOR.getType(t) == 977 && (c = HiveASTParseDriver.ADAPTOR.getChild(t, 0)) != null && HiveASTParseDriver.ADAPTOR.getType(c) == 24 && HiveASTParseDriver.ADAPTOR.getText(c).equals(alias)) {
                        aliasReferences.add(t);
                    }
                    return t;
                }

                @Override
                public Object post(Object t) {
                    return t;
                }
            };
            new TreeVisitor(HiveASTParseDriver.ADAPTOR).visit(havingExpr, action);
            if (aliasReferences.size() <= 0) continue;
            String havingClause = semanticAnalyzer.ctx.getTokenRewriteStream().toString(havingExpr.getTokenStartIndex(), havingExpr.getTokenStopIndex());
            String msg = String.format("Encountered Select alias '%s' in having clause '%s' This is non standard behavior.", alias, havingClause);
            LOG.warn(msg);
        }
    }

    public static List<RexNode> getPartitionKeys(HiveParserPTFInvocationSpec.PartitionSpec partitionSpec, HiveParserRexNodeConverter converter, HiveParserRowResolver inputRR, HiveParserTypeCheckCtx typeCheckCtx, HiveParserSemanticAnalyzer semanticAnalyzer) throws SemanticException {
        ArrayList<RexNode> res = new ArrayList<RexNode>();
        if (partitionSpec != null) {
            ArrayList<HiveParserPTFInvocationSpec.PartitionExpression> expressions = partitionSpec.getExpressions();
            for (HiveParserPTFInvocationSpec.PartitionExpression expression : expressions) {
                typeCheckCtx.setAllowStatefulFunctions(true);
                ExprNodeDesc exp = semanticAnalyzer.genExprNodeDesc(expression.getExpression(), inputRR, typeCheckCtx);
                res.add(converter.convert(exp));
            }
        }
        return res;
    }

    public static List<RexFieldCollation> getOrderKeys(HiveParserPTFInvocationSpec.OrderSpec orderSpec, HiveParserRexNodeConverter converter, HiveParserRowResolver inputRR, HiveParserTypeCheckCtx typeCheckCtx, HiveParserSemanticAnalyzer semanticAnalyzer) throws SemanticException {
        ArrayList<RexFieldCollation> orderKeys = new ArrayList<RexFieldCollation>();
        if (orderSpec != null) {
            ArrayList<HiveParserPTFInvocationSpec.OrderExpression> oExprs = orderSpec.getExpressions();
            for (HiveParserPTFInvocationSpec.OrderExpression oExpr : oExprs) {
                typeCheckCtx.setAllowStatefulFunctions(true);
                ExprNodeDesc exp = semanticAnalyzer.genExprNodeDesc(oExpr.getExpression(), inputRR, typeCheckCtx);
                RexNode ordExp = converter.convert(exp);
                HashSet<SqlKind> flags = new HashSet<SqlKind>();
                if (oExpr.getOrder() == PTFInvocationSpec.Order.DESC) {
                    flags.add(SqlKind.DESCENDING);
                }
                if (oExpr.getNullOrder() == HiveParserPTFInvocationSpec.NullOrder.NULLS_FIRST) {
                    flags.add(SqlKind.NULLS_FIRST);
                } else if (oExpr.getNullOrder() == HiveParserPTFInvocationSpec.NullOrder.NULLS_LAST) {
                    flags.add(SqlKind.NULLS_LAST);
                } else {
                    throw new SemanticException("Unexpected null ordering option: " + (Object)((Object)oExpr.getNullOrder()));
                }
                orderKeys.add(new RexFieldCollation(ordExp, flags));
            }
        }
        return orderKeys;
    }

    public static AggInfo getHiveAggInfo(HiveParserASTNode aggAst, int aggFnLstArgIndx, HiveParserRowResolver inputRR, HiveParserWindowingSpec.WindowFunctionSpec winFuncSpec, HiveParserSemanticAnalyzer semanticAnalyzer, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
        ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
        for (int i = 1; i <= aggFnLstArgIndx; ++i) {
            HiveParserASTNode paraExpr = (HiveParserASTNode)aggAst.getChild(i);
            ExprNodeDesc paraExprNode = semanticAnalyzer.genExprNodeDesc(paraExpr, inputRR);
            aggParameters.add(paraExprNode);
        }
        boolean isDistinct = aggAst.getType() == 767;
        TypeInfo udafRetType = null;
        String aggName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(aggAst.getChild(0).getText());
        boolean isAllColumns = false;
        if (FunctionRegistry.isRankingFunction(aggName)) {
            udafRetType = aggName.equalsIgnoreCase("percent_rank") ? TypeInfoFactory.doubleTypeInfo : TypeInfoFactory.intTypeInfo;
            for (HiveParserPTFInvocationSpec.OrderExpression orderExpr : winFuncSpec.windowSpec.getOrder().getExpressions()) {
                aggParameters.add(semanticAnalyzer.genExprNodeDesc(orderExpr.getExpression(), inputRR));
            }
        } else {
            try {
                GenericUDAFEvaluator genericUDAFEvaluator;
                isAllColumns = aggAst.getType() == 768;
                GenericUDAFEvaluator.Mode amode = HiveParserUtils.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                if (aggName.toLowerCase().equals("lead") || aggName.toLowerCase().equals("lag")) {
                    ArrayList<ObjectInspector> originalParameterTypeInfos = HiveParserUtils.getWritableObjectInspector(aggParameters);
                    genericUDAFEvaluator = FunctionRegistry.getGenericWindowingEvaluator(aggName, originalParameterTypeInfos, isDistinct, isAllColumns);
                    GenericUDAFInfo udaf = HiveParserUtils.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                    udafRetType = ((ListTypeInfo)udaf.returnType).getListElementTypeInfo();
                } else {
                    genericUDAFEvaluator = HiveParserUtils.getGenericUDAFEvaluator(aggName, aggParameters, aggAst, isDistinct, isAllColumns, frameworkConfig.getOperatorTable());
                    GenericUDAFInfo udaf = HiveParserUtils.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                    udafRetType = HiveParserUtils.pivotResult(aggName) ? ((ListTypeInfo)udaf.returnType).getListElementTypeInfo() : udaf.returnType;
                }
            }
            catch (Exception e) {
                LOG.debug("CBO: Couldn't Obtain UDAF evaluators for " + aggName + ", trying to translate to GenericUDF");
            }
            if (udafRetType == null) {
                HiveParserTypeCheckCtx tcCtx = new HiveParserTypeCheckCtx(inputRR, frameworkConfig, cluster);
                tcCtx.setAllowStatefulFunctions(true);
                tcCtx.setAllowDistinctFunctions(false);
                ExprNodeDesc exp = semanticAnalyzer.genExprNodeDesc((HiveParserASTNode)aggAst.getChild(0), inputRR, tcCtx);
                udafRetType = exp.getTypeInfo();
            }
        }
        AggInfo aInfo = new AggInfo(aggParameters, udafRetType, aggName, isDistinct, isAllColumns, null);
        return aInfo;
    }

    public static RelNode genValues(String tabAlias, Table tmpTable, HiveParserRowResolver rowResolver, RelOptCluster cluster, List<List<String>> values) {
        List tmpTableTypes = tmpTable.getCols().stream().map(f -> TypeInfoUtils.getTypeInfoFromTypeString(f.getType())).collect(Collectors.toList());
        RexBuilder rexBuilder = cluster.getRexBuilder();
        List calciteTargetTypes = tmpTableTypes.stream().map(ti -> HiveParserTypeConverter.convert((PrimitiveTypeInfo)ti, rexBuilder.getTypeFactory())).collect(Collectors.toList());
        List calciteFieldNames = IntStream.range(0, calciteTargetTypes.size()).mapToObj(SqlUtil::deriveAliasFromOrdinal).collect(Collectors.toList());
        ArrayList<RelDataType> calciteRowTypes = new ArrayList<RelDataType>();
        ArrayList<List<RexLiteral>> rows = new ArrayList<List<RexLiteral>>();
        for (List<String> value : values) {
            Preconditions.checkArgument((value.size() == tmpTableTypes.size() ? 1 : 0) != 0, (Object)String.format("Values table col length (%d) and data length (%d) mismatch", tmpTableTypes.size(), value.size()));
            ArrayList<RexLiteral> row = new ArrayList<RexLiteral>();
            block7: for (int i = 0; i < tmpTableTypes.size(); ++i) {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)tmpTableTypes.get(i);
                RelDataType calciteType = (RelDataType)calciteTargetTypes.get(i);
                String col = value.get(i);
                if (col == null) {
                    row.add(rexBuilder.makeNullLiteral(calciteType));
                    continue;
                }
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        row.add(rexBuilder.makeExactLiteral(new BigDecimal(col), calciteType));
                        continue block7;
                    }
                    case DECIMAL: {
                        BigDecimal bigDec = new BigDecimal(col);
                        row.add(SqlTypeUtil.isValidDecimalValue((BigDecimal)bigDec, (RelDataType)calciteType) ? rexBuilder.makeExactLiteral(bigDec, calciteType) : rexBuilder.makeNullLiteral(calciteType));
                        continue block7;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        row.add(rexBuilder.makeApproxLiteral(new BigDecimal(col), calciteType));
                        continue block7;
                    }
                    case BOOLEAN: {
                        row.add(rexBuilder.makeLiteral(Boolean.parseBoolean(col)));
                        continue block7;
                    }
                    default: {
                        row.add(rexBuilder.makeCharLiteral(HiveParserUtils.asUnicodeString(col)));
                    }
                }
            }
            calciteRowTypes.add(rexBuilder.getTypeFactory().createStructType(row.stream().map(RexLiteral::getType).collect(Collectors.toList()), calciteFieldNames));
            rows.add(row);
        }
        RelDataType calciteRowType = rexBuilder.getTypeFactory().leastRestrictive(calciteRowTypes);
        for (int i = 0; i < calciteFieldNames.size(); ++i) {
            ColumnInfo colInfo = new ColumnInfo((String)calciteFieldNames.get(i), HiveParserTypeConverter.convert(((RelDataTypeField)calciteRowType.getFieldList().get(i)).getType()), tabAlias, false);
            rowResolver.put(tabAlias, (String)calciteFieldNames.get(i), colInfo);
        }
        return HiveParserUtils.genValuesRelNode(cluster, rexBuilder.getTypeFactory().createStructType(calciteRowType.getFieldList()), rows);
    }

    private static void validatePartColumnType(Table tbl, Map<String, String> partSpec, HiveParserASTNode astNode, HiveConf conf, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TYPE_CHECK_ON_INSERT)) {
            return;
        }
        HashMap<HiveParserASTNode, ExprNodeDesc> astExprNodeMap = new HashMap<HiveParserASTNode, ExprNodeDesc>();
        if (!HiveParserBaseSemanticAnalyzer.getPartExprNodeDesc(astNode, conf, astExprNodeMap, frameworkConfig, cluster)) {
            LOG.warn("Dynamic partitioning is used; only validating " + astExprNodeMap.size() + " columns");
        }
        if (astExprNodeMap.isEmpty()) {
            return;
        }
        List<FieldSchema> parts = tbl.getPartitionKeys();
        HashMap<String, String> partCols = new HashMap<String, String>(parts.size());
        for (FieldSchema fieldSchema : parts) {
            partCols.put(fieldSchema.getName(), fieldSchema.getType().toLowerCase());
        }
        for (Map.Entry entry : astExprNodeMap.entrySet()) {
            Object value;
            String astKeyName = ((HiveParserASTNode)entry.getKey()).toString().toLowerCase();
            if (((HiveParserASTNode)entry.getKey()).getType() == 24) {
                astKeyName = HiveParserBaseSemanticAnalyzer.stripIdentifierQuotes(astKeyName);
            }
            String colType = (String)partCols.get(astKeyName);
            ObjectInspector inputOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(((ExprNodeDesc)entry.getValue()).getTypeInfo());
            TypeInfo expectedType = TypeInfoUtils.getTypeInfoFromTypeString(colType);
            ObjectInspector outputOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(expectedType);
            Object convertedValue = value = ((ExprNodeConstantDesc)entry.getValue()).getValue();
            if (!inputOI.getTypeName().equals(outputOI.getTypeName())) {
                convertedValue = ObjectInspectorConverters.getConverter(inputOI, outputOI).convert(value);
                if (convertedValue == null) {
                    throw new SemanticException(ErrorMsg.PARTITION_SPEC_TYPE_MISMATCH, astKeyName, inputOI.getTypeName(), outputOI.getTypeName());
                }
                if (!convertedValue.toString().equals(value.toString())) {
                    LOG.warn("Partition " + astKeyName + " expects type " + outputOI.getTypeName() + " but input value is in type " + inputOI.getTypeName() + ". Convert " + value.toString() + " to " + convertedValue.toString());
                }
            }
            if (!convertedValue.toString().equals(partSpec.get(astKeyName))) {
                LOG.warn("Partition Spec " + astKeyName + "=" + partSpec.get(astKeyName) + " has been changed to " + astKeyName + "=" + convertedValue.toString());
            }
            partSpec.put(astKeyName, convertedValue.toString());
        }
    }

    private static void errorPartSpec(Map<String, String> partSpec, List<FieldSchema> parts) throws SemanticException {
        StringBuilder sb = new StringBuilder("Partition columns in the table schema are: (");
        for (FieldSchema fs : parts) {
            sb.append(fs.getName()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("), while the partitions specified in the query are: (");
        Iterator<String> itrPsKeys = partSpec.keySet().iterator();
        while (itrPsKeys.hasNext()) {
            sb.append(itrPsKeys.next()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(").");
        throw new SemanticException(ErrorMsg.PARTSPEC_DIFFER_FROM_SCHEMA.getMsg(sb.toString()));
    }

    public static class NotNullConstraint
    implements Serializable {
        private static final long serialVersionUID = 7642343368203203950L;
        private final String dbName;
        private final String tblName;
        private final String colName;
        private final String constraintName;
        private final boolean enable;
        private final boolean validate;
        private final boolean rely;

        public NotNullConstraint(String dbName, String tblName, String colName, String constraintName, boolean enable, boolean validate, boolean rely) {
            this.dbName = dbName;
            this.tblName = tblName;
            this.colName = colName;
            this.constraintName = constraintName;
            this.enable = enable;
            this.validate = validate;
            this.rely = rely;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTblName() {
            return this.tblName;
        }

        public String getColName() {
            return this.colName;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public boolean isValidate() {
            return this.validate;
        }

        public boolean isRely() {
            return this.rely;
        }
    }

    public static class PrimaryKey
    implements Serializable {
        private static final long serialVersionUID = 3036210046732750293L;
        private final String dbName;
        private final String tblName;
        private final String pk;
        private final String constraintName;
        private final boolean enable;
        private final boolean validate;
        private final boolean rely;

        public PrimaryKey(String dbName, String tblName, String pk, String constraintName, boolean enable, boolean validate, boolean rely) {
            this.dbName = dbName;
            this.tblName = tblName;
            this.pk = pk;
            this.constraintName = constraintName;
            this.enable = enable;
            this.validate = validate;
            this.rely = rely;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTblName() {
            return this.tblName;
        }

        public String getPk() {
            return this.pk;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public boolean isValidate() {
            return this.validate;
        }

        public boolean isRely() {
            return this.rely;
        }
    }

    public static class HiveParserRowFormatParams {
        String fieldDelim = null;
        String fieldEscape = null;
        String collItemDelim = null;
        String mapKeyDelim = null;
        String lineDelim = null;
        String nullFormat = null;

        public String getFieldDelim() {
            return this.fieldDelim;
        }

        public String getFieldEscape() {
            return this.fieldEscape;
        }

        public String getCollItemDelim() {
            return this.collItemDelim;
        }

        public String getMapKeyDelim() {
            return this.mapKeyDelim;
        }

        public String getLineDelim() {
            return this.lineDelim;
        }

        public String getNullFormat() {
            return this.nullFormat;
        }

        public void analyzeRowFormat(HiveParserASTNode child) throws SemanticException {
            child = (HiveParserASTNode)child.getChild(0);
            int numChildRowFormat = child.getChildCount();
            block7: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                HiveParserASTNode rowChild = (HiveParserASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 970: {
                        this.fieldDelim = HiveParserBaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (rowChild.getChildCount() < 2) continue block7;
                        this.fieldEscape = HiveParserBaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        continue block7;
                    }
                    case 969: {
                        this.collItemDelim = HiveParserBaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    case 972: {
                        this.mapKeyDelim = HiveParserBaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    case 971: {
                        this.lineDelim = HiveParserBaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (this.lineDelim.equals("\n") || this.lineDelim.equals("10")) continue block7;
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(rowChild, ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg()));
                    }
                    case 973: {
                        this.nullFormat = HiveParserBaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)("Unkown Token: " + rowChild));
                    }
                }
            }
        }
    }

    public static class AggInfo {
        private final List<ExprNodeDesc> aggParams;
        private final TypeInfo returnType;
        private final String udfName;
        private final boolean distinct;
        private final boolean isAllColumns;
        private final String alias;

        public AggInfo(List<ExprNodeDesc> aggParams, TypeInfo returnType, String udfName, boolean isDistinct, boolean isAllColumns, String alias) {
            this.aggParams = aggParams;
            this.returnType = returnType;
            this.udfName = udfName;
            this.distinct = isDistinct;
            this.isAllColumns = isAllColumns;
            this.alias = alias;
        }

        public List<ExprNodeDesc> getAggParams() {
            return this.aggParams;
        }

        public TypeInfo getReturnType() {
            return this.returnType;
        }

        public String getUdfName() {
            return this.udfName;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public boolean isAllColumns() {
            return this.isAllColumns;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public static enum TableType {
        DRUID,
        NATIVE;

    }

    public static class GenericUDAFInfo {
        public ArrayList<ExprNodeDesc> convertedParameters;
        public GenericUDAFEvaluator genericUDAFEvaluator;
        public TypeInfo returnType;
    }

    public static class Phase1Ctx {
        String dest;
        int nextNum;
    }

    static class CTEClause {
        String alias;
        HiveParserASTNode cteNode;
        boolean materialize;
        int reference;
        HiveParserQBExpr qbExpr;
        List<CTEClause> parents = new ArrayList<CTEClause>();

        CTEClause(String alias, HiveParserASTNode cteNode) {
            this.alias = alias;
            this.cteNode = cteNode;
        }

        public String toString() {
            return this.alias == null ? "<root>" : this.alias;
        }
    }

    private static class PKInfo {
        public String colName;
        public String constraintName;
        public boolean rely;

        public PKInfo(String colName) {
            this.colName = colName;
        }

        public PKInfo(String colName, String constraintName, boolean rely) {
            this.colName = colName;
            this.constraintName = constraintName;
            this.rely = rely;
        }
    }

    public static class AnalyzeRewriteContext {
        private String tableName;
        private List<String> colName;
        private List<String> colType;
        private boolean tblLvl;

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public List<String> getColName() {
            return this.colName;
        }

        public void setColName(List<String> colName) {
            this.colName = colName;
        }

        public boolean isTblLvl() {
            return this.tblLvl;
        }

        public void setTblLvl(boolean isTblLvl) {
            this.tblLvl = isTblLvl;
        }

        public List<String> getColType() {
            return this.colType;
        }

        public void setColType(List<String> colType) {
            this.colType = colType;
        }
    }

    public static class TableSpec {
        public String tableName;
        public Table tableHandle;
        public Map<String, String> partSpec;
        public Partition partHandle;
        public int numDynParts;
        public List<Partition> partitions;
        public SpecType specType;

        public TableSpec(Hive db, HiveConf conf, HiveParserASTNode ast, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
            this(db, conf, ast, true, false, frameworkConfig, cluster);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public TableSpec(Hive db, HiveConf conf, HiveParserASTNode ast, boolean allowDynamicPartitionsSpec, boolean allowPartialPartitionsSpec, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
            assert (ast.getToken().getType() == 952 || ast.getToken().getType() == 978 || ast.getToken().getType() == 985 || ast.getToken().getType() == 716 || ast.getToken().getType() == 718);
            int childIndex = 0;
            this.numDynParts = 0;
            try {
                this.tableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
                boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
                if (testMode) {
                    this.tableName = conf.getVar(HiveConf.ConfVars.HIVETESTMODEPREFIX) + this.tableName;
                }
                if (ast.getToken().getType() != 716 && ast.getToken().getType() != 718) {
                    this.tableHandle = db.getTable(this.tableName);
                }
            }
            catch (InvalidTableException ite) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_TABLE, ast.getChild(0)), ite);
            }
            catch (HiveException e) {
                throw new SemanticException("Error while retrieving table metadata", e);
            }
            if (ast.getChildCount() == 2 && ast.getToken().getType() != 716 && ast.getToken().getType() != 718) {
                childIndex = 1;
                HiveParserASTNode partspec = (HiveParserASTNode)ast.getChild(1);
                this.partitions = new ArrayList<Partition>();
                HashMap<String, String> tmpPartSpec = new HashMap<String, String>(partspec.getChildCount());
                for (int i = 0; i < partspec.getChildCount(); ++i) {
                    HiveParserASTNode partspecVal = (HiveParserASTNode)partspec.getChild(i);
                    String val = null;
                    String colName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(partspecVal.getChild(0).getText().toLowerCase());
                    if (partspecVal.getChildCount() < 2) {
                        if (!allowDynamicPartitionsSpec) throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                        ++this.numDynParts;
                    } else {
                        val = HiveParserBaseSemanticAnalyzer.stripQuotes(partspecVal.getChild(1).getText());
                    }
                    tmpPartSpec.put(colName, val);
                }
                HiveParserBaseSemanticAnalyzer.validatePartSpec(this.tableHandle, tmpPartSpec, ast, conf, false, frameworkConfig, cluster);
                List<FieldSchema> parts = this.tableHandle.getPartitionKeys();
                this.partSpec = new LinkedHashMap<String, String>(partspec.getChildCount());
                for (FieldSchema fs : parts) {
                    String partKey = fs.getName();
                    this.partSpec.put(partKey, (String)tmpPartSpec.get(partKey));
                }
                if (this.numDynParts > 0) {
                    int numStaPart = parts.size() - this.numDynParts;
                    if (numStaPart == 0 && conf.getVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE).equalsIgnoreCase("strict")) {
                        throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_STRICT_MODE.getMsg());
                    }
                    if (this.partSpec.keySet().size() != parts.size()) {
                        HiveParserBaseSemanticAnalyzer.errorPartSpec(this.partSpec, parts);
                    }
                    Iterator<String> itrPsKeys = this.partSpec.keySet().iterator();
                    for (FieldSchema fs : parts) {
                        if (itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) continue;
                        HiveParserBaseSemanticAnalyzer.errorPartSpec(this.partSpec, parts);
                    }
                    for (FieldSchema fs : parts) {
                        if (this.partSpec.get(fs.getName().toLowerCase()) == null) {
                            if (numStaPart <= 0) break;
                            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.PARTITION_DYN_STA_ORDER, ast.getChild(childIndex)));
                        }
                        --numStaPart;
                    }
                    this.partHandle = null;
                    this.specType = SpecType.DYNAMIC_PARTITION;
                    return;
                }
                try {
                    if (allowPartialPartitionsSpec) {
                        this.partitions = db.getPartitions(this.tableHandle, this.partSpec);
                    } else {
                        this.partHandle = db.getPartition(this.tableHandle, this.partSpec, false);
                        if (this.partHandle == null) {
                            this.partHandle = new Partition(this.tableHandle, this.partSpec, null);
                        } else {
                            this.partitions.add(this.partHandle);
                        }
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_PARTITION, ast.getChild(childIndex)), e);
                }
                this.specType = SpecType.STATIC_PARTITION;
                return;
            }
            this.specType = SpecType.TABLE_ONLY;
        }

        public Map<String, String> getPartSpec() {
            return this.partSpec;
        }

        public void setPartSpec(Map<String, String> partSpec) {
            this.partSpec = partSpec;
        }

        public String toString() {
            if (this.partHandle != null) {
                return this.partHandle.toString();
            }
            return this.tableHandle.toString();
        }

        public static enum SpecType {
            TABLE_ONLY,
            STATIC_PARTITION,
            DYNAMIC_PARTITION;

        }
    }
}

