/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

public class HiveParserAuthorizationParseUtils {
    private HiveParserAuthorizationParseUtils() {
    }

    public static PrincipalDesc getPrincipalDesc(HiveParserASTNode principal) {
        PrincipalType type = HiveParserAuthorizationParseUtils.getPrincipalType(principal);
        if (type != null) {
            String text = principal.getChild(0).getText();
            String principalName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(text);
            return new PrincipalDesc(principalName, type);
        }
        return null;
    }

    private static PrincipalType getPrincipalType(HiveParserASTNode principal) {
        switch (principal.getType()) {
            case 1008: {
                return PrincipalType.USER;
            }
            case 774: {
                return PrincipalType.GROUP;
            }
            case 899: {
                return PrincipalType.ROLE;
            }
        }
        return null;
    }
}

