/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseError;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseException;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.table.planner.delegation.hive.parse.HiveASTHintParser;
import org.apache.flink.table.planner.delegation.hive.parse.HiveASTLexer;
import org.apache.flink.table.planner.delegation.hive.parse.HiveASTParser;
import org.apache.hadoop.hive.ql.parse.ASTErrorNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveASTParseDriver {
    private static final Logger LOG = LoggerFactory.getLogger(HiveASTParseDriver.class);
    public static final TreeAdaptor ADAPTOR = new CommonTreeAdaptor(){

        @Override
        public Object create(Token payload) {
            return new HiveParserASTNode(payload);
        }

        @Override
        public Object dupNode(Object t) {
            return this.create(((CommonTree)t).token);
        }

        @Override
        public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
            return new ASTErrorNode(input, start, stop, e);
        }
    };

    public HiveParserASTNode parse(String command, HiveParserContext ctx, String viewFullyQualifiedName) throws HiveASTParseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing command: " + command);
        }
        HiveLexerX lexer = new HiveLexerX(new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        if (ctx != null) {
            if (viewFullyQualifiedName == null) {
                ctx.setTokenRewriteStream(tokens);
            } else {
                ctx.addViewTokenRewriteStream(viewFullyQualifiedName, tokens);
            }
            lexer.setHiveConf(ctx.getConf());
        }
        HiveASTParser parser = new HiveASTParser(tokens);
        if (ctx != null) {
            parser.setHiveConf(ctx.getConf());
        }
        parser.setTreeAdaptor(ADAPTOR);
        HiveASTParser.statement_return r = null;
        try {
            r = parser.statement();
        }
        catch (RecognitionException e) {
            throw new HiveASTParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new HiveASTParseException(lexer.getErrors());
            }
            throw new HiveASTParseException(parser.errors);
        }
        LOG.debug("Parse Completed");
        HiveParserASTNode tree = r.getTree();
        tree.setUnknownTokenBoundaries();
        return tree;
    }

    public HiveParserASTNode parseHint(String command) throws HiveASTParseException {
        LOG.info("Parsing hint: " + command);
        HiveLexerX lexer = new HiveLexerX(new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        HiveASTHintParser parser = new HiveASTHintParser(tokens);
        parser.setTreeAdaptor(ADAPTOR);
        HiveASTHintParser.hint_return r = null;
        try {
            r = parser.hint();
        }
        catch (RecognitionException e) {
            throw new HiveASTParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new HiveASTParseException(lexer.getErrors());
            }
            throw new HiveASTParseException(parser.errors);
        }
        LOG.info("Parse Completed");
        return r.getTree();
    }

    public static class HiveLexerX
    extends HiveASTLexer {
        private final ArrayList<HiveASTParseError> errors = new ArrayList();

        public HiveLexerX(CharStream input) {
            super(input);
        }

        @Override
        public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
            this.errors.add(new HiveASTParseError(this, e, tokenNames));
        }

        @Override
        public String getErrorMessage(RecognitionException e, String[] tokenNames) {
            String msg = null;
            if (e instanceof NoViableAltException) {
                NoViableAltException nvae = (NoViableAltException)e;
                msg = "character " + this.getCharErrorDisplay(e.c) + " not supported here";
            } else {
                msg = super.getErrorMessage(e, tokenNames);
            }
            return msg;
        }

        public ArrayList<HiveASTParseError> getErrors() {
            return this.errors;
        }
    }

    public static class ANTLRNoCaseStringStream
    extends ANTLRStringStream {
        public ANTLRNoCaseStringStream(String input) {
            super(input);
        }

        @Override
        public int LA(int i) {
            int returnChar = super.LA(i);
            if (returnChar == -1) {
                return returnChar;
            }
            if (returnChar == 0) {
                return returnChar;
            }
            return Character.toUpperCase((char)returnChar);
        }
    }
}

