/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module.hive;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.factories.HiveFunctionDefinitionFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.hive.udf.generic.GenericUDFLegacyGroupingID;
import org.apache.flink.table.module.hive.udf.generic.HiveGenericUDFGrouping;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;

public class HiveModule
implements Module {
    @VisibleForTesting
    static final Set<String> BUILT_IN_FUNC_BLACKLIST = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("count", "cume_dist", "current_date", "current_timestamp", "dense_rank", "first_value", "lag", "last_value", "lead", "ntile", "rank", "row_number", "hop", "hop_end", "hop_proctime", "hop_rowtime", "hop_start", "percent_rank", "session", "session_end", "session_proctime", "session_rowtime", "session_start", "tumble", "tumble_end", "tumble_proctime", "tumble_rowtime", "tumble_start")));
    private final HiveFunctionDefinitionFactory factory;
    private final String hiveVersion;
    private final HiveShim hiveShim;
    private Set<String> functionNames;

    public HiveModule() {
        this(HiveShimLoader.getHiveVersion());
    }

    public HiveModule(String hiveVersion) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)hiveVersion) ? 1 : 0) != 0, (Object)"hiveVersion cannot be null");
        this.hiveVersion = hiveVersion;
        this.hiveShim = HiveShimLoader.loadHiveShim(hiveVersion);
        this.factory = new HiveFunctionDefinitionFactory(this.hiveShim);
        this.functionNames = new HashSet<String>();
    }

    public Set<String> listFunctions() {
        if (this.functionNames.isEmpty()) {
            this.functionNames = this.hiveShim.listBuiltInFunctions();
            this.functionNames.removeAll(BUILT_IN_FUNC_BLACKLIST);
            this.functionNames.add("grouping");
            this.functionNames.add("_legacy_grouping__id");
        }
        return this.functionNames;
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        if (BUILT_IN_FUNC_BLACKLIST.contains(name)) {
            return Optional.empty();
        }
        if (name.equalsIgnoreCase("grouping")) {
            return Optional.of(this.factory.createFunctionDefinitionFromHiveFunction(name, HiveGenericUDFGrouping.class.getName()));
        }
        if (name.equalsIgnoreCase("_legacy_grouping__id")) {
            return Optional.of(this.factory.createFunctionDefinitionFromHiveFunction(name, GenericUDFLegacyGroupingID.class.getName()));
        }
        Optional<FunctionInfo> info = this.hiveShim.getBuiltInFunctionInfo(name);
        return info.map(functionInfo -> this.factory.createFunctionDefinitionFromHiveFunction(name, functionInfo.getFunctionClass().getName()));
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }
}

