/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.HiveFunction;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.functions.hive.conversion.IdentityConversion;
import org.apache.flink.table.functions.hive.util.HiveFunctionUtil;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HiveGenericUDTF
extends TableFunction<Row>
implements HiveFunction {
    private static final Logger LOG = LoggerFactory.getLogger(HiveGenericUDTF.class);
    private final HiveFunctionWrapper<GenericUDTF> hiveFunctionWrapper;
    private Object[] constantArguments;
    private DataType[] argTypes;
    private transient GenericUDTF function;
    private transient StructObjectInspector returnInspector;
    private transient boolean isArgsSingleArray;
    private transient boolean allIdentityConverter;
    private transient HiveObjectConversion[] conversions;
    private HiveShim hiveShim;

    public HiveGenericUDTF(HiveFunctionWrapper<GenericUDTF> hiveFunctionWrapper, HiveShim hiveShim) {
        this.hiveFunctionWrapper = hiveFunctionWrapper;
        this.hiveShim = hiveShim;
    }

    public void open(FunctionContext context) throws Exception {
        this.function = this.hiveFunctionWrapper.createFunction();
        this.function.setCollector(input -> {
            Row row = (Row)HiveInspectors.toFlinkObject(this.returnInspector, input, this.hiveShim);
            this.collect(row);
        });
        ObjectInspector[] argumentInspectors = HiveInspectors.toInspectors(this.hiveShim, this.constantArguments, this.argTypes);
        this.returnInspector = this.function.initialize(argumentInspectors);
        this.isArgsSingleArray = HiveFunctionUtil.isSingleBoxedArray(this.argTypes);
        this.conversions = new HiveObjectConversion[argumentInspectors.length];
        for (int i = 0; i < argumentInspectors.length; ++i) {
            this.conversions[i] = HiveInspectors.getConversion(argumentInspectors[i], this.argTypes[i].getLogicalType(), this.hiveShim);
        }
        this.allIdentityConverter = Arrays.stream(this.conversions).allMatch(conv -> conv instanceof IdentityConversion);
    }

    @VisibleForTesting
    protected final void setCollector(Collector collector) {
        this.function.setCollector(collector);
    }

    public void eval(Object ... args) throws HiveException {
        if (this.isArgsSingleArray) {
            args = new Object[]{args};
        }
        Preconditions.checkArgument((args.length == this.conversions.length ? 1 : 0) != 0);
        if (!this.allIdentityConverter) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.conversions[i].toHiveObject(args[i]);
            }
        }
        this.function.process(args);
    }

    @Override
    public void setArgumentTypesAndConstants(Object[] constantArguments, DataType[] argTypes) {
        this.constantArguments = constantArguments;
        this.argTypes = argTypes;
    }

    @Override
    public DataType getHiveResultType(Object[] constantArguments, DataType[] argTypes) {
        LOG.info("Getting result type of HiveGenericUDTF with {}", (Object)this.hiveFunctionWrapper.getClassName());
        try {
            ObjectInspector[] argumentInspectors = HiveInspectors.toInspectors(this.hiveShim, constantArguments, argTypes);
            return HiveTypeUtil.toFlinkType(this.hiveFunctionWrapper.createFunction().initialize(argumentInspectors));
        }
        catch (UDFArgumentException e) {
            throw new FlinkHiveUDFException(e);
        }
    }

    public TypeInformation getResultType() {
        return TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)this.getHiveResultType(this.constantArguments, this.argTypes).getLogicalType());
    }

    public void close() throws Exception {
        this.function.close();
    }
}

