/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShimV111;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.thrift.TException;

public class HiveShimV120
extends HiveShimV111 {
    private static PrimitiveTypeInfo intervalYearMonthTypeInfo;
    private static PrimitiveTypeInfo intervalDayTimeTypeInfo;
    private static Class funcResourceClz;
    private static Method registerTemporaryUDF;
    private static boolean inited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (inited) return;
        Class<HiveShimV120> clazz = HiveShimV120.class;
        synchronized (HiveShimV120.class) {
            if (inited) return;
            try {
                Field field = TypeInfoFactory.class.getDeclaredField("intervalYearMonthTypeInfo");
                intervalYearMonthTypeInfo = (PrimitiveTypeInfo)field.get(null);
                field = TypeInfoFactory.class.getDeclaredField("intervalDayTimeTypeInfo");
                intervalDayTimeTypeInfo = (PrimitiveTypeInfo)field.get(null);
                funcResourceClz = Thread.currentThread().getContextClassLoader().loadClass("org.apache.hadoop.hive.ql.exec.FunctionInfo$FunctionResource");
                registerTemporaryUDF = FunctionRegistry.class.getDeclaredMethod("registerTemporaryUDF", String.class, Class.class, Array.newInstance(funcResourceClz, 0).getClass());
                inited = true;
            }
            catch (Exception e) {
                throw new FlinkHiveException(e);
            }
            return;
        }
    }

    @Override
    public IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) {
        try {
            Method method = RetryingMetaStoreClient.class.getMethod("getProxy", HiveConf.class);
            return (IMetaStoreClient)method.invoke(null, new Object[]{hiveConf});
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to create Hive Metastore client", (Throwable)ex);
        }
    }

    @Override
    public void alterTable(IMetaStoreClient client, String databaseName, String tableName, Table table) throws InvalidOperationException, MetaException, TException {
        table.getParameters().put("DO_NOT_UPDATE_STATS", "true");
        client.alter_table(databaseName, tableName, table);
    }

    @Override
    public ColumnStatisticsData toHiveDateColStats(CatalogColumnStatisticsDataDate flinkDateColStats) {
        try {
            Class<?> dateStatsClz = Class.forName("org.apache.hadoop.hive.metastore.api.DateColumnStatsData");
            Object dateStats = dateStatsClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            dateStatsClz.getMethod("clear", new Class[0]).invoke(dateStats, new Object[0]);
            if (null != flinkDateColStats.getNdv()) {
                dateStatsClz.getMethod("setNumDVs", Long.TYPE).invoke(dateStats, flinkDateColStats.getNdv());
            }
            if (null != flinkDateColStats.getNullCount()) {
                dateStatsClz.getMethod("setNumNulls", Long.TYPE).invoke(dateStats, flinkDateColStats.getNullCount());
            }
            Class<?> hmsDateClz = Class.forName("org.apache.hadoop.hive.metastore.api.Date");
            Constructor<?> hmsDateConstructor = hmsDateClz.getConstructor(Long.TYPE);
            if (null != flinkDateColStats.getMax()) {
                Method setHigh = dateStatsClz.getDeclaredMethod("setHighValue", hmsDateClz);
                setHigh.invoke(dateStats, hmsDateConstructor.newInstance(flinkDateColStats.getMax().getDaysSinceEpoch()));
            }
            if (null != flinkDateColStats.getMin()) {
                Method setLow = dateStatsClz.getDeclaredMethod("setLowValue", hmsDateClz);
                setLow.invoke(dateStats, hmsDateConstructor.newInstance(flinkDateColStats.getMin().getDaysSinceEpoch()));
            }
            Class<ColumnStatisticsData> colStatsClz = ColumnStatisticsData.class;
            return (ColumnStatisticsData)colStatsClz.getDeclaredMethod("dateStats", dateStatsClz).invoke(null, dateStats);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to create Hive statistics for date column", (Throwable)e);
        }
    }

    @Override
    public boolean isDateStats(ColumnStatisticsData colStatsData) {
        try {
            Method method = ColumnStatisticsData.class.getDeclaredMethod("isSetDateStats", new Class[0]);
            return (Boolean)method.invoke((Object)colStatsData, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to decide whether ColumnStatisticsData is for DATE column", (Throwable)e);
        }
    }

    @Override
    public CatalogColumnStatisticsDataDate toFlinkDateColStats(ColumnStatisticsData hiveDateColStats) {
        try {
            Object dateStats = ColumnStatisticsData.class.getDeclaredMethod("getDateStats", new Class[0]).invoke((Object)hiveDateColStats, new Object[0]);
            Class<?> dateStatsClz = dateStats.getClass();
            boolean isSetNumDv = (Boolean)dateStatsClz.getMethod("isSetNumDVs", new Class[0]).invoke(dateStats, new Object[0]);
            boolean isSetNumNull = (Boolean)dateStatsClz.getMethod("isSetNumNulls", new Class[0]).invoke(dateStats, new Object[0]);
            boolean isSetHighValue = (Boolean)dateStatsClz.getMethod("isSetHighValue", new Class[0]).invoke(dateStats, new Object[0]);
            boolean isSetLowValue = (Boolean)dateStatsClz.getMethod("isSetLowValue", new Class[0]).invoke(dateStats, new Object[0]);
            Long numDV = isSetNumDv ? (Long)dateStatsClz.getMethod("getNumDVs", new Class[0]).invoke(dateStats, new Object[0]) : null;
            Long numNull = isSetNumNull ? (Long)dateStatsClz.getMethod("getNumNulls", new Class[0]).invoke(dateStats, new Object[0]) : null;
            Object hmsHighDate = dateStatsClz.getMethod("getHighValue", new Class[0]).invoke(dateStats, new Object[0]);
            Object hmsLowDate = dateStatsClz.getMethod("getLowValue", new Class[0]).invoke(dateStats, new Object[0]);
            Class<?> hmsDateClz = hmsHighDate.getClass();
            Method hmsDateDays = hmsDateClz.getMethod("getDaysSinceEpoch", new Class[0]);
            Date highDateDays = isSetHighValue ? new Date(((Long)hmsDateDays.invoke(hmsHighDate, new Object[0])).longValue()) : null;
            Date lowDateDays = isSetLowValue ? new Date(((Long)hmsDateDays.invoke(hmsLowDate, new Object[0])).longValue()) : null;
            return new CatalogColumnStatisticsDataDate(lowDateDays, highDateDays, numDV, numNull);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to create Flink statistics for date column", (Throwable)e);
        }
    }

    @Override
    public Set<String> listBuiltInFunctions() {
        try {
            Method method = FunctionRegistry.class.getMethod("getFunctionNames", new Class[0]);
            Set names = (Set)method.invoke(null, new Object[0]);
            return names.stream().filter(n -> this.getBuiltInFunctionInfo((String)n).isPresent()).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to invoke FunctionRegistry.getFunctionNames()", (Throwable)ex);
        }
    }

    @Override
    boolean isBuiltInFunctionInfo(FunctionInfo info) {
        try {
            Method method = FunctionInfo.class.getMethod("isBuiltIn", null);
            return (Boolean)method.invoke((Object)info, new Object[0]);
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to invoke FunctionInfo.isBuiltIn()", (Throwable)ex);
        }
    }

    @Override
    public PrimitiveTypeInfo getIntervalYearMonthTypeInfo() {
        HiveShimV120.init();
        return intervalYearMonthTypeInfo;
    }

    @Override
    public PrimitiveTypeInfo getIntervalDayTimeTypeInfo() {
        HiveShimV120.init();
        return intervalDayTimeTypeInfo;
    }

    @Override
    public boolean isIntervalYearMonthType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        return this.getIntervalYearMonthTypeInfo().getPrimitiveCategory() == primitiveCategory;
    }

    @Override
    public boolean isIntervalDayTimeType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        return this.getIntervalDayTimeTypeInfo().getPrimitiveCategory() == primitiveCategory;
    }

    @Override
    public void registerTemporaryFunction(String funcName, Class funcClass) {
        HiveShimV120.init();
        try {
            registerTemporaryUDF.invoke(null, funcName, funcClass, Array.newInstance(funcResourceClz, 0));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to register temp function", e);
        }
    }

    static {
        inited = false;
    }
}

