/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.internal.column.columnindex;

import java.util.PrimitiveIterator;
import org.apache.flink.hive.shaded.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.flink.hive.shaded.parquet.internal.column.columnindex.IndexIterator;

public enum BoundaryOrder {
    UNORDERED{

        @Override
        PrimitiveIterator.OfInt eq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            return IndexIterator.filterTranslate(comparator.arrayLength(), arrayIndex -> comparator.compareValueToMin(arrayIndex) >= 0 && comparator.compareValueToMax(arrayIndex) <= 0, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt gt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            return IndexIterator.filterTranslate(comparator.arrayLength(), arrayIndex -> comparator.compareValueToMax(arrayIndex) < 0, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt gtEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            return IndexIterator.filterTranslate(comparator.arrayLength(), arrayIndex -> comparator.compareValueToMax(arrayIndex) <= 0, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt lt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            return IndexIterator.filterTranslate(comparator.arrayLength(), arrayIndex -> comparator.compareValueToMin(arrayIndex) > 0, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt ltEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            return IndexIterator.filterTranslate(comparator.arrayLength(), arrayIndex -> comparator.compareValueToMin(arrayIndex) >= 0, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt notEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            return IndexIterator.filterTranslate(comparator.arrayLength(), arrayIndex -> comparator.compareValueToMin(arrayIndex) != 0 || comparator.compareValueToMax(arrayIndex) != 0, comparator::translate);
        }
    }
    ,
    ASCENDING{

        @Override
        PrimitiveIterator.OfInt eq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            Bounds bounds = this.findBounds(comparator);
            if (bounds == null) {
                return IndexIterator.EMPTY;
            }
            return IndexIterator.rangeTranslate(bounds.lower, bounds.upper, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt gt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = 0;
            int right = length;
            do {
                int i;
                if (comparator.compareValueToMax(i = BoundaryOrder.floorMid(left, right)) >= 0) {
                    left = i + 1;
                    continue;
                }
                right = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(right, length - 1, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt gtEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = 0;
            int right = length;
            do {
                int i;
                if (comparator.compareValueToMax(i = BoundaryOrder.floorMid(left, right)) > 0) {
                    left = i + 1;
                    continue;
                }
                right = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(right, length - 1, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt lt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = -1;
            int right = length - 1;
            do {
                int i;
                if (comparator.compareValueToMin(i = BoundaryOrder.ceilingMid(left, right)) <= 0) {
                    right = i - 1;
                    continue;
                }
                left = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(0, left, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt ltEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = -1;
            int right = length - 1;
            do {
                int i;
                if (comparator.compareValueToMin(i = BoundaryOrder.ceilingMid(left, right)) < 0) {
                    right = i - 1;
                    continue;
                }
                left = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(0, left, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt notEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            Bounds bounds = this.findBounds(comparator);
            int length = comparator.arrayLength();
            if (bounds == null) {
                return IndexIterator.all(comparator);
            }
            return IndexIterator.filterTranslate(length, i -> i < bounds.lower || i > bounds.upper || comparator.compareValueToMin(i) != 0 || comparator.compareValueToMax(i) != 0, comparator::translate);
        }

        private Bounds findBounds(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int i;
            int length = comparator.arrayLength();
            int lowerLeft = 0;
            int upperLeft = 0;
            int lowerRight = length - 1;
            int upperRight = length - 1;
            do {
                if (lowerLeft > lowerRight) {
                    return null;
                }
                i = BoundaryOrder.floorMid(lowerLeft, lowerRight);
                if (comparator.compareValueToMin(i) < 0) {
                    lowerRight = upperRight = i - 1;
                    continue;
                }
                if (comparator.compareValueToMax(i) > 0) {
                    lowerLeft = upperLeft = i + 1;
                    continue;
                }
                lowerRight = upperLeft = i;
            } while (lowerLeft != lowerRight);
            do {
                if (upperLeft > upperRight) {
                    return null;
                }
                i = BoundaryOrder.ceilingMid(upperLeft, upperRight);
                if (comparator.compareValueToMin(i) < 0) {
                    upperRight = i - 1;
                    continue;
                }
                upperLeft = comparator.compareValueToMax(i) > 0 ? i + 1 : i;
            } while (upperLeft != upperRight);
            return new Bounds(lowerLeft, upperRight);
        }
    }
    ,
    DESCENDING{

        @Override
        PrimitiveIterator.OfInt eq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            Bounds bounds = this.findBounds(comparator);
            if (bounds == null) {
                return IndexIterator.EMPTY;
            }
            return IndexIterator.rangeTranslate(bounds.lower, bounds.upper, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt gt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = -1;
            int right = length - 1;
            do {
                int i;
                if (comparator.compareValueToMax(i = BoundaryOrder.ceilingMid(left, right)) >= 0) {
                    right = i - 1;
                    continue;
                }
                left = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(0, left, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt gtEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = -1;
            int right = length - 1;
            do {
                int i;
                if (comparator.compareValueToMax(i = BoundaryOrder.ceilingMid(left, right)) > 0) {
                    right = i - 1;
                    continue;
                }
                left = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(0, left, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt lt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = 0;
            int right = length;
            do {
                int i;
                if (comparator.compareValueToMin(i = BoundaryOrder.floorMid(left, right)) <= 0) {
                    left = i + 1;
                    continue;
                }
                right = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(right, length - 1, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt ltEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int length = comparator.arrayLength();
            if (length == 0) {
                return IndexIterator.EMPTY;
            }
            int left = 0;
            int right = length;
            do {
                int i;
                if (comparator.compareValueToMin(i = BoundaryOrder.floorMid(left, right)) < 0) {
                    left = i + 1;
                    continue;
                }
                right = i;
            } while (left < right);
            return IndexIterator.rangeTranslate(right, length - 1, comparator::translate);
        }

        @Override
        PrimitiveIterator.OfInt notEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            Bounds bounds = this.findBounds(comparator);
            int length = comparator.arrayLength();
            if (bounds == null) {
                return IndexIterator.all(comparator);
            }
            return IndexIterator.filterTranslate(length, i -> i < bounds.lower || i > bounds.upper || comparator.compareValueToMin(i) != 0 || comparator.compareValueToMax(i) != 0, comparator::translate);
        }

        private Bounds findBounds(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            int i;
            int length = comparator.arrayLength();
            int lowerLeft = 0;
            int upperLeft = 0;
            int lowerRight = length - 1;
            int upperRight = length - 1;
            do {
                if (lowerLeft > lowerRight) {
                    return null;
                }
                i = BoundaryOrder.floorMid(lowerLeft, lowerRight);
                if (comparator.compareValueToMax(i) > 0) {
                    lowerRight = upperRight = i - 1;
                    continue;
                }
                if (comparator.compareValueToMin(i) < 0) {
                    lowerLeft = upperLeft = i + 1;
                    continue;
                }
                lowerRight = upperLeft = i;
            } while (lowerLeft != lowerRight);
            do {
                if (upperLeft > upperRight) {
                    return null;
                }
                i = BoundaryOrder.ceilingMid(upperLeft, upperRight);
                if (comparator.compareValueToMax(i) > 0) {
                    upperRight = i - 1;
                    continue;
                }
                upperLeft = comparator.compareValueToMin(i) < 0 ? i + 1 : i;
            } while (upperLeft != upperRight);
            return new Bounds(lowerLeft, upperRight);
        }
    };


    private static int floorMid(int left, int right) {
        return left + (right - left) / 2;
    }

    private static int ceilingMid(int left, int right) {
        return left + (right - left + 1) / 2;
    }

    abstract PrimitiveIterator.OfInt eq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator var1);

    abstract PrimitiveIterator.OfInt gt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator var1);

    abstract PrimitiveIterator.OfInt gtEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator var1);

    abstract PrimitiveIterator.OfInt lt(ColumnIndexBuilder.ColumnIndexBase.ValueComparator var1);

    abstract PrimitiveIterator.OfInt ltEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator var1);

    abstract PrimitiveIterator.OfInt notEq(ColumnIndexBuilder.ColumnIndexBase.ValueComparator var1);

    private static class Bounds {
        final int lower;
        final int upper;

        Bounds(int lower, int upper) {
            assert (lower <= upper);
            this.lower = lower;
            this.upper = upper;
        }
    }
}

