/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connectors.hive.CachedSerializedValue;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.read.HiveBulkFormatAdapter;
import org.apache.flink.connectors.hive.read.HiveSourceSplit;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.filesystem.stream.compact.CompactBulkReader;
import org.apache.flink.table.filesystem.stream.compact.CompactContext;
import org.apache.flink.table.filesystem.stream.compact.CompactReader;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.mapred.JobConf;

public class HiveCompactReaderFactory
implements CompactReader.Factory<RowData> {
    private static final long serialVersionUID = 1L;
    private final CachedSerializedValue<StorageDescriptor> sd;
    private final Properties properties;
    private final JobConfWrapper jobConfWrapper;
    private final List<String> partitionKeys;
    private final String[] fieldNames;
    private final DataType[] fieldTypes;
    private final String hiveVersion;
    private final HiveShim shim;
    private final RowType producedRowType;
    private final boolean useMapRedReader;

    public HiveCompactReaderFactory(StorageDescriptor sd, Properties properties, JobConf jobConf, CatalogTable catalogTable, String hiveVersion, RowType producedRowType, boolean useMapRedReader) {
        try {
            this.sd = new CachedSerializedValue<StorageDescriptor>(sd);
        }
        catch (IOException e) {
            throw new FlinkHiveException("Failed to serialize StorageDescriptor", e);
        }
        this.properties = properties;
        this.jobConfWrapper = new JobConfWrapper(jobConf);
        this.partitionKeys = catalogTable.getPartitionKeys();
        this.fieldNames = catalogTable.getSchema().getFieldNames();
        this.fieldTypes = catalogTable.getSchema().getFieldDataTypes();
        this.hiveVersion = hiveVersion;
        this.shim = HiveShimLoader.loadHiveShim(hiveVersion);
        this.producedRowType = producedRowType;
        this.useMapRedReader = useMapRedReader;
    }

    public CompactReader<RowData> create(CompactContext context) throws IOException {
        HiveSourceSplit split = this.createSplit(context.getPath(), context.getFileSystem());
        HiveBulkFormatAdapter format = new HiveBulkFormatAdapter(this.jobConfWrapper, this.partitionKeys, this.fieldNames, this.fieldTypes, this.hiveVersion, this.producedRowType, this.useMapRedReader);
        BulkFormat.Reader<RowData> reader = format.createReader(context.getConfig(), split);
        return new CompactBulkReader(reader);
    }

    private HiveSourceSplit createSplit(Path path, FileSystem fs) throws IOException {
        long len = fs.getFileStatus(path).getLen();
        return new HiveSourceSplit("id", path, 0L, len, new String[0], null, this.createPartition(path));
    }

    private HiveTablePartition createPartition(Path path) {
        LinkedHashMap partitionSpec = PartitionPathUtils.extractPartitionSpecFromPath((Path)path);
        try {
            return new HiveTablePartition(this.sd.deserializeValue(), partitionSpec, this.properties);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FlinkHiveException("Failed to deserialize StorageDescriptor", e);
        }
    }
}

