/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.connector.file.src.PendingSplitsCheckpointSerializer;
import org.apache.flink.connectors.hive.ContinuousHivePendingSplitsCheckpoint;
import org.apache.flink.connectors.hive.read.HiveSourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class ContinuousHivePendingSplitsCheckpointSerializer
implements SimpleVersionedSerializer<PendingSplitsCheckpoint<HiveSourceSplit>> {
    private static final int VERSION = 1;
    private final PendingSplitsCheckpointSerializer<HiveSourceSplit> superSerDe;
    private final ListSerializer<String> partitionSerDe = new ListSerializer((TypeSerializer)StringSerializer.INSTANCE);
    private final ReadOffsetSerDe readOffsetSerDe = ReadOffsetSerDeImpl.access$000();

    public ContinuousHivePendingSplitsCheckpointSerializer(SimpleVersionedSerializer<HiveSourceSplit> splitSerDe) {
        this.superSerDe = new PendingSplitsCheckpointSerializer(splitSerDe);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(PendingSplitsCheckpoint<HiveSourceSplit> checkpoint) throws IOException {
        Preconditions.checkArgument((checkpoint.getClass() == ContinuousHivePendingSplitsCheckpoint.class ? 1 : 0) != 0, (String)"Only supports %s", (Object[])new Object[]{ContinuousHivePendingSplitsCheckpoint.class.getName()});
        ContinuousHivePendingSplitsCheckpoint hiveCheckpoint = (ContinuousHivePendingSplitsCheckpoint)checkpoint;
        PendingSplitsCheckpoint superCP = PendingSplitsCheckpoint.fromCollectionSnapshot((Collection)hiveCheckpoint.getSplits(), (Collection)hiveCheckpoint.getAlreadyProcessedPaths());
        byte[] superBytes = this.superSerDe.serialize(superCP);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputViewStreamWrapper outputWrapper = new DataOutputViewStreamWrapper((OutputStream)byteArrayOutputStream);){
            outputWrapper.writeInt(superBytes.length);
            outputWrapper.write(superBytes);
            this.readOffsetSerDe.serialize(hiveCheckpoint.getCurrentReadOffset(), (OutputStream)outputWrapper);
            outputWrapper.writeInt(hiveCheckpoint.getSeenPartitionsSinceOffset().size());
            for (List<String> partition : hiveCheckpoint.getSeenPartitionsSinceOffset()) {
                this.partitionSerDe.serialize(partition, (DataOutputView)outputWrapper);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public PendingSplitsCheckpoint<HiveSourceSplit> deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            try (DataInputViewStreamWrapper inputWrapper = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(serialized));){
                PendingSplitsCheckpoint<HiveSourceSplit> pendingSplitsCheckpoint = this.deserializeV1(inputWrapper);
                return pendingSplitsCheckpoint;
            }
        }
        throw new IOException("Unknown version: " + version);
    }

    private PendingSplitsCheckpoint<HiveSourceSplit> deserializeV1(DataInputViewStreamWrapper inputWrapper) throws IOException {
        byte[] superBytes = new byte[inputWrapper.readInt()];
        inputWrapper.readFully(superBytes);
        PendingSplitsCheckpoint superCP = this.superSerDe.deserialize(this.superSerDe.getVersion(), superBytes);
        try {
            Comparable<?> currentReadOffset = this.readOffsetSerDe.deserialize((InputStream)inputWrapper);
            int numParts = inputWrapper.readInt();
            ArrayList<List<String>> parts = new ArrayList<List<String>>(numParts);
            for (int i = 0; i < numParts; ++i) {
                parts.add(this.partitionSerDe.deserialize((DataInputView)inputWrapper));
            }
            return new ContinuousHivePendingSplitsCheckpoint(superCP.getSplits(), currentReadOffset, parts);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to deserialize " + this.getClass().getName(), e);
        }
    }

    static interface ReadOffsetSerDe {
        public void serialize(Comparable<?> var1, OutputStream var2) throws IOException;

        public Comparable<?> deserialize(InputStream var1) throws IOException, ClassNotFoundException;
    }

    private static class ReadOffsetSerDeImpl
    implements ReadOffsetSerDe {
        private static final ReadOffsetSerDeImpl INSTANCE = new ReadOffsetSerDeImpl();

        private ReadOffsetSerDeImpl() {
        }

        @Override
        public void serialize(Comparable<?> offset, OutputStream outputStream) throws IOException {
            InstantiationUtil.serializeObject((OutputStream)outputStream, offset);
        }

        @Override
        public Comparable<?> deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
            return (Comparable)InstantiationUtil.deserializeObject((InputStream)inputStream, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }

        static /* synthetic */ ReadOffsetSerDeImpl access$000() {
            return INSTANCE;
        }
    }
}

