/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport;

import java.io.IOException;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponse;

public interface TransportResponseHandler<T extends TransportResponse>
extends Writeable.Reader<T> {
    public void handleResponse(T var1);

    public void handleException(TransportException var1);

    public String executor();

    default public <Q extends TransportResponse> TransportResponseHandler<Q> wrap(final Function<Q, T> converter, final Writeable.Reader<Q> reader) {
        final TransportResponseHandler self = this;
        return new TransportResponseHandler<Q>(){

            @Override
            public void handleResponse(Q response) {
                self.handleResponse((TransportResponse)converter.apply(response));
            }

            @Override
            public void handleException(TransportException exp) {
                self.handleException(exp);
            }

            @Override
            public String executor() {
                return self.executor();
            }

            @Override
            public Q read(StreamInput in) throws IOException {
                return (TransportResponse)reader.read(in);
            }
        };
    }
}

