/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchShardTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ObjectMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.ParsedQuery;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.similarity.SimilarityService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.RescoreDocIds;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchExtBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.collapse.CollapseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.DfsSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.StoredFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ContextIndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ScrollContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchContextId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.Profilers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query.QuerySearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.rescore.RescoreContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.SortAndFormats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.SuggestionSearchContext;

public abstract class SearchContext
implements Releasable {
    public static final int DEFAULT_TERMINATE_AFTER = 0;
    public static final int TRACK_TOTAL_HITS_ACCURATE = Integer.MAX_VALUE;
    public static final int TRACK_TOTAL_HITS_DISABLED = -1;
    public static final int DEFAULT_TRACK_TOTAL_HITS_UP_TO = 10000;
    private final List<Releasable> releasables = new CopyOnWriteArrayList<Releasable>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InnerHitsContext innerHitsContext;

    protected SearchContext() {
    }

    public abstract void setTask(SearchShardTask var1);

    public abstract SearchShardTask getTask();

    public abstract boolean isCancelled();

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                Releasables.close(this.releasables);
            }
            finally {
                this.doClose();
            }
        }
    }

    protected abstract void doClose();

    public abstract void preProcess(boolean var1);

    public abstract Query buildFilteredQuery(Query var1);

    public abstract ShardSearchContextId id();

    public abstract String source();

    public abstract ShardSearchRequest request();

    public abstract SearchType searchType();

    public abstract SearchShardTarget shardTarget();

    public abstract int numberOfShards();

    public abstract float queryBoost();

    public abstract ScrollContext scrollContext();

    public abstract SearchContextAggregations aggregations();

    public abstract SearchContext aggregations(SearchContextAggregations var1);

    public abstract void addSearchExt(SearchExtBuilder var1);

    public abstract SearchExtBuilder getSearchExt(String var1);

    public abstract SearchHighlightContext highlight();

    public abstract void highlight(SearchHighlightContext var1);

    public InnerHitsContext innerHits() {
        if (this.innerHitsContext == null) {
            this.innerHitsContext = new InnerHitsContext();
        }
        return this.innerHitsContext;
    }

    public abstract SuggestionSearchContext suggest();

    public abstract void suggest(SuggestionSearchContext var1);

    public abstract List<RescoreContext> rescore();

    public abstract void addRescore(RescoreContext var1);

    public final RescoreDocIds rescoreDocIds() {
        List<RescoreContext> rescore = this.rescore();
        if (rescore == null) {
            return RescoreDocIds.EMPTY;
        }
        HashMap<Integer, Set<Integer>> rescoreDocIds = null;
        for (int i = 0; i < rescore.size(); ++i) {
            Set<Integer> docIds = rescore.get(i).getRescoredDocs();
            if (docIds == null || docIds.isEmpty()) continue;
            if (rescoreDocIds == null) {
                rescoreDocIds = new HashMap<Integer, Set<Integer>>();
            }
            rescoreDocIds.put(i, docIds);
        }
        return rescoreDocIds == null ? RescoreDocIds.EMPTY : new RescoreDocIds(rescoreDocIds);
    }

    public final void assignRescoreDocIds(RescoreDocIds rescoreDocIds) {
        List<RescoreContext> rescore = this.rescore();
        if (rescore != null) {
            for (int i = 0; i < rescore.size(); ++i) {
                Set<Integer> docIds = rescoreDocIds.getId(i);
                if (docIds == null) continue;
                rescore.get(i).setRescoredDocs(docIds);
            }
        }
    }

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean sourceRequested();

    public abstract boolean hasFetchSourceContext();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract FetchDocValuesContext docValuesContext();

    public abstract SearchContext docValuesContext(FetchDocValuesContext var1);

    public abstract FetchFieldsContext fetchFieldsContext();

    public abstract SearchContext fetchFieldsContext(FetchFieldsContext var1);

    public abstract ContextIndexSearcher searcher();

    public abstract IndexShard indexShard();

    public abstract MapperService mapperService();

    public abstract SimilarityService similarityService();

    public abstract BigArrays bigArrays();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract TimeValue timeout();

    public abstract void timeout(TimeValue var1);

    public abstract int terminateAfter();

    public abstract void terminateAfter(int var1);

    public abstract boolean lowLevelCancellation();

    public abstract SearchContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract SearchContext sort(SortAndFormats var1);

    public abstract SortAndFormats sort();

    public abstract SearchContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchContext trackTotalHitsUpTo(int var1);

    public abstract int trackTotalHitsUpTo();

    public abstract SearchContext searchAfter(FieldDoc var1);

    public abstract FieldDoc searchAfter();

    public abstract SearchContext collapse(CollapseContext var1);

    public abstract CollapseContext collapse();

    public abstract SearchContext parsedPostFilter(ParsedQuery var1);

    public abstract ParsedQuery parsedPostFilter();

    public abstract Query aliasFilter();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract Query query();

    public abstract int from();

    public abstract SearchContext from(int var1);

    public abstract int size();

    public abstract SearchContext size(int var1);

    public abstract boolean hasStoredFields();

    public abstract boolean hasStoredFieldsContext();

    public abstract boolean storedFieldsRequested();

    public abstract StoredFieldsContext storedFieldsContext();

    public abstract SearchContext storedFieldsContext(StoredFieldsContext var1);

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    @Nullable
    public abstract List<String> groupStats();

    public abstract void groupStats(List<String> var1);

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract boolean seqNoAndPrimaryTerm();

    public abstract void seqNoAndPrimaryTerm(boolean var1);

    public abstract int[] docIdsToLoad();

    public abstract int docIdsToLoadFrom();

    public abstract int docIdsToLoadSize();

    public abstract SearchContext docIdsToLoad(int[] var1, int var2, int var3);

    public abstract DfsSearchResult dfsResult();

    public abstract QuerySearchResult queryResult();

    public abstract FetchPhase fetchPhase();

    public abstract FetchSearchResult fetchResult();

    public abstract Profilers getProfilers();

    public void addReleasable(Releasable releasable) {
        this.releasables.add(releasable);
    }

    public final boolean hasOnlySuggest() {
        return this.request().source() != null && this.request().source().isSuggestOnly();
    }

    public abstract MappedFieldType fieldType(String var1);

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract long getRelativeTimeInMillis();

    public abstract Map<Class<?>, Collector> queryCollectors();

    public abstract QueryShardContext getQueryShardContext();

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.shardTarget());
        if (this.searchType() != SearchType.DEFAULT) {
            result.append("searchType=[").append((Object)this.searchType()).append("]");
        }
        if (this.scrollContext() != null) {
            if (this.scrollContext().scroll != null) {
                result.append("scroll=[").append(this.scrollContext().scroll.keepAlive()).append("]");
            } else {
                result.append("scroll=[null]");
            }
        }
        result.append(" query=[").append(this.query()).append("]");
        return result.toString();
    }

    public abstract ReaderContext readerContext();
}

