/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.highlight.QueryScorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.highlight.WeightedSpanTermExtractor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.search.ESToParentBlockJoinQuery;

public final class CustomQueryScorer
extends QueryScorer {
    public CustomQueryScorer(Query query, IndexReader reader, String field, String defaultField) {
        super(query, reader, field, defaultField);
    }

    public CustomQueryScorer(Query query, IndexReader reader, String field) {
        super(query, reader, field);
    }

    public CustomQueryScorer(Query query, String field, String defaultField) {
        super(query, field, defaultField);
    }

    public CustomQueryScorer(Query query, String field) {
        super(query, field);
    }

    public CustomQueryScorer(Query query) {
        super(query);
    }

    public CustomQueryScorer(WeightedSpanTerm[] weightedTerms) {
        super(weightedTerms);
    }

    @Override
    protected WeightedSpanTermExtractor newTermExtractor(String defaultField) {
        return defaultField == null ? new CustomWeightedSpanTermExtractor() : new CustomWeightedSpanTermExtractor(defaultField);
    }

    private static class CustomWeightedSpanTermExtractor
    extends WeightedSpanTermExtractor {
        private static final String PARENT_CHILD_QUERY_NAME = "HasChildQueryBuilder$LateParsingQuery";

        CustomWeightedSpanTermExtractor() {
        }

        CustomWeightedSpanTermExtractor(String defaultField) {
            super(defaultField);
        }

        @Override
        protected void extractUnknownQuery(Query query, Map<String, WeightedSpanTerm> terms) throws IOException {
            if (terms.isEmpty()) {
                this.extractWeightedTerms(terms, query, 1.0f);
            }
        }

        @Override
        protected void extract(Query query, float boost, Map<String, WeightedSpanTerm> terms) throws IOException {
            if (CustomWeightedSpanTermExtractor.isChildOrParentQuery(query.getClass())) {
                return;
            }
            if (query instanceof FunctionScoreQuery) {
                super.extract(((FunctionScoreQuery)query).getSubQuery(), boost, terms);
            } else if (query instanceof ESToParentBlockJoinQuery) {
                super.extract(((ESToParentBlockJoinQuery)query).getChildQuery(), boost, terms);
            } else {
                super.extract(query, boost, terms);
            }
        }

        private static boolean isChildOrParentQuery(Class<?> clazz) {
            return clazz.getName().endsWith(PARENT_CHILD_QUERY_NAME);
        }
    }
}

