/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScorerSupplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ContextIndexSearcher;

public class FetchScorePhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) throws IOException {
        if (!context.fetchScores()) {
            return null;
        }
        ContextIndexSearcher searcher = context.searcher();
        final Weight weight = ((IndexSearcher)searcher).createWeight(((IndexSearcher)searcher).rewrite(context.query()), ScoreMode.COMPLETE, 1.0f);
        return new FetchSubPhaseProcessor(){
            Scorer scorer;

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                ScorerSupplier scorerSupplier = weight.scorerSupplier(readerContext);
                if (scorerSupplier == null) {
                    throw new IllegalStateException("Can't compute score on document as it doesn't match the query");
                }
                this.scorer = scorerSupplier.get(1L);
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                if (this.scorer == null || this.scorer.iterator().advance(hitContext.docId()) != hitContext.docId()) {
                    throw new IllegalStateException("Can't compute score on document " + hitContext + " as it doesn't match the query");
                }
                hitContext.hit().score(this.scorer.score());
            }
        };
    }
}

