/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.TopHitsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.StoredFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SubSearchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.SortAndFormats;

class TopHitsAggregatorFactory
extends AggregatorFactory {
    private final int from;
    private final int size;
    private final boolean explain;
    private final boolean version;
    private final boolean seqNoAndPrimaryTerm;
    private final boolean trackScores;
    private final Optional<SortAndFormats> sort;
    private final HighlightBuilder highlightBuilder;
    private final StoredFieldsContext storedFieldsContext;
    private final List<FieldAndFormat> docValueFields;
    private final List<FieldAndFormat> fetchFields;
    private final List<ScriptFieldsContext.ScriptField> scriptFields;
    private final FetchSourceContext fetchSourceContext;

    TopHitsAggregatorFactory(String name, int from, int size, boolean explain, boolean version, boolean seqNoAndPrimaryTerm, boolean trackScores, Optional<SortAndFormats> sort, HighlightBuilder highlightBuilder, StoredFieldsContext storedFieldsContext, List<FieldAndFormat> docValueFields, List<FieldAndFormat> fetchFields, List<ScriptFieldsContext.ScriptField> scriptFields, FetchSourceContext fetchSourceContext, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactories, metadata);
        this.from = from;
        this.size = size;
        this.explain = explain;
        this.version = version;
        this.seqNoAndPrimaryTerm = seqNoAndPrimaryTerm;
        this.trackScores = trackScores;
        this.sort = sort;
        this.highlightBuilder = highlightBuilder;
        this.storedFieldsContext = storedFieldsContext;
        this.docValueFields = docValueFields;
        this.fetchFields = fetchFields;
        this.scriptFields = scriptFields;
        this.fetchSourceContext = fetchSourceContext;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        SubSearchContext subSearchContext = new SubSearchContext(searchContext);
        subSearchContext.parsedQuery(searchContext.parsedQuery());
        subSearchContext.explain(this.explain);
        subSearchContext.version(this.version);
        subSearchContext.seqNoAndPrimaryTerm(this.seqNoAndPrimaryTerm);
        subSearchContext.trackScores(this.trackScores);
        subSearchContext.from(this.from);
        subSearchContext.size(this.size);
        if (this.sort.isPresent()) {
            subSearchContext.sort(this.sort.get());
        }
        if (this.storedFieldsContext != null) {
            subSearchContext.storedFieldsContext(this.storedFieldsContext);
        }
        if (this.docValueFields != null) {
            FetchDocValuesContext docValuesContext = FetchDocValuesContext.create(searchContext.mapperService(), this.docValueFields);
            subSearchContext.docValuesContext(docValuesContext);
        }
        if (this.fetchFields != null) {
            FetchFieldsContext fieldsContext = new FetchFieldsContext(this.fetchFields);
            subSearchContext.fetchFieldsContext(fieldsContext);
        }
        for (ScriptFieldsContext.ScriptField field : this.scriptFields) {
            subSearchContext.scriptFields().add(field);
        }
        if (this.fetchSourceContext != null) {
            subSearchContext.fetchSourceContext(this.fetchSourceContext);
        }
        if (this.highlightBuilder != null) {
            subSearchContext.highlight(this.highlightBuilder.build(searchContext.getQueryShardContext()));
        }
        return new TopHitsAggregator(searchContext.fetchPhase(), subSearchContext, this.name, searchContext, parent, metadata);
    }
}

