/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedInts;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BitArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.ByteArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.ByteUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.IntArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLog;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.AbstractLinearCounting;

public final class HyperLogLogPlusPlus
extends AbstractHyperLogLogPlusPlus {
    private static final float MAX_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_PRECISION = 14;
    private final BitArray algorithm;
    private final HyperLogLog hll;
    private final LinearCounting lc;

    public static int precisionFromThreshold(long count) {
        long hashTableEntries = (long)Math.ceil((float)count / 0.75f);
        int precision = PackedInts.bitsRequired(hashTableEntries * 4L);
        precision = Math.max(precision, 4);
        precision = Math.min(precision, 18);
        return precision;
    }

    public static long memoryUsage(int precision) {
        return 1L << precision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HyperLogLogPlusPlus(int precision, BigArrays bigArrays, long initialBucketCount) {
        BitArray algorithm;
        LinearCounting lc;
        HyperLogLog hll;
        block3: {
            super(precision);
            hll = null;
            lc = null;
            algorithm = null;
            boolean success = false;
            try {
                hll = new HyperLogLog(bigArrays, initialBucketCount, precision);
                lc = new LinearCounting(bigArrays, initialBucketCount, precision, hll);
                algorithm = new BitArray(1L, bigArrays);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close(hll, lc, algorithm);
                }
                throw throwable;
            }
            Releasables.close(hll, lc, algorithm);
        }
        this.hll = hll;
        this.lc = lc;
        this.algorithm = algorithm;
    }

    @Override
    public long maxOrd() {
        return this.hll.maxOrd();
    }

    @Override
    public long cardinality(long bucketOrd) {
        if (!this.getAlgorithm(bucketOrd)) {
            return this.lc.cardinality(bucketOrd);
        }
        return this.hll.cardinality(bucketOrd);
    }

    @Override
    protected boolean getAlgorithm(long bucketOrd) {
        return this.algorithm.get(bucketOrd);
    }

    @Override
    protected AbstractLinearCounting.HashesIterator getLinearCounting(long bucketOrd) {
        return this.lc.values(bucketOrd);
    }

    @Override
    protected AbstractHyperLogLog.RunLenIterator getHyperLogLog(long bucketOrd) {
        return this.hll.getRunLens(bucketOrd);
    }

    @Override
    public void collect(long bucket, long hash) {
        this.hll.ensureCapacity(bucket + 1L);
        if (!this.algorithm.get(bucket)) {
            int newSize = this.lc.collect(bucket, hash);
            if (newSize > this.lc.threshold) {
                this.upgradeToHll(bucket);
            }
        } else {
            this.hll.collect(bucket, hash);
        }
    }

    @Override
    public void close() {
        Releasables.close(this.algorithm, this.hll, this.lc);
    }

    protected void addRunLen(long bucketOrd, int register, int runLen) {
        if (!this.algorithm.get(bucketOrd)) {
            this.upgradeToHll(bucketOrd);
        }
        this.hll.addRunLen(0L, register, runLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeToHll(long bucketOrd) {
        this.hll.ensureCapacity(bucketOrd + 1L);
        AbstractLinearCounting.HashesIterator hashes = this.lc.values(bucketOrd);
        IntArray values = this.lc.bigArrays.newIntArray(hashes.size());
        try {
            int i = 0;
            while (hashes.next()) {
                values.set(i++, hashes.value());
            }
            assert (i == hashes.size());
            this.hll.reset(bucketOrd);
            for (long j = 0L; j < values.size(); ++j) {
                int encoded = values.get(j);
                this.hll.collectEncoded(bucketOrd, encoded);
            }
            this.algorithm.set(bucketOrd);
        }
        finally {
            Releasables.close((Releasable)values);
        }
    }

    public void merge(long thisBucket, AbstractHyperLogLogPlusPlus other, long otherBucket) {
        if (this.precision() != other.precision()) {
            throw new IllegalArgumentException();
        }
        this.hll.ensureCapacity(thisBucket + 1L);
        if (!other.getAlgorithm(otherBucket)) {
            this.merge(thisBucket, other.getLinearCounting(otherBucket));
        } else {
            this.merge(thisBucket, other.getHyperLogLog(otherBucket));
        }
    }

    private void merge(long thisBucket, AbstractLinearCounting.HashesIterator values) {
        while (values.next()) {
            int encoded = values.value();
            if (!this.algorithm.get(thisBucket)) {
                int newSize = this.lc.addEncoded(thisBucket, encoded);
                if (newSize <= this.lc.threshold) continue;
                this.upgradeToHll(thisBucket);
                continue;
            }
            this.hll.collectEncoded(thisBucket, encoded);
        }
    }

    private void merge(long thisBucket, AbstractHyperLogLog.RunLenIterator runLens) {
        if (!this.algorithm.get(thisBucket)) {
            this.upgradeToHll(thisBucket);
        }
        for (int i = 0; i < this.hll.m; ++i) {
            runLens.next();
            this.hll.addRunLen(thisBucket, i, runLens.value());
        }
    }

    private static class HyperLogLog
    extends AbstractHyperLogLog
    implements Releasable {
        private final BigArrays bigArrays;
        private final HyperLogLogIterator iterator;
        private ByteArray runLens;

        HyperLogLog(BigArrays bigArrays, long initialBucketCount, int precision) {
            super(precision);
            this.runLens = bigArrays.newByteArray(initialBucketCount << precision);
            this.bigArrays = bigArrays;
            this.iterator = new HyperLogLogIterator(this, precision, this.m);
        }

        public long maxOrd() {
            return this.runLens.size() >>> this.precision();
        }

        @Override
        protected void addRunLen(long bucketOrd, int register, int encoded) {
            long bucketIndex = (bucketOrd << this.p) + (long)register;
            this.runLens.set(bucketIndex, (byte)Math.max(encoded, this.runLens.get(bucketIndex)));
        }

        @Override
        protected AbstractHyperLogLog.RunLenIterator getRunLens(long bucketOrd) {
            this.iterator.reset(bucketOrd);
            return this.iterator;
        }

        protected void reset(long bucketOrd) {
            this.runLens.fill(bucketOrd << this.p, (bucketOrd << this.p) + (long)this.m, (byte)0);
        }

        protected void ensureCapacity(long numBuckets) {
            this.runLens = this.bigArrays.grow(this.runLens, numBuckets << this.p);
        }

        @Override
        public void close() {
            Releasables.close((Releasable)this.runLens);
        }
    }

    private static class LinearCounting
    extends AbstractLinearCounting
    implements Releasable {
        protected final int threshold;
        private final int mask;
        private final BytesRef readSpare;
        private final ByteBuffer writeSpare;
        private final BigArrays bigArrays;
        private final LinearCountingIterator iterator;
        private final HyperLogLog hll;
        private IntArray sizes;

        LinearCounting(BigArrays bigArrays, long initialBucketCount, int p, HyperLogLog hll) {
            super(p);
            this.bigArrays = bigArrays;
            this.hll = hll;
            int capacity = (1 << p) / 4;
            this.threshold = (int)((float)capacity * 0.75f);
            this.mask = capacity - 1;
            this.sizes = bigArrays.newIntArray(initialBucketCount);
            this.readSpare = new BytesRef();
            this.writeSpare = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            this.iterator = new LinearCountingIterator(this, capacity);
        }

        @Override
        protected int addEncoded(long bucketOrd, int encoded) {
            this.sizes = this.bigArrays.grow(this.sizes, bucketOrd + 1L);
            assert (encoded != 0);
            int i = encoded & this.mask;
            while (true) {
                int v;
                if ((v = this.get(bucketOrd, i)) == 0) {
                    this.set(bucketOrd, i, encoded);
                    return this.sizes.increment(bucketOrd, 1);
                }
                if (v == encoded) {
                    return -1;
                }
                i = i + 1 & this.mask;
            }
        }

        @Override
        protected int size(long bucketOrd) {
            if (bucketOrd >= this.sizes.size()) {
                return 0;
            }
            int size = this.sizes.get(bucketOrd);
            assert (size == this.recomputedSize(bucketOrd));
            return size;
        }

        @Override
        protected AbstractLinearCounting.HashesIterator values(long bucketOrd) {
            this.iterator.reset(bucketOrd, this.size(bucketOrd));
            return this.iterator;
        }

        private long index(long bucketOrd, int index) {
            return (bucketOrd << this.p) + (long)(index << 2);
        }

        private int get(long bucketOrd, int index) {
            this.hll.runLens.get(this.index(bucketOrd, index), 4, this.readSpare);
            return ByteUtils.readIntLE(this.readSpare.bytes, this.readSpare.offset);
        }

        private void set(long bucketOrd, int index, int value) {
            this.writeSpare.putInt(0, value);
            this.hll.runLens.set(this.index(bucketOrd, index), this.writeSpare.array(), 0, 4);
        }

        private int recomputedSize(long bucketOrd) {
            if (bucketOrd >= this.hll.maxOrd()) {
                return 0;
            }
            int size = 0;
            for (int i = 0; i <= this.mask; ++i) {
                int v = this.get(bucketOrd, i);
                if (v == 0) continue;
                ++size;
            }
            return size;
        }

        @Override
        public void close() {
            Releasables.close((Releasable)this.sizes);
        }
    }

    private static class LinearCountingIterator
    implements AbstractLinearCounting.HashesIterator {
        private final LinearCounting lc;
        private final int capacity;
        private int pos;
        private int size;
        private long bucketOrd;
        private int value;

        LinearCountingIterator(LinearCounting lc, int capacity) {
            this.lc = lc;
            this.capacity = capacity;
        }

        void reset(long bucketOrd, int size) {
            this.bucketOrd = bucketOrd;
            this.size = size;
            this.pos = size == 0 ? this.capacity : 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean next() {
            if (this.pos < this.capacity) {
                while (this.pos < this.capacity) {
                    int k = this.lc.get(this.bucketOrd, this.pos);
                    if (k != 0) {
                        ++this.pos;
                        this.value = k;
                        return true;
                    }
                    ++this.pos;
                }
            }
            return false;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private static class HyperLogLogIterator
    implements AbstractHyperLogLog.RunLenIterator {
        private final HyperLogLog hll;
        private final int m;
        private final int p;
        int pos;
        long start;
        private byte value;

        HyperLogLogIterator(HyperLogLog hll, int p, int m) {
            this.hll = hll;
            this.m = m;
            this.p = p;
        }

        void reset(long bucket) {
            this.pos = 0;
            this.start = bucket << this.p;
        }

        @Override
        public boolean next() {
            if (this.pos < this.m) {
                this.value = this.hll.runLens.get(this.start + (long)this.pos);
                ++this.pos;
                return true;
            }
            return false;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }
}

