/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range.Range;

public class ParsedRange
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Range {
    private static final ObjectParser<ParsedRange, Void> PARSER = new ObjectParser(ParsedRange.class.getSimpleName(), true, ParsedRange::new);

    @Override
    public String getType() {
        return "range";
    }

    @Override
    public List<? extends Range.Bucket> getBuckets() {
        return this.buckets;
    }

    protected static void declareParsedRangeFields(ObjectParser<? extends ParsedRange, Void> objectParser, CheckedFunction<XContentParser, ParsedBucket, IOException> bucketParser, CheckedFunction<XContentParser, ParsedBucket, IOException> keyedBucketParser) {
        ParsedRange.declareMultiBucketAggregationFields(objectParser, bucketParser::apply, keyedBucketParser::apply);
    }

    public static ParsedRange fromXContent(XContentParser parser, String name) throws IOException {
        ParsedRange aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedRange.declareParsedRangeFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Range.Bucket {
        protected String key;
        protected double from = Double.NEGATIVE_INFINITY;
        protected String fromAsString;
        protected double to = Double.POSITIVE_INFINITY;
        protected String toAsString;

        @Override
        public String getKey() {
            return this.getKeyAsString();
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            return this.key;
        }

        @Override
        public Object getFrom() {
            return this.from;
        }

        @Override
        public String getFromAsString() {
            if (this.fromAsString != null) {
                return this.fromAsString;
            }
            return ParsedBucket.doubleAsString(this.from);
        }

        @Override
        public Object getTo() {
            return this.to;
        }

        @Override
        public String getToAsString() {
            if (this.toAsString != null) {
                return this.toAsString;
            }
            return ParsedBucket.doubleAsString(this.to);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.isKeyed()) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            }
            if (!Double.isInfinite(this.from)) {
                builder.field(Aggregation.CommonFields.FROM.getPreferredName(), this.from);
                if (this.fromAsString != null) {
                    builder.field(Aggregation.CommonFields.FROM_AS_STRING.getPreferredName(), this.fromAsString);
                }
            }
            if (!Double.isInfinite(this.to)) {
                builder.field(Aggregation.CommonFields.TO.getPreferredName(), this.to);
                if (this.toAsString != null) {
                    builder.field(Aggregation.CommonFields.TO_AS_STRING.getPreferredName(), this.toAsString);
                }
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        private static String doubleAsString(double d) {
            return Double.isInfinite(d) ? null : Double.toString(d);
        }

        protected static <B extends ParsedBucket> B parseRangeBucketXContent(XContentParser parser, Supplier<B> bucketSupplier, boolean keyed) throws IOException {
            ParsedBucket bucket = (ParsedBucket)bucketSupplier.get();
            bucket.setKeyed(keyed);
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (keyed) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                bucket.key = currentFieldName;
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
            }
            ArrayList aggregations = new ArrayList();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setKeyAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        bucket.key = parser.text();
                        continue;
                    }
                    if (Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) {
                        bucket.setDocCount(parser.longValue());
                        continue;
                    }
                    if (Aggregation.CommonFields.FROM.getPreferredName().equals(currentFieldName)) {
                        bucket.from = parser.doubleValue();
                        continue;
                    }
                    if (Aggregation.CommonFields.FROM_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.fromAsString = parser.text();
                        continue;
                    }
                    if (Aggregation.CommonFields.TO.getPreferredName().equals(currentFieldName)) {
                        bucket.to = parser.doubleValue();
                        continue;
                    }
                    if (!Aggregation.CommonFields.TO_AS_STRING.getPreferredName().equals(currentFieldName)) continue;
                    bucket.toAsString = parser.text();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return (B)bucket;
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseRangeBucketXContent(parser, ParsedBucket::new, keyed);
        }
    }
}

