/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;

public abstract class RecoveryTransportRequest
extends TransportRequest {
    private final long requestSeqNo;

    RecoveryTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.requestSeqNo = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readLong() : -2L;
    }

    RecoveryTransportRequest(long requestSeqNo) {
        this.requestSeqNo = requestSeqNo;
    }

    public long requestSeqNo() {
        return this.requestSeqNo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeLong(this.requestSeqNo);
        }
    }
}

