/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.function.BiFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.functionscore.DecayFunctionBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.MultiValueMode;

public final class DecayFunctionParser<DFB extends DecayFunctionBuilder<DFB>>
implements ScoreFunctionParser<DFB> {
    public static final ParseField MULTI_VALUE_MODE = new ParseField("multi_value_mode", new String[0]);
    private final BiFunction<String, BytesReference, DFB> createFromBytes;

    public DecayFunctionParser(BiFunction<String, BytesReference, DFB> createFromBytes) {
        this.createFromBytes = createFromBytes;
    }

    @Override
    public DFB fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        MultiValueMode multiValueMode = DecayFunctionBuilder.DEFAULT_MULTI_VALUE_MODE;
        String fieldName = null;
        BytesReference functionBytes = null;
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.copyCurrentStructure(parser);
                functionBytes = BytesReference.bytes(builder);
                continue;
            }
            if (MULTI_VALUE_MODE.match(currentFieldName, parser.getDeprecationHandler())) {
                multiValueMode = MultiValueMode.fromString(parser.text());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "malformed score function score parameters.", new Object[0]);
        }
        if (fieldName == null || functionBytes == null) {
            throw new ParsingException(parser.getTokenLocation(), "malformed score function score parameters.", new Object[0]);
        }
        DecayFunctionBuilder functionBuilder = (DecayFunctionBuilder)this.createFromBytes.apply(fieldName, functionBytes);
        functionBuilder.setMultiValueMode(multiValueMode);
        return (DFB)functionBuilder;
    }
}

