/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanFirstQueryBuilder
extends AbstractQueryBuilder<SpanFirstQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_first";
    private static final ParseField MATCH_FIELD = new ParseField("match", new String[0]);
    private static final ParseField END_FIELD = new ParseField("end", new String[0]);
    private final SpanQueryBuilder matchBuilder;
    private final int end;

    public SpanFirstQueryBuilder(SpanQueryBuilder matchBuilder, int end) {
        if (matchBuilder == null) {
            throw new IllegalArgumentException("inner span query cannot be null");
        }
        if (end < 0) {
            throw new IllegalArgumentException("parameter [end] needs to be positive.");
        }
        this.matchBuilder = matchBuilder;
        this.end = end;
    }

    public SpanFirstQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.matchBuilder = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.end = in.readInt();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.matchBuilder);
        out.writeInt(this.end);
    }

    public SpanQueryBuilder innerQuery() {
        return this.matchBuilder;
    }

    public int end() {
        return this.end;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(MATCH_FIELD.getPreferredName());
        this.matchBuilder.toXContent(builder, params);
        builder.field(END_FIELD.getPreferredName(), this.end);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static SpanFirstQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        SpanQueryBuilder match = null;
        Integer end = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    QueryBuilder query = SpanFirstQueryBuilder.parseInnerQueryBuilder(parser);
                    if (!(query instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "span_first [match] must be of type span query", new Object[0]);
                    }
                    match = (SpanQueryBuilder)query;
                    SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(NAME, currentFieldName, parser, match);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_first] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (END_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                end = parser.intValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_first] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (match == null) {
            throw new ParsingException(parser.getTokenLocation(), "span_first must have [match] span query clause", new Object[0]);
        }
        if (end == null) {
            throw new ParsingException(parser.getTokenLocation(), "span_first must have [end] set for it", new Object[0]);
        }
        SpanFirstQueryBuilder queryBuilder = new SpanFirstQueryBuilder(match, end);
        ((SpanFirstQueryBuilder)queryBuilder.boost(boost)).queryName(queryName);
        return queryBuilder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerSpanQuery = this.matchBuilder.toQuery(context);
        assert (innerSpanQuery instanceof SpanQuery);
        return new SpanFirstQuery((SpanQuery)innerSpanQuery, this.end);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.matchBuilder, this.end);
    }

    @Override
    protected boolean doEquals(SpanFirstQueryBuilder other) {
        return Objects.equals(this.matchBuilder, other.matchBuilder) && Objects.equals(this.end, other.end);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

