/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableFieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.IndexAnalyzers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.StringFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextParams;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.similarity.SimilarityProvider;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SearchLookup;

public final class KeywordFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers()));
    private final boolean indexed;
    private final boolean hasDocValues;
    private final String nullValue;
    private final boolean eagerGlobalOrdinals;
    private final int ignoreAbove;
    private final String indexOptions;
    private final FieldType fieldType;
    private final SimilarityProvider similarity;
    private final String normalizerName;
    private final boolean splitQueriesOnWhitespace;
    private final IndexAnalyzers indexAnalyzers;

    private static KeywordFieldMapper toType(FieldMapper in) {
        return (KeywordFieldMapper)in;
    }

    protected KeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) <= 0);
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.nullValue = (String)builder.nullValue.getValue();
        this.eagerGlobalOrdinals = (Boolean)builder.eagerGlobalOrdinals.getValue();
        this.ignoreAbove = (Integer)builder.ignoreAbove.getValue();
        this.indexOptions = (String)builder.indexOptions.getValue();
        this.fieldType = fieldType;
        this.similarity = (SimilarityProvider)builder.similarity.getValue();
        this.normalizerName = (String)builder.normalizer.getValue();
        this.splitQueriesOnWhitespace = (Boolean)builder.splitQueriesOnWhitespace.getValue();
        this.indexAnalyzers = builder.indexAnalyzers;
    }

    public int ignoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected KeywordFieldMapper clone() {
        return (KeywordFieldMapper)super.clone();
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            value = KeywordFieldMapper.normalizeValue(normalizer, this.name(), value);
        }
        BytesRef binaryValue = new BytesRef(value);
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            KeywordField field = new KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
            context.doc().add(field);
            if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        }
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) throws IOException {
        try (TokenStream ts = normalizer.tokenStream(field, value);){
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            if (!ts.incrementToken()) {
                throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + normalizer + " and input \"" + value + "\"");
            }
            String newValue = termAtt.toString();
            if (ts.incrementToken()) {
                throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + normalizer + " and input \"" + value + "\"");
            }
            ts.end();
            String string = newValue;
            return string;
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexAnalyzers).init(this);
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> KeywordFieldMapper.access$1000(KeywordFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> KeywordFieldMapper.access$900(KeywordFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> KeywordFieldMapper.toType(m).fieldType.stored(), false);
        private final ParametrizedFieldMapper.Parameter<String> nullValue = ParametrizedFieldMapper.Parameter.stringParam("null_value", false, m -> KeywordFieldMapper.access$800(KeywordFieldMapper.toType(m)), null).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Boolean> eagerGlobalOrdinals = ParametrizedFieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> KeywordFieldMapper.access$700(KeywordFieldMapper.toType(m)), false);
        private final ParametrizedFieldMapper.Parameter<Integer> ignoreAbove = ParametrizedFieldMapper.Parameter.intParam("ignore_above", true, m -> KeywordFieldMapper.access$600(KeywordFieldMapper.toType(m)), Integer.MAX_VALUE);
        private final ParametrizedFieldMapper.Parameter<String> indexOptions = ParametrizedFieldMapper.Parameter.restrictedStringParam("index_options", false, m -> KeywordFieldMapper.access$500(KeywordFieldMapper.toType(m)), "docs", "freqs");
        private final ParametrizedFieldMapper.Parameter<Boolean> hasNorms = TextParams.norms(false, m -> !KeywordFieldMapper.toType(m).fieldType.omitNorms());
        private final ParametrizedFieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> KeywordFieldMapper.access$300(KeywordFieldMapper.toType(m)));
        private final ParametrizedFieldMapper.Parameter<String> normalizer = ParametrizedFieldMapper.Parameter.stringParam("normalizer", false, m -> KeywordFieldMapper.access$200(KeywordFieldMapper.toType(m)), "default");
        private final ParametrizedFieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = ParametrizedFieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> KeywordFieldMapper.access$100(KeywordFieldMapper.toType(m)), false);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final IndexAnalyzers indexAnalyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
        }

        public Builder(String name) {
            this(name, null);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder normalizer(String normalizerName) {
            this.normalizer.setValue(normalizerName);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.hasNorms, this.similarity, this.normalizer, this.splitQueriesOnWhitespace, this.boost, this.meta);
        }

        private KeywordFieldType buildFieldType(Mapper.BuilderContext context, FieldType fieldType) {
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer searchAnalyzer = Lucene.KEYWORD_ANALYZER;
            String normalizerName = this.normalizer.getValue();
            if (!Objects.equals(normalizerName, "default")) {
                assert (this.indexAnalyzers != null);
                normalizer = this.indexAnalyzers.getNormalizer(normalizerName);
                if (normalizer == null) {
                    throw new MapperParsingException("normalizer [" + normalizerName + "] not found for field [" + this.name + "]");
                }
                searchAnalyzer = this.splitQueriesOnWhitespace.getValue().booleanValue() ? this.indexAnalyzers.getWhitespaceNormalizer(normalizerName) : normalizer;
            } else if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                searchAnalyzer = Lucene.WHITESPACE_ANALYZER;
            }
            return new KeywordFieldType(this.buildFullName(context), fieldType, normalizer, searchAnalyzer, this);
        }

        @Override
        public KeywordFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldtype = new FieldType(Defaults.FIELD_TYPE);
            fieldtype.setOmitNorms(this.hasNorms.getValue() == false);
            fieldtype.setIndexOptions(TextParams.toIndexOptions(this.indexed.getValue(), this.indexOptions.getValue()));
            fieldtype.setStored(this.stored.getValue());
            return new KeywordFieldMapper(this.name, fieldtype, this.buildFieldType(context, fieldtype), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;

        public KeywordFieldType(String name, FieldType fieldType, NamedAnalyzer normalizer, NamedAnalyzer searchAnalyzer, Builder builder) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, fieldType.stored(), (Boolean)builder.hasDocValues.getValue(), new TextSearchInfo(fieldType, (SimilarityProvider)builder.similarity.getValue(), searchAnalyzer, searchAnalyzer), (Map)builder.meta.getValue());
            this.setEagerGlobalOrdinals((Boolean)builder.eagerGlobalOrdinals.getValue());
            this.setIndexAnalyzer(normalizer);
            this.setBoost(((Float)builder.boost.getValue()).floatValue());
            this.ignoreAbove = (Integer)builder.ignoreAbove.getValue();
            this.nullValue = (String)builder.nullValue.getValue();
        }

        public KeywordFieldType(String name, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            super(name, isSearchable, false, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
        }

        public KeywordFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        public KeywordFieldType(String name, FieldType fieldType) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, false, false, new TextSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
        }

        public KeywordFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, false, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.indexAnalyzer();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), mapperService, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return keywordValue;
                    }
                    try {
                        return KeywordFieldMapper.normalizeValue(normalizer, this.name(), keywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }
    }

    public static class KeywordField
    extends Field {
        public KeywordField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

