/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fieldvisitor;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.StoredFieldVisitor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Uid;

public final class IdOnlyFieldVisitor
extends StoredFieldVisitor {
    private String id = null;
    private boolean visited = false;

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.visited) {
            return StoredFieldVisitor.Status.STOP;
        }
        if ("_id".equals(fieldInfo.name)) {
            this.visited = true;
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        assert ("_id".equals(fieldInfo.name)) : fieldInfo;
        if ("_id".equals(fieldInfo.name)) {
            this.id = Uid.decodeId(value);
        }
    }

    public String getId() {
        return this.id;
    }

    public void reset() {
        this.id = null;
        this.visited = false;
    }
}

