/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.cache.request;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.CounterMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.cache.request.RequestCacheStats;

public final class ShardRequestCache {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final CounterMetric hitCount = new CounterMetric();
    final CounterMetric missCount = new CounterMetric();

    public RequestCacheStats stats() {
        return new RequestCacheStats(this.totalMetric.count(), this.evictionsMetric.count(), this.hitCount.count(), this.missCount.count());
    }

    public void onHit() {
        this.hitCount.inc();
    }

    public void onMiss() {
        this.missCount.inc();
    }

    public void onCached(Accountable key, BytesReference value) {
        this.totalMetric.inc(key.ramBytesUsed() + value.ramBytesUsed());
    }

    public void onRemoval(Accountable key, BytesReference value, boolean evicted) {
        if (evicted) {
            this.evictionsMetric.inc();
        }
        long dec = 0L;
        if (key != null) {
            dec += key.ramBytesUsed();
        }
        if (value != null) {
            dec += value.ramBytesUsed();
        }
        this.totalMetric.dec(dec);
    }
}

