/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.recycler;

import java.util.Deque;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.recycler.AbstractRecycler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.recycler.Recycler;

public class DequeRecycler<T>
extends AbstractRecycler<T> {
    final Deque<T> deque;
    final int maxSize;

    public DequeRecycler(Recycler.C<T> c, Deque<T> queue, int maxSize) {
        super(c);
        this.deque = queue;
        this.maxSize = maxSize;
    }

    @Override
    public Recycler.V<T> obtain() {
        T v = this.deque.pollFirst();
        if (v == null) {
            return new DV(this.c.newInstance(), false);
        }
        return new DV(v, true);
    }

    protected boolean beforeRelease() {
        return this.deque.size() < this.maxSize;
    }

    protected void afterRelease(boolean recycled) {
    }

    private class DV
    implements Recycler.V<T> {
        T value;
        final boolean recycled;

        DV(T value, boolean recycled) {
            this.value = value;
            this.recycled = recycled;
        }

        @Override
        public T v() {
            return this.value;
        }

        @Override
        public boolean isRecycled() {
            return this.recycled;
        }

        @Override
        public void close() {
            if (this.value == null) {
                throw new IllegalStateException("recycler entry already released...");
            }
            boolean recycle = DequeRecycler.this.beforeRelease();
            if (recycle) {
                DequeRecycler.this.c.recycle(this.value);
                DequeRecycler.this.deque.addFirst(this.value);
            } else {
                DequeRecycler.this.c.destroy(this.value);
            }
            this.value = null;
            DequeRecycler.this.afterRelease(recycle);
        }
    }
}

