/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoJson;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeometryFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.geometry.Geometry;

public class GeoJsonGeometryFormat
implements GeometryFormat<Geometry> {
    public static final String NAME = "geojson";
    private final GeoJson geoJsonParser;

    public GeoJsonGeometryFormat(GeoJson geoJsonParser) {
        this.geoJsonParser = geoJsonParser;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Geometry fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.geoJsonParser.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (geometry != null) {
            return GeoJson.toXContent(geometry, builder, params);
        }
        return builder.nullValue();
    }

    @Override
    public Object toXContentAsObject(Geometry geometry) {
        return GeoJson.toMap(geometry);
    }
}

