/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.rollup.job.config;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class MetricConfig
implements Validatable,
ToXContentObject {
    static final String NAME = "metrics";
    private static final String FIELD = "field";
    private static final String METRICS = "metrics";
    private static final ConstructingObjectParser<MetricConfig, Void> PARSER = new ConstructingObjectParser("metrics", true, args -> {
        List metrics = (List)args[1];
        return new MetricConfig((String)args[0], metrics);
    });
    private final String field;
    private final List<String> metrics;

    public MetricConfig(String field, List<String> metrics) {
        this.field = field;
        this.metrics = metrics;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.field == null || this.field.isEmpty()) {
            validationException.addValidationError("Field name is required");
        }
        if (this.metrics == null || this.metrics.isEmpty()) {
            validationException.addValidationError("Metrics must be a non-null, non-empty array of strings");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public String getField() {
        return this.field;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD, this.field);
        builder.field("metrics", this.metrics);
        return builder.endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MetricConfig that = (MetricConfig)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.metrics);
    }

    public static MetricConfig fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("metrics", new String[0]));
    }
}

