/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.CategorizationAnalyzerConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.Detector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.PerPartitionCategorizationConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class AnalysisConfig
implements ToXContentObject {
    public static final ParseField ANALYSIS_CONFIG = new ParseField("analysis_config", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField CATEGORIZATION_FIELD_NAME = new ParseField("categorization_field_name", new String[0]);
    public static final ParseField CATEGORIZATION_FILTERS = new ParseField("categorization_filters", new String[0]);
    public static final ParseField CATEGORIZATION_ANALYZER = CategorizationAnalyzerConfig.CATEGORIZATION_ANALYZER;
    public static final ParseField PER_PARTITION_CATEGORIZATION = new ParseField("per_partition_categorization", new String[0]);
    public static final ParseField LATENCY = new ParseField("latency", new String[0]);
    public static final ParseField SUMMARY_COUNT_FIELD_NAME = new ParseField("summary_count_field_name", new String[0]);
    public static final ParseField DETECTORS = new ParseField("detectors", new String[0]);
    public static final ParseField INFLUENCERS = new ParseField("influencers", new String[0]);
    public static final ParseField MULTIVARIATE_BY_FIELDS = new ParseField("multivariate_by_fields", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser(ANALYSIS_CONFIG.getPreferredName(), true, a -> new Builder((List)a[0]));
    private final TimeValue bucketSpan;
    private final String categorizationFieldName;
    private final List<String> categorizationFilters;
    private final CategorizationAnalyzerConfig categorizationAnalyzerConfig;
    private final PerPartitionCategorizationConfig perPartitionCategorizationConfig;
    private final TimeValue latency;
    private final String summaryCountFieldName;
    private final List<Detector> detectors;
    private final List<String> influencers;
    private final Boolean multivariateByFields;

    private AnalysisConfig(TimeValue bucketSpan, String categorizationFieldName, List<String> categorizationFilters, CategorizationAnalyzerConfig categorizationAnalyzerConfig, PerPartitionCategorizationConfig perPartitionCategorizationConfig, TimeValue latency, String summaryCountFieldName, List<Detector> detectors, List<String> influencers, Boolean multivariateByFields) {
        this.detectors = Collections.unmodifiableList(detectors);
        this.bucketSpan = bucketSpan;
        this.latency = latency;
        this.categorizationFieldName = categorizationFieldName;
        this.categorizationAnalyzerConfig = categorizationAnalyzerConfig;
        this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
        this.categorizationFilters = categorizationFilters == null ? null : Collections.unmodifiableList(categorizationFilters);
        this.summaryCountFieldName = summaryCountFieldName;
        this.influencers = Collections.unmodifiableList(influencers);
        this.multivariateByFields = multivariateByFields;
    }

    public TimeValue getBucketSpan() {
        return this.bucketSpan;
    }

    public String getCategorizationFieldName() {
        return this.categorizationFieldName;
    }

    public List<String> getCategorizationFilters() {
        return this.categorizationFilters;
    }

    public CategorizationAnalyzerConfig getCategorizationAnalyzerConfig() {
        return this.categorizationAnalyzerConfig;
    }

    public PerPartitionCategorizationConfig getPerPartitionCategorizationConfig() {
        return this.perPartitionCategorizationConfig;
    }

    public TimeValue getLatency() {
        return this.latency;
    }

    public String getSummaryCountFieldName() {
        return this.summaryCountFieldName;
    }

    public List<Detector> getDetectors() {
        return this.detectors;
    }

    public List<String> getInfluencers() {
        return this.influencers;
    }

    public Boolean getMultivariateByFields() {
        return this.multivariateByFields;
    }

    private static void addIfNotNull(Set<String> fields, String field) {
        if (field != null) {
            fields.add(field);
        }
    }

    public List<String> fields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getFieldName);
    }

    private List<String> collectNonNullAndNonEmptyDetectorFields(Function<Detector, String> fieldGetter) {
        HashSet<String> fields = new HashSet<String>();
        for (Detector d : this.getDetectors()) {
            AnalysisConfig.addIfNotNull(fields, fieldGetter.apply(d));
        }
        fields.remove("");
        return new ArrayList<String>(fields);
    }

    public List<String> byFields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getByFieldName);
    }

    public List<String> overFields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getOverFieldName);
    }

    public List<String> partitionFields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getPartitionFieldName);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.bucketSpan != null) {
            builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan.getStringRep());
        }
        if (this.categorizationFieldName != null) {
            builder.field(CATEGORIZATION_FIELD_NAME.getPreferredName(), this.categorizationFieldName);
        }
        if (this.categorizationFilters != null) {
            builder.field(CATEGORIZATION_FILTERS.getPreferredName(), this.categorizationFilters);
        }
        if (this.categorizationAnalyzerConfig != null) {
            this.categorizationAnalyzerConfig.toXContent(builder, params);
        }
        if (this.perPartitionCategorizationConfig != null) {
            builder.field(PER_PARTITION_CATEGORIZATION.getPreferredName(), this.perPartitionCategorizationConfig);
        }
        if (this.latency != null) {
            builder.field(LATENCY.getPreferredName(), this.latency.getStringRep());
        }
        if (this.summaryCountFieldName != null) {
            builder.field(SUMMARY_COUNT_FIELD_NAME.getPreferredName(), this.summaryCountFieldName);
        }
        builder.startArray(DETECTORS.getPreferredName());
        for (Detector detector : this.detectors) {
            detector.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(INFLUENCERS.getPreferredName(), this.influencers);
        if (this.multivariateByFields != null) {
            builder.field(MULTIVARIATE_BY_FIELDS.getPreferredName(), this.multivariateByFields);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AnalysisConfig that = (AnalysisConfig)object;
        return Objects.equals(this.latency, that.latency) && Objects.equals(this.bucketSpan, that.bucketSpan) && Objects.equals(this.categorizationFieldName, that.categorizationFieldName) && Objects.equals(this.categorizationFilters, that.categorizationFilters) && Objects.equals(this.categorizationAnalyzerConfig, that.categorizationAnalyzerConfig) && Objects.equals(this.perPartitionCategorizationConfig, that.perPartitionCategorizationConfig) && Objects.equals(this.summaryCountFieldName, that.summaryCountFieldName) && Objects.equals(this.detectors, that.detectors) && Objects.equals(this.influencers, that.influencers) && Objects.equals(this.multivariateByFields, that.multivariateByFields);
    }

    public int hashCode() {
        return Objects.hash(this.bucketSpan, this.categorizationFieldName, this.categorizationFilters, this.categorizationAnalyzerConfig, this.perPartitionCategorizationConfig, this.latency, this.summaryCountFieldName, this.detectors, this.influencers, this.multivariateByFields);
    }

    public static Builder builder(List<Detector> detectors) {
        return new Builder(detectors);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Detector.PARSER.apply(p, (Void)c).build(), DETECTORS);
        PARSER.declareString((builder, val) -> builder.setBucketSpan(TimeValue.parseTimeValue(val, BUCKET_SPAN.getPreferredName())), BUCKET_SPAN);
        PARSER.declareString(Builder::setCategorizationFieldName, CATEGORIZATION_FIELD_NAME);
        PARSER.declareStringArray(Builder::setCategorizationFilters, CATEGORIZATION_FILTERS);
        PARSER.declareField(Builder::setCategorizationAnalyzerConfig, (p, c) -> CategorizationAnalyzerConfig.buildFromXContentFragment(p), CATEGORIZATION_ANALYZER, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareObject(Builder::setPerPartitionCategorizationConfig, PerPartitionCategorizationConfig.PARSER, PER_PARTITION_CATEGORIZATION);
        PARSER.declareString((builder, val) -> builder.setLatency(TimeValue.parseTimeValue(val, LATENCY.getPreferredName())), LATENCY);
        PARSER.declareString(Builder::setSummaryCountFieldName, SUMMARY_COUNT_FIELD_NAME);
        PARSER.declareStringArray(Builder::setInfluencers, INFLUENCERS);
        PARSER.declareBoolean(Builder::setMultivariateByFields, MULTIVARIATE_BY_FIELDS);
    }

    public static class Builder {
        private List<Detector> detectors;
        private TimeValue bucketSpan;
        private TimeValue latency;
        private String categorizationFieldName;
        private List<String> categorizationFilters;
        private CategorizationAnalyzerConfig categorizationAnalyzerConfig;
        private PerPartitionCategorizationConfig perPartitionCategorizationConfig;
        private String summaryCountFieldName;
        private List<String> influencers = new ArrayList<String>();
        private Boolean multivariateByFields;

        public Builder(List<Detector> detectors) {
            this.setDetectors(detectors);
        }

        public Builder(AnalysisConfig analysisConfig) {
            this.detectors = new ArrayList<Detector>(analysisConfig.detectors);
            this.bucketSpan = analysisConfig.bucketSpan;
            this.latency = analysisConfig.latency;
            this.categorizationFieldName = analysisConfig.categorizationFieldName;
            this.categorizationFilters = analysisConfig.categorizationFilters == null ? null : new ArrayList(analysisConfig.categorizationFilters);
            this.categorizationAnalyzerConfig = analysisConfig.categorizationAnalyzerConfig;
            this.perPartitionCategorizationConfig = analysisConfig.perPartitionCategorizationConfig;
            this.summaryCountFieldName = analysisConfig.summaryCountFieldName;
            this.influencers = new ArrayList<String>(analysisConfig.influencers);
            this.multivariateByFields = analysisConfig.multivariateByFields;
        }

        public Builder setDetectors(List<Detector> detectors) {
            Objects.requireNonNull(detectors, "[" + DETECTORS.getPreferredName() + "] must not be null");
            int detectorIndex = 0;
            ArrayList<Detector> sequentialIndexDetectors = new ArrayList<Detector>(detectors.size());
            for (Detector origDetector : detectors) {
                Detector.Builder builder = new Detector.Builder(origDetector);
                builder.setDetectorIndex(detectorIndex++);
                sequentialIndexDetectors.add(builder.build());
            }
            this.detectors = sequentialIndexDetectors;
            return this;
        }

        public Builder setDetector(int detectorIndex, Detector detector) {
            this.detectors.set(detectorIndex, detector);
            return this;
        }

        public Builder setBucketSpan(TimeValue bucketSpan) {
            this.bucketSpan = bucketSpan;
            return this;
        }

        public Builder setLatency(TimeValue latency) {
            this.latency = latency;
            return this;
        }

        public Builder setCategorizationFieldName(String categorizationFieldName) {
            this.categorizationFieldName = categorizationFieldName;
            return this;
        }

        public Builder setCategorizationFilters(List<String> categorizationFilters) {
            this.categorizationFilters = categorizationFilters;
            return this;
        }

        public Builder setCategorizationAnalyzerConfig(CategorizationAnalyzerConfig categorizationAnalyzerConfig) {
            this.categorizationAnalyzerConfig = categorizationAnalyzerConfig;
            return this;
        }

        public Builder setPerPartitionCategorizationConfig(PerPartitionCategorizationConfig perPartitionCategorizationConfig) {
            this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
            return this;
        }

        public Builder setSummaryCountFieldName(String summaryCountFieldName) {
            this.summaryCountFieldName = summaryCountFieldName;
            return this;
        }

        public Builder setInfluencers(List<String> influencers) {
            this.influencers = Objects.requireNonNull(influencers, INFLUENCERS.getPreferredName());
            return this;
        }

        public Builder setMultivariateByFields(Boolean multivariateByFields) {
            this.multivariateByFields = multivariateByFields;
            return this;
        }

        public AnalysisConfig build() {
            return new AnalysisConfig(this.bucketSpan, this.categorizationFieldName, this.categorizationFilters, this.categorizationAnalyzerConfig, this.perPartitionCategorizationConfig, this.latency, this.summaryCountFieldName, this.detectors, this.influencers, this.multivariateByFields);
        }
    }
}

