/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

final class SimpleBoundedInputStream
extends InputStream {
    private final InputStream in;
    private final long maxBytes;
    private long numBytes;

    SimpleBoundedInputStream(InputStream inputStream, long maxBytes) {
        this.in = Objects.requireNonNull(inputStream, "inputStream");
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("[maxBytes] must be greater than or equal to 0");
        }
        this.maxBytes = maxBytes;
    }

    @Override
    public int read() throws IOException {
        if (this.numBytes >= this.maxBytes) {
            return -1;
        }
        ++this.numBytes;
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

