/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.PageParams;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;

public class GetTrainedModelsRequest
implements Validatable {
    private static final String DEFINITION = "definition";
    private static final String TOTAL_FEATURE_IMPORTANCE = "total_feature_importance";
    private static final String FEATURE_IMPORTANCE_BASELINE = "feature_importance_baseline";
    public static final String ALLOW_NO_MATCH = "allow_no_match";
    public static final String FOR_EXPORT = "for_export";
    public static final String DECOMPRESS_DEFINITION = "decompress_definition";
    public static final String TAGS = "tags";
    public static final String INCLUDE = "include";
    private final List<String> ids;
    private Boolean allowNoMatch;
    private Set<String> includes = new HashSet<String>();
    private Boolean decompressDefinition;
    private Boolean forExport;
    private PageParams pageParams;
    private List<String> tags;

    public static GetTrainedModelsRequest getAllTrainedModelConfigsRequest() {
        return new GetTrainedModelsRequest("_all");
    }

    public GetTrainedModelsRequest(String ... ids) {
        this.ids = Arrays.asList(ids);
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public GetTrainedModelsRequest setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
        return this;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public GetTrainedModelsRequest setPageParams(@Nullable PageParams pageParams) {
        this.pageParams = pageParams;
        return this;
    }

    public Set<String> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    public GetTrainedModelsRequest includeDefinition() {
        this.includes.add(DEFINITION);
        return this;
    }

    public GetTrainedModelsRequest includeTotalFeatureImportance() {
        this.includes.add(TOTAL_FEATURE_IMPORTANCE);
        return this;
    }

    public GetTrainedModelsRequest includeFeatureImportanceBaseline() {
        this.includes.add(FEATURE_IMPORTANCE_BASELINE);
        return this;
    }

    @Deprecated
    public GetTrainedModelsRequest setIncludeDefinition(Boolean includeDefinition) {
        if (includeDefinition != null && includeDefinition.booleanValue()) {
            return this.includeDefinition();
        }
        return this;
    }

    public Boolean getDecompressDefinition() {
        return this.decompressDefinition;
    }

    public GetTrainedModelsRequest setDecompressDefinition(Boolean decompressDefinition) {
        this.decompressDefinition = decompressDefinition;
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public GetTrainedModelsRequest setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public GetTrainedModelsRequest setTags(String ... tags) {
        return this.setTags(Arrays.asList(tags));
    }

    public Boolean getForExport() {
        return this.forExport;
    }

    public GetTrainedModelsRequest setForExport(Boolean forExport) {
        this.forExport = forExport;
        return this;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.ids == null || this.ids.isEmpty()) {
            return Optional.of(ValidationException.withError("trained model id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTrainedModelsRequest other = (GetTrainedModelsRequest)o;
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.allowNoMatch, other.allowNoMatch) && Objects.equals(this.decompressDefinition, other.decompressDefinition) && Objects.equals(this.includes, other.includes) && Objects.equals(this.forExport, other.forExport) && Objects.equals(this.pageParams, other.pageParams);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.allowNoMatch, this.pageParams, this.decompressDefinition, this.includes, this.forExport);
    }
}

