/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class CloseJobRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField JOB_ID = new ParseField("job_id", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final ParseField FORCE = new ParseField("force", new String[0]);
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    public static final ConstructingObjectParser<CloseJobRequest, Void> PARSER = new ConstructingObjectParser("close_job_request", true, a -> new CloseJobRequest((List)a[0]));
    private static final String ALL_JOBS = "_all";
    private final List<String> jobIds;
    private TimeValue timeout;
    private Boolean force;
    private Boolean allowNoMatch;

    public static CloseJobRequest closeAllJobsRequest() {
        return new CloseJobRequest(ALL_JOBS);
    }

    CloseJobRequest(List<String> jobIds) {
        if (jobIds.isEmpty()) {
            throw new InvalidParameterException("jobIds must not be empty");
        }
        if (jobIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("jobIds must not contain null values");
        }
        this.jobIds = new ArrayList<String>(jobIds);
    }

    public CloseJobRequest(String ... jobIds) {
        this(Arrays.asList(jobIds));
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public Boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.jobIds, this.timeout, this.force, this.allowNoMatch);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CloseJobRequest that = (CloseJobRequest)other;
        return Objects.equals(this.jobIds, that.jobIds) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.force, that.force) && Objects.equals(this.allowNoMatch, that.allowNoMatch);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.jobIds));
        if (this.timeout != null) {
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
        }
        if (this.force != null) {
            builder.field(FORCE.getPreferredName(), this.force);
        }
        if (this.allowNoMatch != null) {
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> Arrays.asList(Strings.commaDelimitedListToStringArray(p.text())), JOB_ID, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareString((obj, val) -> obj.setTimeout(TimeValue.parseTimeValue(val, TIMEOUT.getPreferredName())), TIMEOUT);
        PARSER.declareBoolean(CloseJobRequest::setForce, FORCE);
        PARSER.declareBoolean(CloseJobRequest::setAllowNoMatch, ALLOW_NO_MATCH);
    }
}

