/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indexlifecycle;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indexlifecycle.LifecycleAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class Phase
implements ToXContentObject {
    static final ParseField MIN_AGE = new ParseField("min_age", new String[0]);
    static final ParseField ACTIONS_FIELD = new ParseField("actions", new String[0]);
    private static final ConstructingObjectParser<Phase, String> PARSER = new ConstructingObjectParser<Phase, String>("phase", true, (a, name) -> new Phase((String)name, (TimeValue)a[0], ((List)a[1]).stream().collect(Collectors.toMap(LifecycleAction::getName, Function.identity()))));
    private final String name;
    private final Map<String, LifecycleAction> actions;
    private final TimeValue minimumAge;

    public static Phase parse(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    public Phase(String name, TimeValue minimumAge, Map<String, LifecycleAction> actions) {
        this.name = name;
        this.minimumAge = minimumAge == null ? TimeValue.ZERO : minimumAge;
        this.actions = actions;
    }

    public TimeValue getMinimumAge() {
        return this.minimumAge;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, LifecycleAction> getActions() {
        return this.actions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MIN_AGE.getPreferredName(), this.minimumAge.getStringRep());
        builder.field(ACTIONS_FIELD.getPreferredName(), this.actions);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.minimumAge, this.actions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Phase other = (Phase)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.minimumAge, other.minimumAge) && Objects.equals(this.actions, other.actions);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.text(), MIN_AGE.getPreferredName()), MIN_AGE, ObjectParser.ValueType.VALUE);
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> p.namedObject(LifecycleAction.class, n, null), v -> {
            throw new IllegalArgumentException("ordered " + ACTIONS_FIELD.getPreferredName() + " are not supported");
        }, ACTIONS_FIELD);
    }
}

