/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ResourceNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.FailedNodeException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.NoSuchNodeException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.TaskOperationFailure;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.AtomicArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.NodeShouldNotConnectException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponseHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public abstract class TransportTasksAction<OperationTask extends Task, TasksRequest extends BaseTasksRequest<TasksRequest>, TasksResponse extends BaseTasksResponse, TaskResponse extends Writeable>
extends HandledTransportAction<TasksRequest, TasksResponse> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Writeable.Reader<TasksRequest> requestReader;
    protected final Writeable.Reader<TasksResponse> responsesReader;
    protected final Writeable.Reader<TaskResponse> responseReader;
    protected final String transportNodeAction;

    protected TransportTasksAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<TasksRequest> requestReader, Writeable.Reader<TasksResponse> responsesReader, Writeable.Reader<TaskResponse> responseReader, String nodeExecutor) {
        super(actionName, transportService, actionFilters, requestReader);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportNodeAction = actionName + "[n]";
        this.requestReader = requestReader;
        this.responsesReader = responsesReader;
        this.responseReader = responseReader;
        transportService.registerRequestHandler(this.transportNodeAction, nodeExecutor, x$0 -> new NodeTaskRequest(x$0), new NodeTransportHandler());
    }

    @Override
    protected void doExecute(Task task, TasksRequest request, ActionListener<TasksResponse> listener) {
        new AsyncAction(this, task, (BaseTasksRequest)request, listener).start();
    }

    private void nodeOperation(NodeTaskRequest nodeTaskRequest, final ActionListener<NodeTasksResponse> listener) {
        BaseTasksRequest request = nodeTaskRequest.tasksRequest;
        final ArrayList tasks = new ArrayList();
        this.processTasks(request, tasks::add);
        if (tasks.isEmpty()) {
            listener.onResponse(new NodeTasksResponse(this.clusterService.localNode().getId(), Collections.emptyList(), Collections.emptyList()));
            return;
        }
        final AtomicArray responses = new AtomicArray(tasks.size());
        final AtomicInteger counter = new AtomicInteger(tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            final int taskIndex = i;
            ActionListener taskListener = new ActionListener<TaskResponse>(){

                @Override
                public void onResponse(TaskResponse response) {
                    responses.setOnce(taskIndex, response == null ? null : new Tuple(response, null));
                    this.respondIfFinished();
                }

                @Override
                public void onFailure(Exception e) {
                    responses.setOnce(taskIndex, new Tuple<Object, Exception>(null, e));
                    this.respondIfFinished();
                }

                private void respondIfFinished() {
                    if (counter.decrementAndGet() != 0) {
                        return;
                    }
                    ArrayList<Writeable> results = new ArrayList<Writeable>();
                    ArrayList<TaskOperationFailure> exceptions = new ArrayList<TaskOperationFailure>();
                    for (Tuple response : responses.asList()) {
                        if (response.v1() == null) {
                            assert (response.v2() != null);
                            exceptions.add(new TaskOperationFailure(TransportTasksAction.this.clusterService.localNode().getId(), ((Task)tasks.get(taskIndex)).getId(), (Exception)response.v2()));
                            continue;
                        }
                        assert (response.v2() == null);
                        results.add((Writeable)response.v1());
                    }
                    listener.onResponse(new NodeTasksResponse(TransportTasksAction.this.clusterService.localNode().getId(), results, exceptions));
                }
            };
            try {
                this.taskOperation(request, (Task)tasks.get(taskIndex), taskListener);
                continue;
            }
            catch (Exception e) {
                taskListener.onFailure(e);
            }
        }
    }

    protected String[] filterNodeIds(DiscoveryNodes nodes, String[] nodesIds) {
        return nodesIds;
    }

    protected String[] resolveNodes(TasksRequest request, ClusterState clusterState) {
        if (((BaseTasksRequest)request).getTaskId().isSet()) {
            return new String[]{((BaseTasksRequest)request).getTaskId().getNodeId()};
        }
        return clusterState.nodes().resolveNodes(((BaseTasksRequest)request).getNodes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processTasks(TasksRequest request, Consumer<OperationTask> operation) {
        if (((BaseTasksRequest)request).getTaskId().isSet()) {
            Task task = this.taskManager.getTask(((BaseTasksRequest)request).getTaskId().getId());
            if (task == null) throw new ResourceNotFoundException("task [{}] is missing", ((BaseTasksRequest)request).getTaskId());
            if (!((BaseTasksRequest)request).match(task)) throw new ResourceNotFoundException("task [{}] doesn't support this operation", ((BaseTasksRequest)request).getTaskId());
            operation.accept(task);
            return;
        } else {
            for (Task task : this.taskManager.getTasks().values()) {
                if (!((BaseTasksRequest)request).match(task)) continue;
                operation.accept(task);
            }
        }
    }

    protected abstract TasksResponse newResponse(TasksRequest var1, List<TaskResponse> var2, List<TaskOperationFailure> var3, List<FailedNodeException> var4);

    protected TasksResponse newResponse(TasksRequest request, AtomicReferenceArray responses) {
        ArrayList tasks = new ArrayList();
        ArrayList<FailedNodeException> failedNodeExceptions = new ArrayList<FailedNodeException>();
        ArrayList<TaskOperationFailure> taskOperationFailures = new ArrayList<TaskOperationFailure>();
        for (int i = 0; i < responses.length(); ++i) {
            Object response = responses.get(i);
            if (response instanceof FailedNodeException) {
                failedNodeExceptions.add((FailedNodeException)response);
                continue;
            }
            NodeTasksResponse tasksResponse = (NodeTasksResponse)response;
            if (tasksResponse.results != null) {
                tasks.addAll(tasksResponse.results);
            }
            if (tasksResponse.exceptions == null) continue;
            taskOperationFailures.addAll(tasksResponse.exceptions);
        }
        return this.newResponse(request, tasks, taskOperationFailures, failedNodeExceptions);
    }

    protected abstract void taskOperation(TasksRequest var1, OperationTask var2, ActionListener<TaskResponse> var3);

    private class NodeTaskRequest
    extends TransportRequest {
        private TasksRequest tasksRequest;

        protected NodeTaskRequest(StreamInput in) throws IOException {
            super(in);
            this.tasksRequest = (BaseTasksRequest)TransportTasksAction.this.requestReader.read(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ((BaseTasksRequest)this.tasksRequest).writeTo(out);
        }

        protected NodeTaskRequest(TasksRequest tasksRequest) {
            this.tasksRequest = tasksRequest;
        }
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeTaskRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeTaskRequest request, TransportChannel channel, Task task) throws Exception {
            TransportTasksAction.this.nodeOperation(request, ActionListener.wrap(channel::sendResponse, e -> {
                try {
                    channel.sendResponse((Exception)e);
                }
                catch (IOException e1) {
                    e1.addSuppressed((Throwable)e);
                    TransportTasksAction.this.logger.warn("Failed to send failure", (Throwable)e1);
                }
            }));
        }
    }

    private static class AsyncAction {
        private final TasksRequest request;
        private final String[] nodesIds;
        private final DiscoveryNode[] nodes;
        private final ActionListener<TasksResponse> listener;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        private final Task task;
        final /* synthetic */ TransportTasksAction this$0;

        private AsyncAction(Task task, TasksRequest request, ActionListener<TasksResponse> listener) {
            this.this$0 = var1_1;
            this.task = task;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            String[] nodesIds = var1_1.resolveNodes(request, clusterState);
            this.nodesIds = var1_1.filterNodeIds(clusterState.nodes(), nodesIds);
            ImmutableOpenMap<String, DiscoveryNode> nodes = clusterState.nodes().getNodes();
            this.nodes = new DiscoveryNode[nodesIds.length];
            for (int i = 0; i < this.nodesIds.length; ++i) {
                this.nodes[i] = nodes.get(this.nodesIds[i]);
            }
            this.responses = new AtomicReferenceArray(this.nodesIds.length);
        }

        private void start() {
            if (this.nodesIds.length == 0) {
                try {
                    this.listener.onResponse(this.this$0.newResponse(this.request, this.responses));
                }
                catch (Exception e) {
                    this.this$0.logger.debug("failed to generate empty response", (Throwable)e);
                    this.listener.onFailure(e);
                }
            } else {
                TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
                if (((BaseTasksRequest)this.request).getTimeout() != null) {
                    builder.withTimeout(((BaseTasksRequest)this.request).getTimeout());
                }
                for (int i = 0; i < this.nodesIds.length; ++i) {
                    String nodeId = this.nodesIds[i];
                    final int idx = i;
                    final DiscoveryNode node = this.nodes[i];
                    try {
                        if (node == null) {
                            this.onFailure(idx, nodeId, new NoSuchNodeException(nodeId));
                            continue;
                        }
                        NodeTaskRequest nodeRequest = new NodeTaskRequest(this.this$0, this.request);
                        nodeRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                        this.this$0.transportService.sendRequest(node, this.this$0.transportNodeAction, (TransportRequest)nodeRequest, builder.build(), new TransportResponseHandler<NodeTasksResponse>(){

                            @Override
                            public NodeTasksResponse read(StreamInput in) throws IOException {
                                return AsyncAction.this.this$0.new NodeTasksResponse(in);
                            }

                            @Override
                            public void handleResponse(NodeTasksResponse response) {
                                AsyncAction.this.onOperation(idx, response);
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                AsyncAction.this.onFailure(idx, node.getId(), exp);
                            }

                            @Override
                            public String executor() {
                                return "same";
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        this.onFailure(idx, nodeId, e);
                    }
                }
            }
        }

        private void onOperation(int idx, NodeTasksResponse nodeResponse) {
            this.responses.set(idx, nodeResponse);
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug((Message)new ParameterizedMessage("failed to execute on node [{}]", (Object)nodeId), t);
            }
            this.responses.set(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t));
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            Object finalResponse;
            try {
                finalResponse = this.this$0.newResponse(this.request, this.responses);
            }
            catch (Exception e) {
                this.this$0.logger.debug("failed to combine responses from nodes", (Throwable)e);
                this.listener.onFailure(e);
                return;
            }
            this.listener.onResponse(finalResponse);
        }
    }

    private class NodeTasksResponse
    extends TransportResponse {
        protected String nodeId;
        protected List<TaskOperationFailure> exceptions;
        protected List<TaskResponse> results;

        NodeTasksResponse(StreamInput in) throws IOException {
            int resultsSize;
            super(in);
            this.nodeId = in.readString();
            this.results = new ArrayList(resultsSize);
            for (resultsSize = in.readVInt(); resultsSize > 0; --resultsSize) {
                Writeable result = in.readBoolean() ? (Writeable)TransportTasksAction.this.responseReader.read(in) : null;
                this.results.add(result);
            }
            if (in.readBoolean()) {
                int taskFailures = in.readVInt();
                this.exceptions = new ArrayList<TaskOperationFailure>(taskFailures);
                for (int i = 0; i < taskFailures; ++i) {
                    this.exceptions.add(new TaskOperationFailure(in));
                }
            } else {
                this.exceptions = null;
            }
        }

        NodeTasksResponse(String nodeId, List<TaskResponse> results, List<TaskOperationFailure> exceptions) {
            this.nodeId = nodeId;
            this.results = results;
            this.exceptions = exceptions;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public List<TaskOperationFailure> getExceptions() {
            return this.exceptions;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeVInt(this.results.size());
            for (Writeable result : this.results) {
                if (result != null) {
                    out.writeBoolean(true);
                    result.writeTo(out);
                    continue;
                }
                out.writeBoolean(false);
            }
            out.writeBoolean(this.exceptions != null);
            if (this.exceptions != null) {
                int taskFailures = this.exceptions.size();
                out.writeVInt(taskFailures);
                for (TaskOperationFailure exception : this.exceptions) {
                    exception.writeTo(out);
                }
            }
        }
    }
}

