/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.template.delete;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.template.delete.DeleteComponentTemplateAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeleteComponentTemplateAction
extends TransportMasterNodeAction<DeleteComponentTemplateAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteComponentTemplateAction.class);
    private final MetadataIndexTemplateService indexTemplateService;

    @Inject
    public TransportDeleteComponentTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/component_template/delete", transportService, clusterService, threadPool, actionFilters, DeleteComponentTemplateAction.Request::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(DeleteComponentTemplateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.indexTemplateService.removeComponentTemplate(request.name(), request.masterNodeTimeout(), listener);
    }
}

