/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.iterable.Iterables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.flush.ShardsSyncedFlushResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.flush.SyncedFlushService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public class SyncedFlushResponse
extends ActionResponse
implements ToXContentFragment {
    private final Map<String, List<ShardsSyncedFlushResult>> shardsResultPerIndex;
    private final ShardCounts shardCounts;

    public SyncedFlushResponse(Map<String, List<ShardsSyncedFlushResult>> shardsResultPerIndex) {
        this.shardsResultPerIndex = Collections.unmodifiableMap(shardsResultPerIndex);
        this.shardCounts = SyncedFlushResponse.calculateShardCounts(Iterables.flatten(shardsResultPerIndex.values()));
    }

    public SyncedFlushResponse(StreamInput in) throws IOException {
        super(in);
        this.shardCounts = new ShardCounts(in);
        HashMap tmpShardsResultPerIndex = new HashMap();
        int numShardsResults = in.readInt();
        for (int i = 0; i < numShardsResults; ++i) {
            String index = in.readString();
            ArrayList<ShardsSyncedFlushResult> shardsSyncedFlushResults = new ArrayList<ShardsSyncedFlushResult>();
            int numShards = in.readInt();
            for (int j = 0; j < numShards; ++j) {
                shardsSyncedFlushResults.add(new ShardsSyncedFlushResult(in));
            }
            tmpShardsResultPerIndex.put(index, shardsSyncedFlushResults);
        }
        this.shardsResultPerIndex = Collections.unmodifiableMap(tmpShardsResultPerIndex);
    }

    public int totalShards() {
        return this.shardCounts.total;
    }

    public int failedShards() {
        return this.shardCounts.failed;
    }

    public int successfulShards() {
        return this.shardCounts.successful;
    }

    public RestStatus restStatus() {
        return this.failedShards() == 0 ? RestStatus.OK : RestStatus.CONFLICT;
    }

    public Map<String, List<ShardsSyncedFlushResult>> getShardsResultPerIndex() {
        return this.shardsResultPerIndex;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("_shards");
        this.shardCounts.toXContent(builder, params);
        builder.endObject();
        for (Map.Entry<String, List<ShardsSyncedFlushResult>> indexEntry : this.shardsResultPerIndex.entrySet()) {
            List<ShardsSyncedFlushResult> indexResult = indexEntry.getValue();
            builder.startObject(indexEntry.getKey());
            ShardCounts indexShardCounts = SyncedFlushResponse.calculateShardCounts(indexResult);
            indexShardCounts.toXContent(builder, params);
            if (indexShardCounts.failed > 0) {
                builder.startArray("failures");
                for (ShardsSyncedFlushResult shardResults : indexResult) {
                    if (shardResults.failed()) {
                        builder.startObject();
                        builder.field("shard", shardResults.shardId().id());
                        builder.field("reason", shardResults.failureReason());
                        builder.endObject();
                        continue;
                    }
                    Map<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> failedShards = shardResults.failedShards();
                    for (Map.Entry<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> shardEntry : failedShards.entrySet()) {
                        builder.startObject();
                        builder.field("shard", shardResults.shardId().id());
                        builder.field("reason", shardEntry.getValue().failureReason());
                        builder.field("routing", shardEntry.getKey());
                        builder.endObject();
                    }
                }
                builder.endArray();
            }
            builder.endObject();
        }
        return builder;
    }

    static ShardCounts calculateShardCounts(Iterable<ShardsSyncedFlushResult> results) {
        int total = 0;
        int successful = 0;
        int failed = 0;
        for (ShardsSyncedFlushResult result : results) {
            total += result.totalShards();
            successful += result.successfulShards();
            if (result.failed()) {
                failed += result.totalShards();
                continue;
            }
            failed += result.failedShards().size();
        }
        return new ShardCounts(total, successful, failed);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardCounts.writeTo(out);
        out.writeInt(this.shardsResultPerIndex.size());
        for (Map.Entry<String, List<ShardsSyncedFlushResult>> entry : this.shardsResultPerIndex.entrySet()) {
            out.writeString(entry.getKey());
            out.writeInt(entry.getValue().size());
            for (ShardsSyncedFlushResult shardsSyncedFlushResult : entry.getValue()) {
                shardsSyncedFlushResult.writeTo(out);
            }
        }
    }

    static final class ShardCounts
    implements ToXContentFragment,
    Writeable {
        public final int total;
        public final int successful;
        public final int failed;

        ShardCounts(int total, int successful, int failed) {
            this.total = total;
            this.successful = successful;
            this.failed = failed;
        }

        ShardCounts(StreamInput in) throws IOException {
            this.total = in.readInt();
            this.successful = in.readInt();
            this.failed = in.readInt();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            builder.field("successful", this.successful);
            builder.field("failed", this.failed);
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.total);
            out.writeInt(this.successful);
            out.writeInt(this.failed);
        }
    }

    static final class Fields {
        static final String _SHARDS = "_shards";
        static final String TOTAL = "total";
        static final String SUCCESSFUL = "successful";
        static final String FAILED = "failed";
        static final String FAILURES = "failures";
        static final String SHARD = "shard";
        static final String ROUTING = "routing";
        static final String REASON = "reason";

        Fields() {
        }
    }
}

