/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchGenerationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.alias.Alias;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActiveShardCount;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.MapBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends AcknowledgedRequest<CreateIndexRequest>
implements IndicesRequest,
ToXContentObject {
    public static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    public static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    private String cause = "";
    private String index;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.cause = in.readString();
        this.index = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String type = in.readString();
            String source = in.readString();
            if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
                source = XContentHelper.convertToJson(new BytesArray(source), false, false, XContentFactory.xContentType(source));
            }
            this.mappings.put(type, source);
        }
        if (in.getVersion().before(Version.V_6_5_0)) {
            int customSize = in.readVInt();
            assert (customSize == 0) : "unexpected custom metadata when none is supported";
            if (customSize > 0) {
                throw new IllegalStateException("unexpected custom metadata when none is supported");
            }
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readBoolean();
        }
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    public CreateIndexRequest() {
    }

    public CreateIndexRequest(String index) {
        this(index, Settings.Builder.EMPTY_SETTINGS);
    }

    public CreateIndexRequest(String index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public String index() {
        return this.index;
    }

    public CreateIndexRequest index(String index) {
        this.index = index;
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        this.settings(Strings.toString(builder), builder.contentType());
        return this;
    }

    public CreateIndexRequest settings(Map<String, ?> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public CreateIndexRequest mapping(String type, String source, XContentType xContentType) {
        return this.mapping(type, new BytesArray(source), xContentType);
    }

    private CreateIndexRequest mapping(String type, BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        Map<String, Object> mappingAsMap = XContentHelper.convertToMap(source, false, xContentType).v2();
        return this.mapping(type, mappingAsMap);
    }

    public CreateIndexRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public CreateIndexRequest mapping(String type, XContentBuilder source) {
        return this.mapping(type, BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest mapping(String type, Map<String, ?> source) {
        if (this.mappings.containsKey(type)) {
            throw new IllegalStateException("mappings for type \"" + type + "\" were already defined");
        }
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            this.mappings.put(type, Strings.toString(builder));
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest mapping(String type, Object ... source) {
        this.mapping(type, PutMappingRequest.buildFromSimplifiedDef(type, source));
        return this;
    }

    public CreateIndexRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public CreateIndexRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    public CreateIndexRequest aliases(BytesReference source) {
        CreateIndexRequest createIndexRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                createIndexRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return createIndexRequest;
    }

    public CreateIndexRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public CreateIndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public CreateIndexRequest source(XContentBuilder source) {
        return this.source(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public CreateIndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public CreateIndexRequest source(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        this.source(XContentHelper.convertToMap(source, false, xContentType).v2(), LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public CreateIndexRequest source(Map<String, ?> source, DeprecationHandler deprecationHandler) {
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            String name = entry.getKey();
            if (SETTINGS.match(name, deprecationHandler)) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new ElasticsearchParseException("key [settings] must be an object", new Object[0]);
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (MAPPINGS.match(name, deprecationHandler)) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            if (ALIASES.match(name, deprecationHandler)) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new ElasticsearchParseException("unknown key [{}] for create index", name);
        }
        return this;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.index);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        if (out.getVersion().before(Version.V_6_5_0)) {
            out.writeVInt(0);
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeBoolean(true);
        }
        this.waitForActiveShards.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SETTINGS.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(MAPPINGS.getPreferredName());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            StreamInput stream = new BytesArray(entry.getValue()).streamInput();
            try {
                builder.rawField(entry.getKey(), stream, XContentType.JSON);
            }
            finally {
                if (stream == null) continue;
                ((InputStream)stream).close();
            }
        }
        builder.endObject();
        builder.startObject(ALIASES.getPreferredName());
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

