/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.NotifyOnceListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedConsumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedRunnable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedSupplier;

public interface ActionListener<Response> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }

    public static <T> ActionListener<T> delegateResponse(final ActionListener<T> delegate, final BiConsumer<ActionListener<T>, Exception> bc) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T r) {
                delegate.onResponse(r);
            }

            @Override
            public void onFailure(Exception e) {
                bc.accept(delegate, e);
            }
        };
    }

    public static <T, R> ActionListener<T> delegateFailure(final ActionListener<R> delegate, final BiConsumer<ActionListener<R>, T> bc) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T r) {
                bc.accept(delegate, r);
            }

            @Override
            public void onFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> ActionListener<Response> wrap(Runnable runnable) {
        return ActionListener.wrap(r -> runnable.run(), e -> runnable.run());
    }

    public static <T, Response> ActionListener<Response> map(final ActionListener<T> delegate, final CheckedFunction<Response, T, Exception> fn) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                Object mapped;
                try {
                    mapped = fn.apply(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                    return;
                }
                try {
                    delegate.onResponse(mapped);
                }
                catch (RuntimeException e) {
                    assert (false) : new AssertionError("map: listener.onResponse failed", e);
                    throw e;
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    delegate.onFailure(e);
                }
                catch (RuntimeException ex) {
                    if (ex != e) {
                        ex.addSuppressed(e);
                    }
                    assert (false) : new AssertionError("map: listener.onFailure failed", ex);
                    throw ex;
                }
            }
        };
    }

    public static <Response> BiConsumer<Response, Exception> toBiConsumer(ActionListener<Response> listener) {
        return (response, throwable) -> {
            if (throwable == null) {
                listener.onResponse(response);
            } else {
                listener.onFailure((Exception)throwable);
            }
        };
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    listener.onFailure(ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> ActionListener<Response> runAfter(final ActionListener<Response> delegate, final Runnable runAfter) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    delegate.onResponse(response);
                }
                finally {
                    runAfter.run();
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    delegate.onFailure(e);
                }
                finally {
                    runAfter.run();
                }
            }
        };
    }

    public static <Response> ActionListener<Response> runBefore(final ActionListener<Response> delegate, final CheckedRunnable<?> runBefore) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    delegate.onFailure(ex);
                    return;
                }
                delegate.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> ActionListener<Response> notifyOnce(final ActionListener<Response> delegate) {
        return new NotifyOnceListener<Response>(){

            @Override
            protected void innerOnResponse(Response response) {
                delegate.onResponse(response);
            }

            @Override
            protected void innerOnFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> void completeWith(ActionListener<Response> listener, CheckedSupplier<Response, ? extends Exception> supplier) {
        Response response;
        try {
            response = supplier.get();
        }
        catch (Exception e) {
            try {
                listener.onFailure(e);
            }
            catch (RuntimeException ex) {
                if (!8.$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                throw ex;
            }
            return;
        }
        try {
            listener.onResponse(response);
        }
        catch (RuntimeException ex) {
            if (!8.$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            throw ex;
        }
    }

    static {
        if (8.$assertionsDisabled) {
            // empty if block
        }
    }
}

