/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.BKDConfig;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointValue;

public final class HeapPointReader
implements PointReader {
    private int curRead;
    final byte[] block;
    final BKDConfig config;
    final int end;
    private final HeapPointValue pointValue;

    public HeapPointReader(BKDConfig config, byte[] block, int start, int end) {
        this.block = block;
        this.curRead = start - 1;
        this.end = end;
        this.config = config;
        this.pointValue = start < end ? new HeapPointValue(config, block) : null;
    }

    @Override
    public boolean next() {
        ++this.curRead;
        return this.curRead < this.end;
    }

    @Override
    public PointValue pointValue() {
        this.pointValue.setOffset(this.curRead * this.config.bytesPerDoc);
        return this.pointValue;
    }

    @Override
    public void close() {
    }

    static class HeapPointValue
    implements PointValue {
        final BytesRef packedValue;
        final BytesRef packedValueDocID;
        final int packedValueLength;

        HeapPointValue(BKDConfig config, byte[] value) {
            this.packedValueLength = config.packedBytesLength;
            this.packedValue = new BytesRef(value, 0, this.packedValueLength);
            this.packedValueDocID = new BytesRef(value, 0, config.bytesPerDoc);
        }

        public void setOffset(int offset) {
            this.packedValue.offset = offset;
            this.packedValueDocID.offset = offset;
        }

        @Override
        public BytesRef packedValue() {
            return this.packedValue;
        }

        @Override
        public int docID() {
            int position = this.packedValueDocID.offset + this.packedValueLength;
            return (this.packedValueDocID.bytes[position] & 0xFF) << 24 | (this.packedValueDocID.bytes[++position] & 0xFF) << 16 | (this.packedValueDocID.bytes[++position] & 0xFF) << 8 | this.packedValueDocID.bytes[++position] & 0xFF;
        }

        @Override
        public BytesRef packedValueDocIDBytes() {
            return this.packedValueDocID;
        }
    }
}

