/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.util.concurrent.atomic.AtomicReference;

public final class SetOnce<T>
implements Cloneable {
    private final AtomicReference<Wrapper<T>> set;

    public SetOnce() {
        this.set = new AtomicReference();
    }

    public SetOnce(T obj) {
        this.set = new AtomicReference(new Wrapper(obj));
    }

    public final void set(T obj) {
        if (!this.trySet(obj)) {
            throw new AlreadySetException();
        }
    }

    public final boolean trySet(T obj) {
        return this.set.compareAndSet(null, new Wrapper(obj));
    }

    public final T get() {
        Wrapper<T> wrapper = this.set.get();
        return (T)(wrapper == null ? null : ((Wrapper)wrapper).object);
    }

    private static final class Wrapper<T> {
        private T object;

        private Wrapper(T object) {
            this.object = object;
        }
    }

    public static final class AlreadySetException
    extends IllegalStateException {
        public AlreadySetException() {
            super("The object cannot be set twice!");
        }
    }
}

