/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.FSDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.FileSwitchDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.FilterDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.RAMDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Constants;

public final class IOUtils {
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private IOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        IOUtils.close(Arrays.asList(objects));
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t) {
                th = IOUtils.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        IOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        Throwable firstError = null;
        Throwable firstThrowable = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (VirtualMachineError e) {
                firstError = IOUtils.useOrSuppress(firstError, e);
            }
            catch (Throwable t) {
                firstThrowable = IOUtils.useOrSuppress(firstThrowable, t);
            }
        }
        if (firstError != null) {
            if (firstThrowable != null) {
                firstError.addSuppressed(firstThrowable);
            }
            throw firstError;
        }
    }

    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getDecodingReader(Class<?> clazz, String resource, Charset charSet) throws IOException {
        Reader reader;
        block3: {
            InputStream stream = null;
            boolean success = false;
            try {
                stream = clazz.getResourceAsStream(resource);
                Reader reader2 = IOUtils.getDecodingReader(stream, charSet);
                success = true;
                reader = reader2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close(stream);
                }
                throw throwable;
            }
            IOUtils.close(stream);
        }
        return reader;
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, Collection<String> files) {
        for (String name : files) {
            try {
                dir.deleteFile(name);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        IOUtils.deleteFilesIgnoringExceptions(dir, Arrays.asList(files));
    }

    public static void deleteFiles(Directory dir, Collection<String> names) throws IOException {
        Throwable th = null;
        for (String name : names) {
            if (name == null) continue;
            try {
                dir.deleteFile(name);
            }
            catch (Throwable t) {
                th = IOUtils.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static void deleteFilesIgnoringExceptions(Path ... files) {
        IOUtils.deleteFilesIgnoringExceptions(Arrays.asList(files));
    }

    public static void deleteFilesIgnoringExceptions(Collection<? extends Path> files) {
        for (Path path : files) {
            if (path == null) continue;
            try {
                Files.delete(path);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIfExist(Path ... files) throws IOException {
        IOUtils.deleteFilesIfExist(Arrays.asList(files));
    }

    public static void deleteFilesIfExist(Collection<? extends Path> files) throws IOException {
        Throwable th = null;
        for (Path path : files) {
            try {
                if (path == null) continue;
                Files.deleteIfExists(path);
            }
            catch (Throwable t) {
                th = IOUtils.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static void rm(Path ... locations) throws IOException {
        LinkedHashMap<Path, Throwable> unremoved = IOUtils.rm(new LinkedHashMap<Path, Throwable>(), locations);
        if (!unremoved.isEmpty()) {
            StringBuilder b = new StringBuilder("Could not remove the following files (in the order of attempts):\n");
            for (Map.Entry<Path, Throwable> kv : unremoved.entrySet()) {
                b.append("   ").append(kv.getKey().toAbsolutePath()).append(": ").append(kv.getValue()).append("\n");
            }
            throw new IOException(b.toString());
        }
    }

    private static LinkedHashMap<Path, Throwable> rm(final LinkedHashMap<Path, Throwable> unremoved, Path ... locations) {
        if (locations != null) {
            for (Path location : locations) {
                if (location == null || !Files.exists(location, new LinkOption[0])) continue;
                try {
                    Files.walkFileTree(location, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException impossible) throws IOException {
                            assert (impossible == null);
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                unremoved.put(dir, e);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            try {
                                Files.delete(file);
                            }
                            catch (IOException exc) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            if (exc != null) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException impossible) {
                    throw new AssertionError("visitor threw exception", impossible);
                }
            }
        }
        return unremoved;
    }

    public static Error rethrowAlways(Throwable th) throws IOException, RuntimeException {
        if (th == null) {
            throw new AssertionError((Object)"rethrow argument must not be null.");
        }
        if (th instanceof IOException) {
            throw (IOException)th;
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        throw new RuntimeException(th);
    }

    @Deprecated
    public static void reThrow(Throwable th) throws IOException {
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    @Deprecated
    public static void reThrowUnchecked(Throwable th) {
        if (th != null) {
            if (th instanceof Error) {
                throw (Error)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void fsync(Path fileToSync, boolean isDir) throws IOException {
        if (isDir && Constants.WINDOWS) {
            if (!Files.exists(fileToSync, new LinkOption[0])) {
                throw new NoSuchFileException(fileToSync.toString());
            }
            return;
        }
        Throwable throwable = null;
        try (FileChannel file = FileChannel.open(fileToSync, isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            try {
                file.force(true);
            }
            catch (IOException e) {
                if (isDir) {
                    assert (!(Constants.LINUX || Constants.MAC_OS_X)) : "On Linux and MacOSX fsyncing a directory should not throw IOException, we just don't want to rely on that in production (undocumented). Got: " + e;
                    if (file != null) {
                        if (throwable != null) {
                            try {
                                file.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            file.close();
                        }
                    }
                    return;
                }
                try {
                    throw e;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    public static boolean spins(Directory dir) throws IOException {
        if ((dir = FilterDirectory.unwrap(dir)) instanceof FileSwitchDirectory) {
            FileSwitchDirectory fsd = (FileSwitchDirectory)dir;
            return IOUtils.spins(fsd.getPrimaryDir()) || IOUtils.spins(fsd.getSecondaryDir());
        }
        if (dir instanceof RAMDirectory) {
            return false;
        }
        if (dir instanceof FSDirectory) {
            return IOUtils.spins(((FSDirectory)dir).getDirectory());
        }
        return true;
    }

    public static boolean spins(Path path) throws IOException {
        path = path.toRealPath(new LinkOption[0]);
        if (!Constants.LINUX) {
            return true;
        }
        try {
            return IOUtils.spinsLinux(path);
        }
        catch (Exception exc) {
            return true;
        }
    }

    static boolean spinsLinux(Path path) throws IOException {
        FileStore store = IOUtils.getFileStore(path);
        if ("tmpfs".equals(store.type())) {
            return false;
        }
        String devName = store.name();
        if (!devName.startsWith("/")) {
            return true;
        }
        devName = path.getRoot().resolve(devName).toRealPath(new LinkOption[0]).getFileName().toString();
        Path sysinfo = path.getRoot().resolve("sys").resolve("block");
        Path devsysinfo = null;
        int matchlen = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(sysinfo);){
            for (Path device : stream) {
                String name = device.getFileName().toString();
                if (name.length() <= matchlen || !devName.startsWith(name)) continue;
                devsysinfo = device;
                matchlen = name.length();
            }
        }
        if (devsysinfo == null) {
            return true;
        }
        Path rotational = devsysinfo.resolve("queue").resolve("rotational");
        InputStream stream = Files.newInputStream(rotational, new OpenOption[0]);
        Object object = null;
        try {
            boolean bl = stream.read() == 49;
            return bl;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    static FileStore getFileStore(Path path) throws IOException {
        FileStore store = Files.getFileStore(path);
        String mount = IOUtils.getMountPoint(store);
        FileStore sameMountPoint = null;
        for (FileStore fs : path.getFileSystem().getFileStores()) {
            if (!mount.equals(IOUtils.getMountPoint(fs))) continue;
            if (sameMountPoint == null) {
                sameMountPoint = fs;
                continue;
            }
            return store;
        }
        if (sameMountPoint != null) {
            return sameMountPoint;
        }
        return store;
    }

    static String getMountPoint(FileStore store) {
        String desc = store.toString();
        int index = desc.lastIndexOf(" (");
        if (index != -1) {
            return desc.substring(0, index);
        }
        return desc;
    }

    public static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }

    public static <T> void applyToAll(Collection<T> collection, IOConsumer<T> consumer) throws IOException {
        IOUtils.close(collection.stream().filter(Objects::nonNull).map(t -> () -> consumer.accept(t))::iterator);
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

