/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.BaseDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBufferGuard;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBufferIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.LockFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitUtil;

public final class ByteBuffersDirectory
extends BaseDirectory {
    public static final BiFunction<String, ByteBuffersDataOutput, IndexInput> OUTPUT_AS_MANY_BUFFERS = (fileName, output) -> {
        ByteBuffersDataInput dataInput = output.toDataInput();
        String inputName = String.format(Locale.ROOT, "%s (file=%s, buffers=%s)", ByteBuffersIndexInput.class.getSimpleName(), fileName, dataInput.toString());
        return new ByteBuffersIndexInput(dataInput, inputName);
    };
    public static final BiFunction<String, ByteBuffersDataOutput, IndexInput> OUTPUT_AS_ONE_BUFFER = (fileName, output) -> {
        ByteBuffersDataInput dataInput = new ByteBuffersDataInput(Arrays.asList(ByteBuffer.wrap(output.toArrayCopy())));
        String inputName = String.format(Locale.ROOT, "%s (file=%s, buffers=%s)", ByteBuffersIndexInput.class.getSimpleName(), fileName, dataInput.toString());
        return new ByteBuffersIndexInput(dataInput, inputName);
    };
    public static final BiFunction<String, ByteBuffersDataOutput, IndexInput> OUTPUT_AS_BYTE_ARRAY = OUTPUT_AS_ONE_BUFFER;
    public static final BiFunction<String, ByteBuffersDataOutput, IndexInput> OUTPUT_AS_MANY_BUFFERS_LUCENE = (fileName, output) -> {
        ArrayList<ByteBuffer> bufferList = output.toBufferList();
        bufferList.add(ByteBuffer.allocate(0));
        int blockSize = ByteBuffersDataInput.determineBlockPage(bufferList);
        int chunkSizePower = blockSize == 0 ? 30 : Integer.numberOfTrailingZeros(BitUtil.nextHighestPowerOfTwo(blockSize));
        String inputName = String.format(Locale.ROOT, "%s (file=%s)", ByteBuffersDirectory.class.getSimpleName(), fileName);
        ByteBufferGuard guard = new ByteBufferGuard("none", (resourceDescription, b) -> {});
        return ByteBufferIndexInput.newInstance(inputName, bufferList.toArray(new ByteBuffer[bufferList.size()]), output.size(), chunkSizePower, guard);
    };
    private final Function<String, String> tempFileName = new Function<String, String>(){
        private final AtomicLong counter = new AtomicLong();

        @Override
        public String apply(String suffix) {
            return suffix + "_" + Long.toString(this.counter.getAndIncrement(), 36);
        }
    };
    private final ConcurrentHashMap<String, FileEntry> files = new ConcurrentHashMap();
    private final BiFunction<String, ByteBuffersDataOutput, IndexInput> outputToInput;
    private final Supplier<ByteBuffersDataOutput> bbOutputSupplier;

    public ByteBuffersDirectory() {
        this(new SingleInstanceLockFactory());
    }

    public ByteBuffersDirectory(LockFactory lockFactory) {
        this(lockFactory, ByteBuffersDataOutput::new, OUTPUT_AS_MANY_BUFFERS);
    }

    public ByteBuffersDirectory(LockFactory factory, Supplier<ByteBuffersDataOutput> bbOutputSupplier, BiFunction<String, ByteBuffersDataOutput, IndexInput> outputToInput) {
        super(factory);
        this.outputToInput = Objects.requireNonNull(outputToInput);
        this.bbOutputSupplier = Objects.requireNonNull(bbOutputSupplier);
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return (String[])this.files.keySet().stream().sorted().toArray(String[]::new);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        FileEntry removed = this.files.remove(name);
        if (removed == null) {
            throw new NoSuchFileException(name);
        }
    }

    @Override
    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        FileEntry file = this.files.get(name);
        if (file == null) {
            throw new NoSuchFileException(name);
        }
        return file.length();
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        FileEntry e = new FileEntry(name);
        if (this.files.putIfAbsent(name, e) != null) {
            throw new FileAlreadyExistsException("File already exists: " + name);
        }
        return e.createOutput(this.outputToInput);
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        FileEntry e;
        String name;
        this.ensureOpen();
        while (this.files.putIfAbsent(name = IndexFileNames.segmentFileName(prefix, this.tempFileName.apply(suffix), "tmp"), e = new FileEntry(name)) != null) {
        }
        return e.createOutput(this.outputToInput);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.ensureOpen();
        FileEntry file = this.files.get(source);
        if (file == null) {
            throw new NoSuchFileException(source);
        }
        if (this.files.putIfAbsent(dest, file) != null) {
            throw new FileAlreadyExistsException(dest);
        }
        if (!this.files.remove(source, file)) {
            throw new IllegalStateException("File was unexpectedly replaced: " + source);
        }
        this.files.remove(source);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
    }

    @Override
    public void syncMetaData() throws IOException {
        this.ensureOpen();
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        FileEntry e = this.files.get(name);
        if (e == null) {
            throw new NoSuchFileException(name);
        }
        return e.openInput();
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
        this.files.clear();
    }

    @Override
    public Set<String> getPendingDeletions() {
        return Collections.emptySet();
    }

    private final class FileEntry {
        private final String fileName;
        private volatile IndexInput content;
        private volatile long cachedLength;

        public FileEntry(String name) {
            this.fileName = name;
        }

        public long length() {
            return this.cachedLength;
        }

        public IndexInput openInput() throws IOException {
            IndexInput local = this.content;
            if (local == null) {
                throw new AccessDeniedException("Can't open a file still open for writing: " + this.fileName);
            }
            return local.clone();
        }

        final IndexOutput createOutput(BiFunction<String, ByteBuffersDataOutput, IndexInput> outputToInput) throws IOException {
            if (this.content != null) {
                throw new IOException("Can only write to a file once: " + this.fileName);
            }
            String clazzName = ByteBuffersDirectory.class.getSimpleName();
            String outputName = String.format(Locale.ROOT, "%s output (file=%s)", clazzName, this.fileName);
            return new ByteBuffersIndexOutput((ByteBuffersDataOutput)ByteBuffersDirectory.this.bbOutputSupplier.get(), outputName, this.fileName, new CRC32(), output -> {
                this.content = (IndexInput)outputToInput.apply(this.fileName, (ByteBuffersDataOutput)output);
                this.cachedLength = output.size();
            });
        }
    }
}

